
#include "tca/libc.h"

#include "tca.h"

static void dockHnd(TCA_REF_PTR ref, char *data)
{
  TCA_REF_PTR gmove;

  tcaAddExceptionHandler(ref, "H1");

  tcaExpandGoal("goNearMsg", NULL);

  gmove = tcaCreateReference("gmoveMsg");

  tcaAddExceptionHandler(gmove, "H2");

  tcaAddExceptionHandler(gmove, "H3");

  tcaExecuteCommandWithConstraints(gmove, "gmoveMsg", NULL, SEQ_ACH);

  tcaSuccess(ref);
}


static void H1(TCA_REF_PTR ref, char *data)
{
  EXC_INFO_TYPE excInfo;

  tcaGetExceptionInfo(ref, &excInfo);

  printf("H1:%d\n", excInfo.numOfRetries);
  printf("ERef: %s\n", tcaReferenceName(excInfo.ERef));
  printf("CRef: %s\n", tcaReferenceName(excInfo.CRef));
  fflush(stdout);

  if (excInfo.numOfRetries < 5)
    tcaRetry(excInfo.CRef);
  else
    tcaFailure(ref, "give up the ghost ...", NULL);

  /*  tcaSuccess(ref);*/

  /* tcaByPassException(ref);*/
}


static void H2(TCA_REF_PTR ref, char *data)
{
  printf("H2\n");
  fflush(stdout);
  
/*  tcaSuccess(ref);*/

  tcaByPassException(ref); 
}

static void H3(TCA_REF_PTR ref, char *data)
{
  EXC_INFO_TYPE excInfo;

  tcaGetExceptionInfo(ref, &excInfo);

  printf("H3:%d\n", excInfo.numOfRetries);
  printf("ERef: %s\n", tcaReferenceName(excInfo.ERef));
  printf("CRef: %s\n", tcaReferenceName(excInfo.CRef));
  fflush(stdout);

/*
  if (excInfo.numOfRetries < 5)
    tcaRetry(excInfo.CRef);
  else
    tcaFailure(ref, "give up the ghost ...", NULL);
*/
  /* tcaSuccess(ref);*/

/*  tcaGetExceptionInfo(ref, &excInfo);*/
/*
  tcaRetry(ref);
*/
  tcaByPassException(ref); 
}

static void goNearHnd(TCA_REF_PTR ref, char *data)
{
  printf("goNearHnd\n");
  fflush(stdout);

  tcaSuccess(ref);
}

static void gmoveHnd(TCA_REF_PTR ref, char *data)
{
  printf("gmoveHnd\n");
  fflush(stdout);

  tcaFailure(ref, "failMsg", NULL);
}

#if defined(VXWORKS)
void t2(char *host)
#else
void main(int argc, char **argv)
#endif
{
  printf("connect .. \n");
  fflush(stdout);

#if defined(VXWORKS)
  tcaConnectModule("t2", host);
#else
  tcaConnectModule("t2", tcaServerMachine());
#endif

  tcaRegisterGoal("goNearMsg", NULL, goNearHnd);

  tcaRegisterCommand("dockMsg", NULL, dockHnd);

  tcaRegisterCommand("gmoveMsg", NULL, gmoveHnd);  

  tcaRegisterExceptionMessage("failMsg", NULL);
  tcaRegisterHandler("failMsg", "H1", H1);
  tcaRegisterHandler("failMsg", "H2", H2);
  tcaRegisterHandler("failMsg", "H3", H3);

/*
  tcaRegisterExceptionMessage("failMsg2", NULL);
  tcaRegisterHandler("failMsg2", "H3", H3);
*/

  tcaWaitUntilReady();

  tcaExecuteCommand("dockMsg", NULL);

  tcaModuleListen();
}


  
