/*****************************************************************************
 *
 * (c) Copyright 1994. National Aeronautics and Space Administration.
 *     Ames Research Center, Moffett Field, CA 94035-1000 
 *
 * FILE:     sender.c
 *
 * ABSTRACT: simple TCA example (based on an example in the TCX 7.7 manual)
 *
 * REVISION HISTORY:
 *
 * 11-Feb-94 Terry Fong. Created.
 *
 *****************************************************************************/

#include "tca/libc.h"		
#include "tca.h"		/* TCA function declarations */

#include "common.h"		/* common definitions */

float sslCalcTimevalDiff (struct timeval *pT1, struct timeval *pT2);

static int reply = 1;


/******************************************************************************
 * main ()
 *****************************************************************************/
int main (int argc, char *argv[])
{
  struct timeval sTime, eTime;
  float *data;
  int i, j, nBytes;
  float secs;
  struct {
    char *msgName; int msgSize;
  } messages[] = {
    { "NullMsg", 	0                    },
    { "Float4Msg", 	sizeof(float)*4      },
    { "Float64Msg",	sizeof(float)*64     },
    { "Float256Msg",	sizeof(float)*256    },
    { "Float1KMsg",	sizeof(float)*1024   },
    { "Float4KMsg",	sizeof(float)*4096   },
    { "Float16KMsg",	sizeof(float)*16384  },
    { "Float64KMsg",	sizeof(float)*65536  },
    { "Float256KMsg",	sizeof(float)*262144 },
    { "" }
  };
  
  data = malloc(MAX_DATA_SIZE);
  
  for (j = 0; j<MAX_DATA_SIZE/sizeof(float); j++)
    data[j] = (float) j;

  /*
   * Connect this module to the TCA Server (specified by the CENTRALHOST
   * shell variable).
   */
  
  tcaConnectModule ("sender", tcaServerMachine());
  tcaModuleRequires("receiver", NULL);
  tcaWaitUntilReady();
  
  
  for (j=0; *messages[j].msgName; j++) {
    printf ("\nSending %d <%s> Queries...\n", NSEND, messages[j].msgName);
    fflush(stdout);
    /* Send initial one to prime the pump.  */
    tcaQuery(messages[j].msgName, data, &reply);
    gettimeofday (&sTime, NULL);
    for (i=0; i<NSEND; i++) {
      tcaQuery(messages[j].msgName, data, &reply);
    }
    gettimeofday (&eTime, NULL);
    secs = sslCalcTimevalDiff (&eTime, &sTime);
    nBytes = messages[j].msgSize*NSEND;
    
    printf ("Sent %d bytes in %.2f seconds (%.2f bytes/sec)\n",
	    nBytes, secs, (float) nBytes / secs);
    printf ("%d Query messages (%d bytes each) at %.0f Queries/sec\n",
	    NSEND, messages[j].msgSize, (float) NSEND / secs);
    fflush(stdout);
  }
  
  /* shut down */
  printf ("\n");
  fflush(stdout);
  exit (0);
}

/******************************************************************************
 *
 * sslCalcTimevalDiff - calculate the difference between two timevals in
 * seconds
 *
 * INPUTS:
 *   pT1		pointer to first timeval
 *   pT2		pointer to first timeval
 *
 * RETURNS:
 *   Difference between timevals in seconds (pT1 - pT2)
 *
 *****************************************************************************/
float
sslCalcTimevalDiff (struct timeval *pT1, struct timeval *pT2)
{
  return ((float) (pT1->tv_sec - pT2->tv_sec) +
          ((float) (pT1->tv_usec - pT2->tv_usec)) / 1000000.0);
}
