typedef char *StringType;

typedef struct {
  int x;
  StringType s;
} SampleType, *SamplePtr;

typedef struct {
  int silly;
  double *x;
  double *y;
  int n;
} PolyType, *PolyPtr;

typedef int ReplyType, *ReplyPtr;

static StringType SampleDataForm = "{4, string}";

static StringType PolyDataForm = "{4,polygon}";

static StringType ReplyDataForm = "int";

/****************************************/

/* link example */

typedef struct _s2 {
  int a;
  int b;
  struct _s2 *next;
  StringType s;
} s2Type, *s2Ptr;

static StringType s2TypeForm = "{int, int, *!, string}";

#define FIXED_ARRAY_DIM1 2
#define FIXED_ARRAY_DIM2 3

typedef int two_d_array[FIXED_ARRAY_DIM1][FIXED_ARRAY_DIM2];

static StringType two_d_array_form = "[int : 2, 3]";

#define VAR_ARRAY_DIM1 3
#define VAR_ARRAY_DIM2 2

typedef struct { int         dim1;
		 int         dim2;
		 /* variable length (2D) array of strings */
		 StringType *elements; 
	       } var_two_d_array;

static StringType var_two_d_array_form = "{int, int, <string : 1, 2>}";


/* For Structured Formatters */

typedef struct {
  float x, y, z;
} point;

typedef struct {
  int   leg_no;
  StringType name;
  point pt1, pt2;
} two_points;

typedef struct {
  point       points[6];
  int         length;
  two_points *more_points;
  point      *pt_ptr;
} complex_points;

typedef struct {
  int x;
  char a;
  double y;
} STRUCT_TEST1_TYPE, *STRUCT_TEST1_PTR;

typedef struct {
  int x;
  double y;
  char a;
} STRUCT_TEST2_TYPE, *STRUCT_TEST2_PTR;

typedef struct {
  int x;
  char a;
} STRUCT_TEST3_TYPE, *STRUCT_TEST3_PTR;

typedef struct {
  int w;
  STRUCT_TEST3_TYPE t;
  double z;
} STRUCT_TEST4_TYPE, *STRUCT_TEST4_PTR;

static char *TEST1_FORM = "{int, char, double}";
static char *TEST2_FORM = "{int, double, char}";
static char *TEST3_FORM = "{int, char}";
static char *TEST4_FORM = "{int, {int, char}, double}";

static char *point_format = "{float, float, float}";
static char *two_points_format = "{int, string, point, point}";
static char *complex_points_format = 
"{[point:6], int, <two_points:2>, *point}";

#include "tca/tcaMatrix.h"

