/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/sample.h,v $ 
 * $Revision: 1.8 $
 * $Date: 1996/01/27 21:55:39 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: sample.h,v $
 * Revision 1.8  1996/01/27  21:55:39  rich
 * Pre-release of 8.4.
 * Added test for recursive named types.
 * Iain's windows changes.
 *
 * Revision 1.7  1995/07/10  16:20:05  rich
 * Interm save.
 *
 * Revision 1.6  1994/11/02  21:36:49  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Made libc.h and tcaMatrix.h module includes.
 *
 * Revision 1.5  1994/05/17  23:20:48  rich
 * Added global variable test routines a1_var and b1_var.  Also make some
 * changes so it would compile on an sgi machine.
 *
 * Revision 1.4  1994/04/16  19:47:12  rich
 * First release of TCA for the DEC alpha.
 *
 * New tests for variable length arrays.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.3  1994/01/31  19:15:24  reids
 * Minor cleanup to code.
 *
 * Revision 1.2  1993/05/27  22:23:15  rich
 * Added automatic logging.
 *
 *****************************************************************************/

#ifndef INCsample
#define INCsample

typedef char *StringType;

typedef struct {
  int32 x;
  StringType s;
} SampleType, *SamplePtr;

typedef struct {
  int32 silly;
  float *x;
  float *y;
  int n;
} PolyType, *PolyPtr;
  
typedef int32 ReplyType, *ReplyPtr;

#define SampleVarName "SampleVar"

#define SampleDataForm "{int, string}"

#define PolyDataForm "{int,polygon}"

#define ReplyDataForm "int"

/****************************************/

/* link example */

typedef struct _s2 {
  int32 a;
  int32 b;
  struct _s2 *next;
  StringType s;
} s2Type, *s2Ptr;

#define s2TypeForm "{int, int, *!, string}"

#define FIXED_ARRAY_DIM1 2
#define FIXED_ARRAY_DIM2 3

typedef int32 two_d_array[FIXED_ARRAY_DIM1][FIXED_ARRAY_DIM2];

#define two_d_array_form "[int : 2, 3]"

#define VAR_ARRAY_DIM1 3
#define VAR_ARRAY_DIM2 2

typedef struct 
{ int32         dim1;
  /* variable length array of strings */
  StringType *elements1; 
  int32 dim2;
  StringType *elements2; 
} var_array;

typedef struct 
{ int32         dim1;
  int32         dim2;
  /* variable length (2D) array of strings */
  StringType *elements; 
} var_two_d_array;

#define var_array_form "{int, <string : 1>,int, <string : 3>}"

#define var_two_d_array_form "{int, int, <string : 1, 2>}"


/* For Structured Formatters */

typedef struct {
  float x, y, z;
} point;

typedef struct {
  int32   leg_no;
  StringType name;
  point pt1, pt2;
} two_points;

typedef struct {
  point       points[6];
  int32         length;
  two_points *more_points;
  point      *pt_ptr;
} complex_points;

typedef struct {
  int32 x;
  char a;
  double y;
} STRUCT_TEST1_TYPE, *STRUCT_TEST1_PTR;

typedef struct {
  int32 x;
  double y;
  char a;
} STRUCT_TEST2_TYPE, *STRUCT_TEST2_PTR;
  
typedef struct {
  int32 x;
  char a;
} STRUCT_TEST3_TYPE, *STRUCT_TEST3_PTR;
  
typedef struct {
  int32 w;
  STRUCT_TEST3_TYPE t;
  double z;
} STRUCT_TEST4_TYPE, *STRUCT_TEST4_PTR;

#define TEST1_FORM "{int, char, double}"
#define TEST2_FORM "{int, double, char}"
#define TEST3_FORM "{int, char}"
#define TEST4_FORM "{int, {int, char}, double}"

#define point_format "{float, float, float}"
#define two_points_format "{int, string, point, point}"
#define complex_points_format "{[point:6], int, <two_points:2>, *point}"

/* Recursive named format example. */
typedef struct _tree {
  int nodeValue;
  int numChildren;
  struct _tree *children;
/*  struct _tree **children;*/
} TREE_TYPE, *TREE_PTR;

#define TREE_NAME "tree"
#define TREE_FORMAT "{int,int,*tree}"

#include "tca/tcaMatrix.h"

#endif /* INCsample */
