/*****************************************************************************
 *
 * (c) Copyright 1994. National Aeronautics and Space Administration.
 *     Ames Research Center, Moffett Field, CA 94035-1000 
 *
 * FILE:     receiver.c
 *
 * ABSTRACT: simple TCA example (based on an example in the TCX 7.7 manual)
 *
 * REVISION HISTORY:
 *
 * 25-Feb-94 Terry Fong. Created.
 *
 * Add use of direct messages.
 *
 *****************************************************************************/

#include "tca/libc.h"		
#include "tca.h"		/* TCA function declarations */

#include "common.h"		/* common definitions */

/*#define BCAST */

#define CLEANUP

static void NullHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;

/*  printf(".");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
}

static void Float4Hnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf(",");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;

  tcaFreeData ("Float4Msg", (void *) pData);
}

static void Float64Hnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf(":");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float64Msg", (void *) pData);
}

static void Float256Hnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf(";");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float256Msg", (void *) pData);
}

static void Float1KHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf("`");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float1KMsg", (void *) pData);
}

static void Float4KHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf("'");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float4KMsg", (void *) pData);
}

static void Float16KHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf("/");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float16KMsg", (void *) pData);
}

static void Float64KHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf("\"");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float64KMsg", (void *) pData);
}

static void Float256KHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf("a");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;

  /* free the data */
  tcaFreeData ("Float256KMsg", (void *) pData);
}

#ifdef BIG_TEST
static void Float1MHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf(".");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float1MMsg", (void *) pData);
}

static void Float4MHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf(".");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float4MMsg", (void *) pData);
}

static void Float16MHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
/*  printf(".");*/
  if((i==1) || (i == NSEND))
    tcaInform(DONE_MSG_INFORM,NULL);
  i++;
  
  /* free the data */
  tcaFreeData ("Float4KMsg", (void *) pData);
}
#endif

/******************************************************************************
 * RECEIVER main ()
 *****************************************************************************/
int main (int argc, char *argv[])
{
  struct {
    char *msgName; char *hndName; void (*hndProc)(TCA_REF_PTR, float *);
  } hndArray[] = {
    {"NullMsg",      "NullHnd",      NullHnd	  },
    {"Float4Msg",    "Float4Hnd",    Float4Hnd	  },
    {"Float64Msg",   "Float64Hnd",   Float64Hnd   },
    {"Float256Msg",  "Float256Hnd",  Float256Hnd  },
    {"Float1KMsg",   "Float1KHnd",   Float1KHnd   },
    {"Float4KMsg",   "Float4KHnd",   Float4KHnd   },
    {"Float16KMsg",  "Float16KHnd",  Float16KHnd  },
    {"Float64KMsg",  "Float64KHnd",  Float64KHnd  },
    {"Float256KMsg", "Float256KHnd", Float256KHnd },
#ifdef BIG_TEST
    {"Float1MMsg",   "Float1MHnd",   Float1MHnd   },
    {"Float4MMsg",   "Float4MHnd",   Float4MHnd   },
    {"Float16MMsg",  "Float16MHnd",  Float16MHnd  },
#endif
    { "" }
  };
  int i;
  
  /*
   * Connect this module to the TCA Server (specified by the CENTRALHOST
   * shell variable).
   */
  tcaConnectModule ("receiver", tcaServerMachine());
  
  tcaDirectResource("receiver");

  /* register message formats */
  for (i=0; *messageArray[i].msgName; i++) {
    
    tcaRegisterInformMessage (messageArray[i].msgName,
			      messageArray[i].msgFormat);
  }
  
  /* register handlers */
  for (i=0; *hndArray[i].msgName; i++) {
    tcaRegisterHandler (hndArray[i].msgName, hndArray[i].hndName,
			hndArray[i].hndProc);
    tcaAddHndToResource(hndArray[i].hndName, "receiver");
    /*    tcaPreloadMessage(hndArray[i].msgName);*/
  }
  
  /* receive & handle messages forever (timeout=NULL) */
  tcaWaitUntilReady();
  tcaModuleListen();
  exit(0);
}
