/*****************************************************************************
 *
 * (c) Copyright 1994. National Aeronautics and Space Administration.
 *     Ames Research Center, Moffett Field, CA 94035-1000 
 *
 * FILE:     receiver.c
 *
 * ABSTRACT: simple TCA example (based on an example in the TCX 7.7 manual)
 *
 * REVISION HISTORY:
 *
 * 25-Feb-94 Terry Fong. Created.
 *
 *****************************************************************************/

#include "tca/libc.h"		
#include "tca.h"		/* TCA function declarations */

#include "common.h"		/* common definitions */

/*#define BCAST */

#define CLEANUP

static void NullHnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
#ifndef BCAST
  tcaSuccess (ref);
#endif
  
  if (!(i++%200))
    printf ("NullHnd: #%d\n", i);
}

static void Float4Hnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
#ifndef BCAST
  tcaSuccess (ref);
#endif
  
  /* free the data */
  tcaFreeData ("Float4Msg", (void *) pData);
  
  if (!(i++%200))
    printf ("Float4Hnd: #%d\n", i);
}

static void Float64Hnd (TCA_REF_PTR ref, float *pData)
{
#ifndef BCAST
  tcaSuccess (ref);
#endif
  /* free the data */
  tcaFreeData ("Float64Msg", (void *) pData);
}

static void Float256Hnd (TCA_REF_PTR ref, float *pData)
{
#ifndef BCAST
  tcaSuccess (ref);
#endif
  /* free the data */
  tcaFreeData ("Float256Msg", (void *) pData);
}

static void Float1KHnd (TCA_REF_PTR ref, float *pData)
{
#ifndef BCAST
  tcaSuccess (ref);
#endif
  /* free the data */
  tcaFreeData ("Float1KMsg", (void *) pData);
}

static void Float4KHnd (TCA_REF_PTR ref, float *pData)
{
#ifndef BCAST
  tcaSuccess (ref);
#endif
  /* free the data */
  tcaFreeData ("Float4KMsg", (void *) pData);
}

static void Float16KHnd (TCA_REF_PTR ref, float *pData)
{
#ifndef BCAST
  tcaSuccess (ref);
#endif
  /* free the data */
  tcaFreeData ("Float16KMsg", (void *) pData);
}

static void Float64KHnd (TCA_REF_PTR ref, float *pData)
{
#ifndef BCAST
  tcaSuccess (ref);
#endif
  /* free the data */
  tcaFreeData ("Float64KMsg", (void *) pData);
}

static void Float256KHnd (TCA_REF_PTR ref, float *pData)
{
#ifndef BCAST
  tcaSuccess (ref);
#endif
  /* free the data */
  tcaFreeData ("Float256KMsg", (void *) pData);
}

/******************************************************************************
 * RECEIVER main ()
 ******************************************************************************/
int main (int argc, char *argv[])
{
  struct {
    char *msgName; char *hndName; void (*hndProc)(TCA_REF_PTR, float *);
  } hndArray[] = {
    {"NullMsg",      "NullHnd",      NullHnd	  },
    {"Float4Msg",    "Float4Hnd",    Float4Hnd	  },
    {"Float64Msg",   "Float64Hnd",   Float64Hnd   },
    {"Float256Msg",  "Float256Hnd",  Float256Hnd  },
    {"Float1KMsg",   "Float1KHnd",   Float1KHnd   },
    {"Float4KMsg",   "Float4KHnd",   Float4KHnd   },
    {"Float16KMsg",  "Float16KHnd",  Float16KHnd  },
    {"Float64KMsg",  "Float64KHnd",  Float64KHnd  },
    {"Float256KMsg", "Float256KHnd", Float256KHnd },
    { "" }
  };
  int i;
  
  /*
   * Connect this module to the TCA Server (specified by the CENTRALHOST
   * shell variable).
   */
  tcaConnectModule ("receiver", tcaServerMachine());
  
  /* register message formats */
  for (i=0; *messageArray[i].msgName; i++) {
    
#ifndef BCAST
    tcaRegisterCommandMessage (messageArray[i].msgName,
			       messageArray[i].msgFormat);
#else
    tcaRegisterBroadcastMessage (messageArray[i].msgName, 
				 messageArray[i].msgFormat);
#endif
  }
  
  /* register handlers */
  for (i=0; *hndArray[i].msgName; i++) {
    tcaRegisterHandler (hndArray[i].msgName, hndArray[i].hndName,
			hndArray[i].hndProc);
#ifdef CLEANUP
    tcaCleanUpAfterAchieved(hndArray[i].msgName);
#endif
  }
  
  /* receive & handle messages forever (timeout=NULL) */
  tcaWaitUntilReady();
  tcaModuleListen ();
  exit(0);
}
