/******************************************************************
 * Duplicate the task tree of Figure 2 in the tca manual
 ****************************************************************/

#include "tca/libc.h"

#include "tca.h"

static void print_ref (char *msg, TCA_REF_PTR ref)
{
  printf(msg);
  if (!ref) {
    printf(": NULL REFERENCE\n");
  } else if (tcaIsSameReference(ref, tcaRootNode())) {
    printf(": The Root Node\n");
  } else {
    printf(": %s\n", tcaReferenceName(ref));
  }
  fflush(stdout);
}

static void g1Hnd(TCA_REF_PTR ref,int32 *data)
{
  printf("\nHandling G1\n");
  fflush(stdout);
  *data += 1;
  tcaExpandGoal("G2", data);
  *data += 1;
  tcaExpandGoal("G3", data);
  tcaSuccess(ref);
}

static void g2Hnd(TCA_REF_PTR ref, int32 *data)
{
  printf("\nHandling G2\n");
  fflush(stdout);
  *data += 1;
  tcaExpandGoal("G4", data);
  *data += 1;
  tcaExecuteCommand("C2", data);
  print_ref("C3 ref", tcaFindChildByName(ref, "C3"));
  tcaSuccess(ref);
}

static void g3Hnd(TCA_REF_PTR ref, int32 *data)
{
  TCA_REF_PTR c3Ref, c4Ref, pm1Ref;
  double doubleData;

  printf("\nHandling G3\n");
  fflush(stdout);

  c3Ref = tcaCreateReference("C3");
  c4Ref = tcaCreateReference("C4");

  pm1Ref = tcaCreateReference("PM1");
/*  pm1Ref = tcaCreateReference("A1");*/
  
  TPL_ORDER(tcaAchievementOf(c3Ref), tcaAchievementOf(pm1Ref));
  TPL_ORDER(tcaAchievementOf(c4Ref), tcaAchievementOf(pm1Ref));

  *data += 1;
  tcaExecuteCommandWithConstraints(c3Ref, "C3", data, 0);
  *data += 1;
  tcaExecuteCommandWithConstraints(c4Ref, "C4", data, 0);
  *data += 1;
  doubleData = (double)*data;
  tcaPointMonitorWithConstraints(pm1Ref, "PM1", &doubleData, 0);
/*  tcaExecuteCommandWithConstraints(pm1Ref, "A1", data, 0);*/

  tcaSuccess(ref);
}

static void g4Hnd(TCA_REF_PTR ref, int32 *data)
{
  printf("\nHandling G4\n");
  fflush(stdout);
  *data += 1;
  tcaExecuteCommand("C1", data);
  tcaSuccess(ref);
}

static void c1Hnd(TCA_REF_PTR ref, int32 *data)
{
  printf("\nHandling C1\n");
  fflush(stdout);

  print_ref("Parent Node", tcaFindParentReference(ref));
  print_ref("Top Level Node", tcaFindTopLevelReference(ref));
  print_ref("Next Child", tcaFindNextChild(ref));
  print_ref("Previous Child", tcaFindPreviousChild(ref));

  tcaSuccess(ref);
}

static void c2Hnd(TCA_REF_PTR ref, int32 *data)
{
  printf("\nHandling C2\n");
  fflush(stdout);

  print_ref("Parent Node", tcaFindParentReference(ref));
  print_ref("Top Level Node", tcaFindTopLevelReference(ref));
  print_ref("Next Child", tcaFindNextChild(ref));
  print_ref("Previous Child", tcaFindPreviousChild(ref));

  tcaSuccess(ref);
}

static void c3Hnd(TCA_REF_PTR ref, int32 *data)
{
  printf("\nHandling C3\n");
  fflush(stdout);

  print_ref("Parent Node", tcaFindParentReference(ref));
  print_ref("Top Level Node", tcaFindTopLevelReference(ref));
  print_ref("Next Child", tcaFindNextChild(ref));
  print_ref("Previous Child", tcaFindPreviousChild(ref));

  tcaSuccess(ref);
}

static void c4Hnd(TCA_REF_PTR ref, int32 *data)
{ 
  TCA_REF_PTR parentRef;

  int32 *refData;
  double *dData;

  printf("\nHandling C4\n");
  fflush(stdout);

  parentRef = tcaFindParentReference(ref);
  print_ref("Parent Node", parentRef);
  print_ref("Top Level Node", tcaFindTopLevelReference(ref));
  print_ref("Next Child", tcaFindNextChild(ref));
  print_ref("Previous Child", tcaFindPreviousChild(ref));
  print_ref("First Child", tcaFindFirstChild(ref));
  print_ref("Last Child", tcaFindLastChild(ref));
  print_ref("First Child of Parent", tcaFindFirstChild(parentRef));
  print_ref("Last Child of Parent", tcaFindLastChild(parentRef));

  print_ref("C3 Child of parent", tcaFindChildByName(parentRef, "c3"));
  print_ref("PM1 Child of parent", tcaFindChildByName(parentRef, "pm1"));
  print_ref("C5 Child of parent", tcaFindChildByName(parentRef, "c5"));

  refData = (int32 *)tcaReferenceData(parentRef);
  printf("Data of parent: ");
  if (refData) 
    printf("int: %d\n", *refData);
  else
    printf("No Data");
  printf("\n");
  fflush(stdout);

  dData = (double *)tcaReferenceData(tcaFindChildByName(parentRef, "pm1"));
  printf("Data of PM1: ");
  if (refData) 
    printf("double: %f\n", *dData);
  else
    printf("No Data");
  printf("\n");
  fflush(stdout);

  tcaSuccess(ref);
}

static void q1Hnd(TCA_REF_PTR ref, double *data)
{
  printf("\nHandling Q1\n");
  fflush(stdout);
  tcaReply(ref, data);
}

static void a1Hnd(TCA_REF_PTR ref, double *data)
{ TCA_REF_PTR monitorRef, CRef;
  int intData;

  printf("\nHandling A1\n");
  fflush(stdout);

  print_ref("Parent Node", tcaFindParentReference(ref));
  print_ref("Top Level Node", tcaFindTopLevelReference(ref));
  monitorRef = tcaFindParentReference(ref);
  print_ref("Next Child of Monitor", tcaFindNextChild(monitorRef));
  print_ref("Previous Child of Monitor", tcaFindPreviousChild(monitorRef));
/*
  print_ref("Next Child", tcaFindNextChild(ref));
  print_ref("Previous Child", tcaFindPreviousChild(ref));
*/

  tcaDisplayTaskTree(tcaFindTopLevelReference(ref));
  tcaDisplayTaskTree(tcaRootNode());
  tcaKillSubTaskTree(tcaRootNode());
  CRef = tcaAddChildReference(tcaRootNode(), "c1");
  intData = (int32)*data;
  tcaExecuteCommandWithConstraints(CRef, "c1", &intData, SEQ_ACH);
  tcaDisplayTaskTree(tcaRootNode());
/*  tcaKillSubTaskTree(tcaRootNode());*/

  tcaSuccess(ref);
}

void main(int argc, char **argv)
{ int one=1;

  printf("Connect ...\n");
  fflush(stdout);

  tcaConnectModule("manTree", tcaServerMachine());

  tcaRegisterPointMonitor("PM1", "Q1", "A1");

  tcaRegisterGoal("G1", "int", g1Hnd);

  tcaRegisterGoal("G2", "int", g2Hnd);

  tcaRegisterGoal("G3", "int", g3Hnd);

  tcaRegisterGoal("G4", "int", g4Hnd);
 
  tcaRegisterCommand("C1", "int", c1Hnd);

  tcaRegisterCommand("C2", "int", c2Hnd);

  tcaRegisterCommand("C3", "int", c3Hnd);

  tcaRegisterCommand("C4", "int", c4Hnd);

  tcaRegisterQuery("Q1", "double", "double", q1Hnd);

  tcaRegisterCommand("A1", "double", a1Hnd);

  tcaWaitUntilReady();

  tcaTapMessage(WhileAchieving, "G2", "C3");

  tcaExpandGoal("G1", &one);

  tcaModuleListen();
}
