/******************************************************************************
 *
 * PROJECT: TCA: Task Control Architecture 
 * 
 * (c) Copyright 1994 Reid Simmons.  All rights reserved.
 * 
 * MODULE: Test
 *
 * FILE: lt2.c
 *
 * ABSTRACT: Test of the "limit pending" code.  Receives messages. 
 *           Run in conjunction with lt1
 * 
 * Resources
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/lt2.c,v $ 
 * $Revision: 1.4 $
 * $Date: 1995/12/17 20:23:24 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: lt2.c,v $
 * Revision 1.4  1995/12/17  20:23:24  rich
 * Flush stdout to work better with nanny.
 *
 * Revision 1.3  1995/04/07  05:05:01  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.2  1994/11/02  21:36:33  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Made libc.h and tcaMatrix.h module includes.
 *
 * Revision 1.1  1994/05/25  17:16:24  reids
 * Added test code for limiting the number of pending messages a resource
 * can handle
 *
 *
 ****************************************************************/

#include "tca/libc.h"
#include "tca.h"
#include "lt.h"

static void prompt (void)
{
  printf("Type <cr> when ready for next message: "); fflush(stdout);
  fflush(stdout);
  getchar(); fflush(stdin);
}

static void aHnd (TCA_REF_PTR ref, void *data)
{
  printf("Handling message %s (%d)\n", tcaReferenceName(ref), *(DATA_PTR)data);
  fflush(stdout);
  tcaSuccess(ref);
}

static void bHnd (TCA_REF_PTR ref, void *data)
{
  printf("Handling message %s (%d)\n", tcaReferenceName(ref), *(DATA_PTR)data);
  fflush(stdout);
  tcaSuccess(ref);
}

static void cHnd (TCA_REF_PTR ref, void *data)
{
  printf("Handling message %s (%d)\n", tcaReferenceName(ref), *(DATA_PTR)data);
  fflush(stdout);
}


static void registerMessages (void)
{
  tcaRegisterCommandMessage(A_COMMAND, A_FORMAT);
  tcaRegisterHandler(A_COMMAND, A_COMMAND, aHnd);

  tcaRegisterCommandMessage(B_COMMAND, B_FORMAT);
  tcaRegisterHandler(B_COMMAND, B_COMMAND, bHnd);

  tcaRegisterInformMessage(C_INFORM, C_FORMAT);
  tcaRegisterHandler(C_INFORM, C_INFORM, cHnd);

  tcaLimitPendingMessages(C_INFORM, LT2_MODULE, 2);

/*  tcaLimitPendingResource(LT2_MODULE, 2); */

  tcaLimitPendingMessages(A_COMMAND, LT2_MODULE, 1);
}

static void connect_tca(void)
{
  tcaConnectModule(LT2_MODULE, tcaServerMachine());
  registerMessages();
  tcaWaitUntilReady();
}

void main (void)
{
  connect_tca();

  while (1) {
    prompt();
    tcaHandleMessage(0);
  }
}
