/******************************************************************************
 *
 * PROJECT: TCA: Task Control Architecture 
 * 
 * (c) Copyright 1994 Reid Simmons.  All rights reserved.
 * 
 * MODULE: Test
 *
 * FILE: lt1.c
 *
 * ABSTRACT: Test of the "limit pending" code.  Sends messages.
 *           Run in conjunction with lt2
 * 
 * Resources
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/lt1.c,v $ 
 * $Revision: 1.4 $
 * $Date: 1995/12/17 20:23:23 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: lt1.c,v $
 * Revision 1.4  1995/12/17  20:23:23  rich
 * Flush stdout to work better with nanny.
 *
 * Revision 1.3  1995/04/07  05:04:59  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.2  1994/11/02  21:36:31  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Made libc.h and tcaMatrix.h module includes.
 *
 * Revision 1.1  1994/05/25  17:16:21  reids
 * Added test code for limiting the number of pending messages a resource
 * can handle
 *
 *
 ****************************************************************/

#include "tca/libc.h"
#include "tca.h"
#include "lt.h"

static void prompt (void)
{
  printf("Type <cr> when ready to send next message: "); fflush(stdout);
  fflush(stdout);
  getchar(); fflush(stdin);
}

static void connect_tca(void)
{
  tcaConnectModule(LT1_MODULE, tcaServerMachine());
  tcaWaitUntilReady();
}

#if 0
void main (void)
{
  DATA_TYPE data;

  connect_tca();

  data = 0;
  while (1) {
    prompt();
    data++;
    tcaInform(C_INFORM, &data);
  }
}
#endif

#if 1
void main (void)
{
  DATA_TYPE dataA, dataB;

  connect_tca();

  dataA = 0; dataB = 1000;
  while (1) {
    prompt();
    dataA++; dataB++;
    tcaExecuteCommandWithConstraints(NULL, A_COMMAND, &dataA, NO_TPLCONSTR);
    tcaExecuteCommand(B_COMMAND, &dataB);
  }
}
#endif

