/*****************************************************************************
 * PROJECT: Task Control Architecture
 *
 * (c) Copyright 1995 Richard Goodwin.  All rights reserved.
 *
 * FILE: broadcast.c
 *
 * ABSTRACT:
 *
 * Broadcast a series of messages.
 *
 * REVISION HISTORY:
 *
 * $Log: listener.c,v $
 * Revision 1.7  1996/02/14  22:13:22  rich
 * Fix problems with static declarations.
 *
 * Revision 1.6  1995/10/29  18:27:49  rich
 * Initial creation of 8.3. Added changes made after 8.2 branch was
 * created. These mostly have to do with context switching.
 *
 * Revision 1.5  1995/10/07  19:08:40  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Added tcaWillListen.
 *
 * Revision 1.4  1995/07/12  04:56:20  rich
 * Release of 8.0.
 * Added test for new features.
 *
 * Revision 1.3  1995/07/10  16:19:48  rich
 * Interm save.
 *
 * Revision 1.2  1995/04/07  05:04:57  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.1  1995/02/03  03:38:04  rich
 * Adding Forwarder code.
 *
 *
 * $Revision: 1.7 $
 * $Date: 1996/02/14 22:13:22 $
 * $Author: rich $
 *
 *****************************************************************************/

#include "tca/libc.h"		
#include "tca.h"		/* TCA function declarations */

#include "common.h"		/* common definitions */

#define CLEANUP

static void NullHnd (TCA_REF_PTR ref, float *pData)
{
}

static void Float4Hnd (TCA_REF_PTR ref, float *pData)
{
  static int i=1;
  
  /* free the data */
  tcaFreeData ("Float4Msg", (void *) pData);
  
  if (!(i++%200))
    printf ("Float4Hnd: #%d\n", i);
}

static void Float64Hnd (TCA_REF_PTR ref, float *pData)
{
  /* free the data */
  tcaFreeData ("Float64Msg", (void *) pData);
}

static void Float256Hnd (TCA_REF_PTR ref, float *pData)
{
  /* free the data */
  tcaFreeData ("Float256Msg", (void *) pData);
}

static void Float1KHnd (TCA_REF_PTR ref, float *pData)
{
  /* free the data */
  tcaFreeData ("Float1KMsg", (void *) pData);
}

static void Float4KHnd (TCA_REF_PTR ref, float *pData)
{
  /* free the data */
  tcaFreeData ("Float4KMsg", (void *) pData);
}

static void Float16KHnd (TCA_REF_PTR ref, float *pData)
{
  /* free the data */
  tcaFreeData ("Float16KMsg", (void *) pData);
}

static void Float64KHnd (TCA_REF_PTR ref, float *pData)
{
  /* free the data */
  tcaFreeData ("Float64KMsg", (void *) pData);
}

static void Float256KHnd (TCA_REF_PTR ref, float *pData)
{
  /* free the data */
  tcaFreeData ("Float256KMsg", (void *) pData);
}

/******************************************************************************
 * RECEIVER main ()
 ******************************************************************************/
int main (int argc, char *argv[])
{
  struct {
    char *msgName; char *hndName; void (*hndProc)(TCA_REF_PTR, float *);
  } hndArray[] = {
    {"NullMsg",      "NullHnd",      NullHnd	  },
    {"Float4Msg",    "Float4Hnd",    Float4Hnd	  },
    {"Float64Msg",   "Float64Hnd",   Float64Hnd   },
    {"Float256Msg",  "Float256Hnd",  Float256Hnd  },
    {"Float1KMsg",   "Float1KHnd",   Float1KHnd   },
    {"Float4KMsg",   "Float4KHnd",   Float4KHnd   },
    {"Float16KMsg",  "Float16KHnd",  Float16KHnd  },
    {"Float64KMsg",  "Float64KHnd",  Float64KHnd  },
    {"Float256KMsg", "Float256KHnd", Float256KHnd },
    { "" }
  };
  int i;

  char moduleName[80];
  
  /*
   * Connect this module to the TCA Server (specified by the CENTRALHOST
   * shell variable).
   */
  if (argc > 1) {
    sprintf(moduleName,"listener_%s",argv[1]);
  } else {
    sprintf(moduleName,"listener");
  }
  tcaConnectModule (moduleName, tcaServerMachine());
  
  /* register message formats */
  for (i=0; *messageArray[i].msgName; i++) {
    
    tcaRegisterBroadcastMessage (messageArray[i].msgName, 
				 messageArray[i].msgFormat);
  }
  
  /* register handlers */
  for (i=0; *hndArray[i].msgName; i++) {
    tcaRegisterHandler (hndArray[i].msgName, hndArray[i].hndName,
			hndArray[i].hndProc);
  }
  tcaLimitPendingResource(moduleName,2);
  
  /* receive & handle messages forever (timeout=NULL) */
  tcaWaitUntilReady();
  tcaModuleListen ();
  exit(0);
}
