/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/hndReg.c,v $ 
 * $Revision: 1.2 $
 * $Date: 1995/12/17 20:23:22 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: hndReg.c,v $
 * Revision 1.2  1995/12/17  20:23:22  rich
 * Flush stdout to work better with nanny.
 *
 * Revision 1.1  1995/07/12  15:18:18  rich
 * Added new test programs.
 *
 *
 *****************************************************************************/


#include "tca/libc.h"

#include "tca.h"

static void fooHnd (TCA_REF_PTR ref, void *data) {}

void main (void)
{
  tcaConnectModule("foo", tcaServerMachine());

  tcaRegisterInformMessage("foo", "int");

  tcaWaitUntilReady();

  printf("Bar is%s registered\n", (tcaMessageRegistered("bar") ? "" : " not"));
  printf("Handler for bar is %s registered\n",
	 (tcaMessageHandlerRegistered("bar") ? "" : " not"));
  printf("Foo is%s registered\n", (tcaMessageRegistered("foo") ? "" : " not"));
  printf("Handler for foo is%s registered\n",
	 (tcaMessageHandlerRegistered("foo") ? "" : " not"));
  fflush(stdout);
  tcaRegisterHandler("foo", "fooHnd", fooHnd);
  printf("Handler for foo is%s registered\n",
	 (tcaMessageHandlerRegistered("foo") ? "" : " not"));
  fflush(stdout);

  tcaMaybeExecute("junkMsg",NULL);
  tcaMaybeExecuteAsync("junkMsg",NULL);
  tcaMaybeExecuteWithConstraints(NULL,"junkMsg",NULL,NO_TPLCONSTR);

  exit(0);
}
