/******************************************************************************
 *
 * PROJECT: Task Control Architecture 
 * 
 * (c) Copyright 1993 Richard Goowin.  All rights reserved.
 * 
 * MODULE: tca tests
 *
 * FILE: exceptTest.c
 *
 * ABSTRACT:
 * 
 *  Task Control Architecture tests of exception handling.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/exceptTest.c,v $ 
 * $Revision: 1.12 $
 * $Date: 1996/02/14 22:13:19 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: exceptTest.c,v $
 * Revision 1.12  1996/02/14  22:13:19  rich
 * Fix problems with static declarations.
 *
 * Revision 1.11  1996/02/06  19:06:20  rich
 * Changes for VXWORKS pipes.
 * Note: the trtest function causes a race condition.  I start the
 * sub-processes individually.
 *
 * Revision 1.10  1995/12/17  20:23:20  rich
 * Flush stdout to work better with nanny.
 *
 * Revision 1.9  1995/04/07  05:04:54  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.8  1995/03/30  15:49:00  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 *
 * Revision 1.7  1995/03/16  18:05:55  rich
 * Merged in changes to the 7.9 branch.
 * Changed the VERSION_ to TCA_VERSION_
 *
 * Revision 1.6  1994/11/02  21:36:28  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Made libc.h and tcaMatrix.h module includes.
 *
 * Revision 1.5  1994/05/25  05:00:38  rich
 * Changed the test routines to use the new macros for registering simple
 * messages and handlers.
 * Added Terry Fong's benchmark.
 *
 * Revision 1.4  1994/04/16  19:47:07  rich
 * First release of TCA for the DEC alpha.
 *
 * New tests for variable length arrays.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.3  1993/12/01  18:06:10  rich
 * Some general cleanup.
 *
 * Revision 1.2  1993/11/21  20:21:06  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.1  1993/10/21  16:11:22  rich
 * Added an exception test.
 *
 ****************************************************************************/

#include "tca/libc.h"

#include "tca.h"

static void G_sampleHnd(TCA_REF_PTR ref, void *empty)
{
  tcaExecuteCommand("C_sample",NULL);
  tcaSuccess(ref);
}

static void C_sampleHnd(TCA_REF_PTR ref, void *empty)
{
  static char *msg = "You got an error!";
  tcaRaiseException(ref, "F_sample", &msg);
}

static void F_sampleRootHnd(TCA_REF_PTR ref, char *msg)
{
  printf("Got a Root failure message %s\n", msg);
  fflush(stdout);
  tcaSuccess(ref);
}

static void F_sampleGoalHnd(TCA_REF_PTR ref, char *msg)
{
  printf("Got a Goal failure message %s\n", msg);
  fflush(stdout);
  tcaSuccess(ref);
}

#if defined(VXWORKS)
void exceptionMain(char *host)
#else
void main(int argc, char *argv[])
#endif
{ 
  TCA_REF_PTR SampleGoalRef;
  
  printf("Connect ...\n");
  fflush(stdout);
  
#if defined(VXWORKS)
  tcaConnectModule("Exception Test", host);
#else
  tcaConnectModule("Exception Test", tcaServerMachine());
#endif
  
  
  /* Register all messages and handlers. */
  tcaRegisterCommand("C_sample", NULL, C_sampleHnd);
  tcaRegisterGoal("G_sample", 	NULL, G_sampleHnd);
  tcaRegisterException("F_sample", "string", F_sampleGoalHnd); 

  /* Add the root exception handler. */
  tcaAddExceptionHandler(tcaRootNode(), "F_sampleRootHnd");
  
  tcaWaitUntilReady();
  
  /* create the goal node, add exception handlers. */
  SampleGoalRef = tcaAddChildReference (tcaRootNode(), "G_sample");
  
  tcaAddExceptionHandler(SampleGoalRef, "F_sampleGoalHnd");
  
  /* expand the goal */
  tcaExpandGoalWithConstraints (SampleGoalRef, "G_sample", NULL, NULL);
  
  tcaModuleListen();

  tcaClose();
}
