/*****************************************************************************
 *
 * (c) Copyright 1994. National Aeronautics and Space Administration.
 *     Ames Research Center, Moffett Field, CA 94035-1000 
 *
 * FILE:     bday.h
 *
 * ABSTRACT: common defs for "bday_sender.c" and "bday_receive.c"
 *
 * REVISION HISTORY:
 *
 * 10-Feb-94 Terry Fong. Created.
 *
 *****************************************************************************/

#include "tca.h"

#define MAX_DATA_SIZE	((int32)(sizeof(float)*256*1024))

static struct {
  char *msgName; char *msgFormat;
} messageArray[] = {
  {"NullMsg",      NULL},               /* 0 bytes */
  {"Float4Msg",    "[float:4]"},        /* 16 bytes */
  {"Float64Msg",   "[float:64]"},       /* 256 bytes */
  {"Float256Msg",  "[float:256]"},      /* 1024 bytes */
  {"Float1KMsg",   "[float:1024]"},     /* 4096 bytes */
  {"Float4KMsg",   "[float:4096]"},     /* 16384 bytes */
  {"Float16KMsg",  "[float:16384]"},    /* 65536 bytes */
  {"Float64KMsg",  "[float:65536]"},    /* 262144 bytes */
  {"Float256KMsg", "[float:262144]"},   /* 1048576 bytes */
  {""}
};

#define DONE_MSG_INFORM        "I_done"
#define DONE_MSG_INFORM_FORMAT NULL

struct {
  char *msgName; int msgSize;
} messages[] = {
  { "NullMsg", 	0                    },
  { "Float4Msg", 	sizeof(float)*4      },
  { "Float64Msg",	sizeof(float)*64     },
  { "Float256Msg",	sizeof(float)*256    },
  { "Float1KMsg",	sizeof(float)*1024   },
  { "Float4KMsg",	sizeof(float)*4096   },
  { "Float16KMsg",	sizeof(float)*16384  },
  { "Float64KMsg",	sizeof(float)*65536  },
  { "Float256KMsg",	sizeof(float)*262144 },
  { "" }
};

/*#define BCAST */

#ifdef BCAST
#define NSEND	2000		/* # of messages to send */
#else
#define NSEND	 200		/* # of messages to send */
#endif
