/*****************************************************************************
 * PROJECT: Task Control Architecture
 *
 * (c) Copyright 1995 Richard Goodwin.  All rights reserved.
 *
 * FILE: broadcast.c
 *
 * ABSTRACT:
 *
 * Broadcast a series of messages.
 *
 * REVISION HISTORY:
 *
 * $Log: broadcast.c,v $
 * Revision 1.7  1996/02/14  22:13:18  rich
 * Fix problems with static declarations.
 *
 * Revision 1.6  1996/01/10  03:17:08  rich
 * Fixed print strings for speed testing routines.
 *
 * Revision 1.5  1995/10/29  18:27:45  rich
 * Initial creation of 8.3. Added changes made after 8.2 branch was
 * created. These mostly have to do with context switching.
 *
 * Revision 1.4  1995/10/07  19:08:39  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Added tcaWillListen.
 *
 * Revision 1.3  1995/04/07  05:04:50  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.2  1995/03/16  18:05:52  rich
 * Merged in changes to the 7.9 branch.
 * Changed the VERSION_ to TCA_VERSION_
 *
 * Revision 1.1  1995/02/03  03:38:01  rich
 * Adding Forwarder code.
 *
 *
 * $Revision: 1.7 $
 * $Date: 1996/02/14 22:13:18 $
 * $Author: rich $
 *
 *****************************************************************************/

#include "tca/libc.h"		
#include "tca.h"		/* TCA function declarations */

#include "common.h"		/* common definitions */

float sslCalcTimevalDiff (struct timeval *pT1, struct timeval *pT2);

static void junkHnd(TCA_REF_PTR ref, char *ignore)
{
}

/******************************************************************************
 * main ()
 *****************************************************************************/
int main (int argc, char *argv[])
{
  struct timeval sTime, eTime;
  float *data;
  int i, j, nBytes;
  float secs;
  struct {
    char *msgName; int msgSize;
  } messages[] = {
    { "NullMsg", 	0                    },
    { "Float4Msg", 	sizeof(float)*4      },
    { "Float64Msg",	sizeof(float)*64     },
    { "Float256Msg",	sizeof(float)*256    },
    { "Float1KMsg",	sizeof(float)*1024   },
    { "Float4KMsg",	sizeof(float)*4096   },
    { "Float16KMsg",	sizeof(float)*16384  },
    { "Float64KMsg",	sizeof(float)*65536  },
    { "Float256KMsg",	sizeof(float)*262144 },
    { "" }
  };
  
  printf ("\nStarting Broadcast %d\n", MAX_DATA_SIZE);

  data = malloc(MAX_DATA_SIZE);
  
  for (j = 0; j<MAX_DATA_SIZE/sizeof(float); j++)
    data[j] = (float) j;
  
  printf ("\nInitialized\n");
  
  /*
   * Connect this module to the TCA Server (specified by the CENTRALHOST
   * shell variable).
   */
  tcaConnectModule ("broadcast", tcaServerMachine());
  
  /* register message formats */
  for (i=0; *messageArray[i].msgName; i++) {
    
    tcaRegisterBroadcastMessage (messageArray[i].msgName, 
				 messageArray[i].msgFormat);
  }

  tcaRegisterInform("JUNK",NULL,junkHnd);
  
  tcaWaitUntilReady();
  
  for (j=0; *messages[j].msgName; j++) {
    tcaHandleMessage(0);
    printf ("\nSending %d <%s> Commands...\n", NSEND, messages[j].msgName);
    tcaBroadcast (messages[j].msgName, data);
    gettimeofday (&sTime, NULL);
    for (i=0; i<NSEND; i++) {
      tcaBroadcast (messages[j].msgName, data);
    }
    gettimeofday (&eTime, NULL);
    secs = sslCalcTimevalDiff (&eTime, &sTime);
    nBytes = messages[j].msgSize*NSEND;
    
    printf ("Sent %d bytes in %.2f seconds (%.2f bytes/sec)\n",
	    nBytes, secs, (float) nBytes / secs);
    printf ("%d Command messages (%d bytes each) at %.0f Broadcasts/sec\n",
	    NSEND, messages[j].msgSize, (float) NSEND / secs);
  }
  
  /* shut down */
  printf ("\n");
  exit (0);
}

/******************************************************************************
 *
 * sslCalcTimevalDiff - calculate the difference between two timevals in seconds
 *
 * INPUTS:
 *   pT1		pointer to first timeval
 *   pT2		pointer to first timeval
 *
 * RETURNS:
 *   Difference between timevals in seconds (pT1 - pT2)
 *
 ******************************************************************************/
float
sslCalcTimevalDiff (struct timeval *pT1, struct timeval *pT2)
{
  return ((float) (pT1->tv_sec - pT2->tv_sec) +
          ((float) (pT1->tv_usec - pT2->tv_usec)) / 1000000.0);
}
