/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1994.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/b1_var.c,v $ 
 * $Revision: 1.9 $
 * $Date: 1996/02/14 22:13:16 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: b1_var.c,v $
 * Revision 1.9  1996/02/14  22:13:16  rich
 * Fix problems with static declarations.
 *
 * Revision 1.8  1996/02/10  23:35:33  rich
 * Fixed main calls.
 *
 * Revision 1.7  1996/02/06  19:06:18  rich
 * Changes for VXWORKS pipes.
 * Note: the trtest function causes a race condition.  I start the
 * sub-processes individually.
 *
 * Revision 1.6  1995/12/17  20:23:18  rich
 * Flush stdout to work better with nanny.
 *
 * Revision 1.5  1995/07/10  16:19:40  rich
 * Interm save.
 *
 * Revision 1.4  1995/04/07  05:04:48  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.3  1995/03/30  15:48:58  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 *
 * Revision 1.2  1994/11/02  21:36:25  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Made libc.h and tcaMatrix.h module includes.
 *
 * Revision 1.1  1994/05/17  23:20:41  rich
 * Added global variable test routines a1_var and b1_var.  Also make some
 * changes so it would compile on an sgi machine.
 *
 *
 *****************************************************************************/

#include "tca/libc.h"

#include "tca.h"

#include "sample.h"

static void sampleVarHnd(TCA_REF_PTR Ref, SamplePtr Sample)
{
 
  SampleType sampleVar1;
 
  printf("SampleHnd: Start.\n");
  fflush(stdout);
  
  tcaGetVar(SampleVarName, &sampleVar1);
  
  if (Sample) {
    printf("Sample: %s\n", Sample->s);
    
    free(Sample->s);
    free(Sample);
  }
  else {
    printf("Sample: NULL\n");
    
  }
  
  printf("SampleHnd: Done.\n");
  fflush(stdout);
}

#if defined(VXWORKS)
void b1main(char *host)
#else
void main(int argc, char **argv)
#endif
{
  printf("Connect ...\n");
  fflush(stdout);

#if defined(VXWORKS)
  tcaConnectModule("Module B", host);
#else
  tcaConnectModule("Module B", tcaServerMachine());
#endif

  tcaWatchVar(SampleVarName,SampleDataForm, sampleVarHnd);
  
  tcaWaitUntilReady();

  tcaModuleListen();

  exit(0);
}
