
#include "tca/libc.h"
#include "tca.h"

#include "sample.h"

void SelfQueryHnd(TCA_REF_PTR Ref, int32 *x)
{
  int ReplyData;

  printf("SelfQueryHnd: Start.\n");

  printf("x = %d\n", *x);

  ReplyData = 17;
  fflush(stdout);

  tcaReply(Ref, &ReplyData);

  printf("SelfQueryHnd: Done.\n");
  fflush(stdout);
}

void SampleHnd(TCA_REF_PTR Ref, SamplePtr Sample)
{

  ReplyType ReplyData;
  
  printf("SampleHnd: Start.\n");
/*
  printf("press return\n");
  getchar();
*/
  printf("continue with SampleHnd ...\n");

  if (Sample) {
    printf("Sample: %s\n", Sample->s);

    ReplyData = Sample->x;

    free(Sample->s);
    free(Sample);
  }
  else {
    printf("Sample: NULL\n");
    
    ReplyData = 51;
  }
  
  tcaReply(Ref, &ReplyData);

  printf("SampleHnd: Done.\n");
}

void GoalHnd(TCA_REF_PTR ref, SamplePtr Sample)
{
/*  int a, b;*/

  printf("GoalHnd: Start\n");

  printf("Message: %s\n", tcaReferenceName(ref));

  printf("press return\n");
  getchar();

/*
  a = 42;
  tcaQuery("SelfQueryMsg", &a, &b);

  printf("b = %d\n", b);
*/
  tcaFailure(ref, "Random Failure Message", Sample);

  printf("GoalHnd: Done.\n");
}

void PolyHnd(TCA_REF_PTR ref, PolyPtr Poly)
{
  int i;
  ReplyType ReplyData;

  printf("PolyHnd: Start.\n");

  printf("Poly->silly: %d\n", Poly->silly);
  printf("Poly->n: %d\n", Poly->n);
  for(i=0;i < 2;i++) {
    printf("Poly->x[%d]: %g\n", i, Poly->x[i]);
    printf("Poly->y[%d]: %g\n", i, Poly->y[i]);
  }

  ReplyData = 7;

  printf("press return\n");
  getchar();

  tcaReply(ref, &ReplyData);

  printf("PolyHnd: Done.\n");
}

void charMsgHnd(TCA_REF_PTR ref, char *sampleChar)
{
  ReplyType ReplyData;

  printf("sampleCharHnd: Start.\n");

  printf("sampleChar: %c\n", *sampleChar);

  printf("sampleCharHnd: End.\n");

  ReplyData = 3;

  tcaReply(ref, &ReplyData);

}

void ucmatMapHnd(TCA_REF_PTR Ref, ucmat *ucmatMap)
{
  ReplyType ReplyData;

  printf("ucmatMapHnd: Start.\n");

  printf("%x\n", ucmatMap->el[1][5]);
  printf("%x\n", ucmatMap->el[1][6]);
  printf("%x\n", ucmatMap->el[1][7]);
  printf("%x\n", ucmatMap->el[2][5]);
  printf("%x\n", ucmatMap->el[2][6]);
  printf("%x\n", ucmatMap->el[2][7]);

  ReplyData = 0;

  tcaReply(Ref, &ReplyData);

  printf("ucmatMapHnd: End.\n");
}

void cmatMapHnd(TCA_REF_PTR Ref, cmat *cmatMap)
{
  ReplyType ReplyData;

  printf("cmatMapHnd: Start.\n");

  printf("%c\n", cmatMap->el[1][5]);
  printf("%c\n", cmatMap->el[1][6]);
  printf("%c\n", cmatMap->el[1][7]);
  printf("%c\n", cmatMap->el[2][5]);
  printf("%c\n", cmatMap->el[2][6]);
  printf("%c\n", cmatMap->el[2][7]);

  ReplyData = 1;

  tcaReply(Ref, &ReplyData);

  printf("cmatMapHnd: End.\n");
}

void smatMapHnd(TCA_REF_PTR Ref, smat *smatMap)
{
  ReplyType ReplyData;

  printf("smatMapHnd: Start.\n");

  printf("%d\n", smatMap->el[1][5]);
  printf("%d\n", smatMap->el[1][6]);
  printf("%d\n", smatMap->el[1][7]);
  printf("%d\n", smatMap->el[2][5]);
  printf("%d\n", smatMap->el[2][6]);
  printf("%d\n", smatMap->el[2][7]);

  ReplyData = 2;

  tcaReply(Ref, &ReplyData);

  printf("smatMapHnd: End.\n");
}

void imatMapHnd(TCA_REF_PTR Ref, imat *imatMap)
{
  ReplyType ReplyData;

  printf("dmatMapHnd: Start.\n");

  printf("%d\n", imatMap->el[1][5]);
  printf("%d\n", imatMap->el[1][6]);
  printf("%d\n", imatMap->el[1][7]);
  printf("%d\n", imatMap->el[2][5]);
  printf("%d\n", imatMap->el[2][6]);
  printf("%d\n", imatMap->el[2][7]);

  ReplyData = 3;

  tcaReply(Ref, &ReplyData);

  printf("imatMapHnd: End.\n");
}

void lmatMapHnd(TCA_REF_PTR Ref, lmat *lmatMap)
{
  ReplyType ReplyData;

  printf("lmatMapHnd: Start.\n");

  printf("%ld\n", lmatMap->el[1][5]);
  printf("%ld\n", lmatMap->el[1][6]);
  printf("%ld\n", lmatMap->el[1][7]);
  printf("%ld\n", lmatMap->el[2][5]);
  printf("%ld\n", lmatMap->el[2][6]);
  printf("%ld\n", lmatMap->el[2][7]);

  ReplyData = 4;

  tcaReply(Ref, &ReplyData);

  printf("lmatMapHnd: End.\n");
}

void fmatMapHnd(TCA_REF_PTR Ref, fmat *fmatMap)
{
  ReplyType ReplyData;

  printf("fmatMapHnd: Start.\n");

  printf("%f\n", fmatMap->el[1][5]);
  printf("%f\n", fmatMap->el[1][6]);
  printf("%f\n", fmatMap->el[1][7]);
  printf("%f\n", fmatMap->el[2][5]);
  printf("%f\n", fmatMap->el[2][6]);
  printf("%f\n", fmatMap->el[2][7]);

  ReplyData = 5;

  tcaReply(Ref, &ReplyData);

  printf("fmatMapHnd: End.\n");
}

void dmatMapHnd(TCA_REF_PTR Ref, dmat *dmatMap)
{
  ReplyType ReplyData;

  printf("dmatMapHnd: Start.\n");

  printf("%f\n", dmatMap->el[1][5]);
  printf("%f\n", dmatMap->el[1][6]);
  printf("%f\n", dmatMap->el[1][7]);
  printf("%f\n", dmatMap->el[2][5]);
  printf("%f\n", dmatMap->el[2][6]);
  printf("%f\n", dmatMap->el[2][7]);

  ReplyData = 6;

  tcaReply(Ref, &ReplyData);

  printf("dmatMapHnd: End.\n");
}

void LinkHnd(TCA_REF_PTR Ref, s2Ptr s2)
{
  s2Ptr tmp;
  ReplyType ReplyData;

  printf("LinkHnd: Start.\n");

  tmp = s2;
  while(tmp) {
    printf("s2->a: %d\n", tmp->a);
    printf("s2->b: %d\n", tmp->b);
    printf("s2->s: %s\n", tmp->s);
    printf("\n");
    /* should free this list when we are done with it. */
    tmp = tmp->next;
  }

  ReplyData = 9;

  printf("LinkHnd: End.\n");

  tcaReply(Ref, &ReplyData);
}

void FixedArrayHnd(TCA_REF_PTR Ref, two_d_array fixed_array)
{ ReplyType ReplyData;
  int       i, j;

  printf("FixedArrayHnd: Start.\n");

  for(i=0; i<FIXED_ARRAY_DIM1; i++) {
    for(j=0; j<FIXED_ARRAY_DIM2; j++)
      printf("%d ", fixed_array[i][j]);
    printf("\n");
  }

  ReplyData = 10;

  printf("FixedArrayHnd: End.\n");

  tcaReply(Ref, &ReplyData);
}

void VarArrayHnd(TCA_REF_PTR Ref, var_two_d_array *var_array)
{ ReplyType ReplyData;
  int       i, j, accessor;

  printf("VarArrayHnd: Start.\n");

  for(i=0; i<var_array->dim1; i++){
    for(j=0; j<var_array->dim2; j++) {
      /* Can't do multiple subscripts on variable length arrays */
      accessor = i + j*var_array->dim1;
      printf("%s ", var_array->elements[accessor]);
    }
    printf("\n");
  }

  ReplyData = 10;

  printf("VarArrayHnd: End.\n");

  tcaReply(Ref, &ReplyData);
}

#define set_point(point, x1, y1, z1) \
{ (point).x = x1; (point).y = y1; (point).z = z1;}

#define set_two_points(two_points, Leg_No, Name, x1, y1, z1, x2, y2, z2) \
{ (two_points).leg_no = Leg_No; (two_points).name = Name; \
  set_point((two_points).pt1, x1, y1, z1); \
  set_point((two_points).pt2, x2, y2, z2);}

void print_point (apoint) point *apoint;
{ if (apoint) printf("Point: %f, %f, %f\n", apoint->x, apoint->y, apoint->z);
  else printf("No Point\n");}

void print_two_points (twopoints) two_points *twopoints;
{ 
  if (twopoints) {
    printf("Two Points: %d, %s\n", twopoints->leg_no, twopoints->name);
    printf("     "); print_point(&(twopoints->pt1));
    printf("     "); print_point(&(twopoints->pt2));
  }
  else printf("No Points\n");
}

void print_complex_points (complexpoints) complex_points *complexpoints;
{ int i;

  printf("Complex Point:\n");
  for(i=0; i<6; i++) {
    printf("%d. ", i); 
    print_point(&(complexpoints->points[i]));
  }
  if (complexpoints->length)
    for(i=0; i<complexpoints->length; i++) {
      printf("%d. ", i); 
      print_two_points(&(complexpoints->more_points[i]));
    }
  else printf("No Points\n");
  print_point(complexpoints->pt_ptr);
}

void PointsHnd(TCA_REF_PTR Ref, complex_points *Points)
{ two_points reply_point;

  print_complex_points(Points);

  if (Points->more_points) reply_point = Points->more_points[1];
  else set_two_points(reply_point, -1,
		      "Null Reply", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

  tcaReply(Ref, &reply_point);
/*
  tcaClose();
  exit(0);
*/
}

void structTest1Hnd(TCA_REF_PTR ref, STRUCT_TEST1_PTR t)
{
  int r;

  r = 1;

  printf("structTest1Hnd: start\n");

  printf("test1->x: %d\n", t->x);
  printf("test1->a: %c\n", t->a);
  printf("test1->y: %f\n", t->y);

  tcaReply(ref, &r);
  printf("structTest1Hnd: end\n");
}

void structTest2Hnd(TCA_REF_PTR ref, STRUCT_TEST2_PTR t)
{
  int r;

  r = 2;

  printf("structTest2Hnd: start\n");

  printf("test2->x: %d\n", t->x);
  printf("test2->y: %f\n", t->y);
  printf("test2->a: %c\n", t->a);

  tcaReply(ref, &r);
  printf("structTest2Hnd: end\n");
}

void structTest3Hnd(TCA_REF_PTR ref, STRUCT_TEST3_PTR t)
{
  int r;

  r = 3;

  printf("structTest3Hnd: start\n");

  printf("test3->x: %d\n", t->x);
  printf("test3->a: %c\n", t->a);

  tcaReply(ref, &r);
  printf("structTest3Hnd: end\n");
}

void structTest4Hnd(TCA_REF_PTR ref, STRUCT_TEST4_PTR t)
{
  int r;

  r = 4;

  printf("structTest4Hnd: start\n");

  printf("test4->w: %d\n", t->w);
  printf("test4->t.x: %d\n", t->t.x);
  printf("test4->t.a: %c\n", t->t.a);
  printf("test4->z: %f\n", t->z);

  tcaReply(ref, &r);
  printf("structTest4Hnd: end\n");
}

void sHnd(TCA_REF_PTR ref, int *item)
{
  printf("constraint test\n");

  printf("item: %d\n", *item);
/*
  printf("press return.\n");
  getchar();
*/
}


void regInit()
{

  /* tcaDirectResource("Module B");*/

  tcaRegisterMessage("SelfQueryMsg", QueryClass, "int", "int");
  tcaRegisterHandler("SelfQueryMsg", "SelfQueryHnd", SelfQueryHnd);

  tcaRegisterMessage("LinkTestMsg", QueryClass, s2TypeForm, ReplyDataForm);
  tcaRegisterHandler("LinkTestMsg", "LinkHnd", LinkHnd);
/*
  tcaAddHndToResource("LinkHnd", "Module B");
*/
  tcaRegisterMessage("GoalMsg", GoalClass, SampleDataForm, NULL);
  tcaRegisterMessage("GoalMsg2", GoalClass, SampleDataForm, NULL);
  tcaRegisterHandler("GoalMsg", "GoalHnd", GoalHnd);
  tcaRegisterHandler("GoalMsg2", "GoalHnd", GoalHnd);

/*
  tcaRegisterMessage("SampleMsg", QueryClass, SampleDataForm, ReplyDataForm);
*/
  tcaRegisterHandler("SampleMsg", "SampleHnd", SampleHnd);
/*
  tcaRegisterResource("Miasma", 1);
  tcaRegisterResource("Vapor", 1);
  tcaAddHndToResource("SampleHnd", "Miasma");
  tcaAddHndToResource("SampleHnd", "Vapor");
*/

  tcaRegisterMessage("PolyMsg", QueryClass, 
		     "{int, <double:4>, <double:4>, int}",
		     ReplyDataForm);
  tcaRegisterHandler("PolyMsg", "PolyHnd", PolyHnd);

  tcaRegisterMessage("charMsg", QueryClass, "char", ReplyDataForm);  
  tcaRegisterHandler("charMsg", "charMapHnd", charMsgHnd);

  tcaRegisterMessage("ucmatMsg", QueryClass, "cmat", ReplyDataForm);  
  tcaRegisterHandler("ucmatMsg", "ucmatMapHnd", ucmatMapHnd);

  tcaRegisterMessage("cmatMsg", QueryClass, "cmat", ReplyDataForm);  
  tcaRegisterHandler("cmatMsg", "cmatMapHnd", cmatMapHnd);

  tcaRegisterMessage("smatMsg", QueryClass, "smat", ReplyDataForm);  
  tcaRegisterHandler("smatMsg", "smatMapHnd", smatMapHnd);

  tcaRegisterMessage("imatMsg", QueryClass, "imat", ReplyDataForm);  
  tcaRegisterHandler("imatMsg", "imatMapHnd", imatMapHnd);

  tcaRegisterMessage("lmatMsg", QueryClass, "lmat", ReplyDataForm);  
  tcaRegisterHandler("lmatMsg", "lmatMapHnd", lmatMapHnd);

  tcaRegisterMessage("fmatMsg", QueryClass, "fmat", ReplyDataForm);  
  tcaRegisterHandler("fmatMsg", "fmatMapHnd", fmatMapHnd);

  tcaRegisterMessage("dmatMsg", QueryClass, "dmat", ReplyDataForm);  
  tcaRegisterHandler("dmatMsg", "dmatMapHnd", dmatMapHnd);

  tcaRegisterMessage("FixedArrayMsg", QueryClass, two_d_array_form, 
		     ReplyDataForm);
  tcaRegisterHandler("FixedArrayMsg", "FixedArrayHnd", FixedArrayHnd);

  tcaRegisterMessage("VarArrayMsg", QueryClass, var_two_d_array_form, 
		     ReplyDataForm);
  tcaRegisterHandler("VarArrayMsg", "VarArrayHnd", VarArrayHnd);

  tcaRegisterNamedFormatter("point", point_format);
  tcaRegisterNamedFormatter("two_points", two_points_format);
  tcaRegisterMessage("StructuredFormatters", QueryClass, 
		     complex_points_format, "two_points");
  tcaRegisterHandler("StructuredFormatters", "PointsHnd", PointsHnd);


  tcaRegisterMessage("structTest1Msg", QueryClass, TEST1_FORM, ReplyDataForm);
  tcaRegisterHandler("structTest1Msg", "structTest1Hnd", structTest1Hnd);

  tcaRegisterMessage("structTest2Msg", QueryClass, TEST2_FORM, ReplyDataForm);
  tcaRegisterHandler("structTest2Msg", "structTest2Hnd", structTest2Hnd);

  tcaRegisterMessage("structTest3Msg", QueryClass, TEST3_FORM, ReplyDataForm);
  tcaRegisterHandler("structTest3Msg", "structTest3Hnd", structTest3Hnd);

  tcaRegisterMessage("structTest4Msg", QueryClass, TEST4_FORM, ReplyDataForm);
  tcaRegisterHandler("structTest4Msg", "structTest4Hnd", structTest4Hnd);

  tcaRegisterConstraintMessage("sampleConstraint1", "int");
  tcaRegisterHandler("sampleConstraint1", "sHnd", sHnd);

  tcaRegisterConstraintMessage("sampleConstraint2", "int");
  tcaRegisterHandler("sampleConstraint2", "sHnd", sHnd);
}

void specialExit()
{
  printf("weee special exit.\n");
}

void main(int argc, char **argv)
{
  printf("Connect ...\n");

  tcaConnectModule("Module B", tcaServerMachine());

  /* regInit();*/
  tcaRegisterExitProc(specialExit);

  regInit();
  
  tcaWaitUntilReady();

  printf("wait for reply: done\n");

  tcaModuleListen();
}
