/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/b1.c,v $ 
 * $Revision: 1.21 $
 * $Date: 1996/02/14 22:13:14 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: b1.c,v $
 * Revision 1.21  1996/02/14  22:13:14  rich
 * Fix problems with static declarations.
 *
 * Revision 1.20  1996/02/10  23:35:31  rich
 * Fixed main calls.
 *
 * Revision 1.19  1996/02/06  19:06:16  rich
 * Changes for VXWORKS pipes.
 * Note: the trtest function causes a race condition.  I start the
 * sub-processes individually.
 *
 * Revision 1.18  1996/01/27  21:55:38  rich
 * Pre-release of 8.4.
 * Added test for recursive named types.
 * Iain's windows changes.
 *
 * Revision 1.17  1996/01/05  16:32:55  rich
 * Added windows NT port.
 *
 * Revision 1.16  1995/12/17  20:23:15  rich
 * Flush stdout to work better with nanny.
 *
 * Revision 1.15  1995/10/07  19:08:36  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Added tcaWillListen.
 *
 * Revision 1.14  1995/07/10  16:19:29  rich
 * Interm save.
 *
 * Revision 1.13  1995/04/07  05:04:44  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.12  1995/03/30  15:48:57  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 *
 * Revision 1.11  1995/03/28  01:16:23  rich
 * Cleanup.
 *
 * Revision 1.10  1995/03/19  19:43:34  rich
 * Modified a1 and b1 to use direct connections.
 * Added a benchmark (sender3_1 and receiver3_1) to test direct connections.
 *
 * Revision 1.9  1995/01/18  16:48:51  rich
 * Saving changes to the test routines so I can compare 7.8 and 7.9.
 *
 * Revision 1.8  1994/11/02  21:36:21  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Made libc.h and tcaMatrix.h module includes.
 *
 * Revision 1.7  1994/05/25  05:00:34  rich
 * Changed the test routines to use the new macros for registering simple
 * messages and handlers.
 * Added Terry Fong's benchmark.
 *
 * Revision 1.6  1994/05/17  23:20:39  rich
 * Added global variable test routines a1_var and b1_var.  Also make some
 * changes so it would compile on an sgi machine.
 *
 * Revision 1.5  1994/04/16  19:47:05  rich
 * First release of TCA for the DEC alpha.
 *
 * New tests for variable length arrays.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.4  1994/01/31  19:15:17  reids
 * Minor cleanup to code.
 *
 * Revision 1.3  1993/12/01  18:06:05  rich
 * Some general cleanup.
 *
 * Revision 1.4  1993/08/23  17:48:17  rich
 * Small changes to the system headers.
 *
 * Revision 1.3  1993/06/22  14:02:48  rich
 * Fixed some warnings.
 * Updated the -D<arch> flags to correspond to those generated
 * automatically by the makefile.
 * Changed system includes to the proper format "stdio.h" -> <stdio.h>.
 * This was needed so that the automatic dependency generation can
 * distinguish between "local" and system headers.  The location of the
 * system headers changes from architecture to architecture and should not
 * be included in the dependency list.
 *
 * Revision 1.2  1993/05/27  22:23:05  rich
 * Added automatic logging.
 *
 *****************************************************************************/

#include "tca/libc.h"

#include "tca.h"

#include "sample.h"

static void SelfQueryHnd(TCA_REF_PTR Ref, int32 *x)
{
  int32 ReplyData;

  printf("SelfQueryHnd: Start.\n");

  printf("x = %d\n", *x);
  fflush(stdout);

  ReplyData = 17;

  tcaReply(Ref, &ReplyData);

  printf("SelfQueryHnd: Done.\n");
  fflush(stdout);
}

static void SampleHnd(TCA_REF_PTR Ref, SamplePtr Sample)
{

  ReplyType ReplyData;
  
  printf("SampleHnd: Start.\n");
  fflush(stdout);
/*
  printf("press return\n");
  getchar();
*/
  printf("continue with SampleHnd ...\n");
  fflush(stdout);

  if (Sample) {
    printf("Sample: %s\n", Sample->s);

    ReplyData = Sample->x;

    free(Sample->s);
    free(Sample);
  }
  else {
    printf("Sample: NULL\n");
    
    ReplyData = 51;
  }
  fflush(stdout);

  tcaReply(Ref, &ReplyData);

  printf("SampleHnd: Done.\n");
  fflush(stdout);
}

static void GoalHnd(TCA_REF_PTR ref, SamplePtr Sample)
{

  printf("GoalHnd: Start\n");

  printf("Message: %s\n", tcaReferenceName(ref));

/*
  printf("press return\n");
  fflush(stdout);
  getchar();
*/
/*
  a = 42;
  tcaQuery("SelfQueryMsg", &a, &b);

  printf("b = %d\n", b);
*/
  tcaFailure(ref, "Random Failure Message", Sample);

  printf("GoalHnd: Done.\n");
  fflush(stdout);
}

static void PolyHnd(TCA_REF_PTR ref, PolyPtr Poly)
{
  int32 i;
  ReplyType ReplyData;

  printf("PolyHnd: Start.\n");

  printf("Poly->silly: %d\n", Poly->silly);
  printf("Poly->n: %d\n", Poly->n);
  for(i=0;i < 2;i++) {
    printf("Poly->x[%d]: %g\n", i, Poly->x[i]);
    printf("Poly->y[%d]: %g\n", i, Poly->y[i]);
  }

  ReplyData = 7;

/*
  printf("press return\n");
  fflush(stdout);
  getchar();
*/

  tcaReply(ref, &ReplyData);

  printf("PolyHnd: Done.\n");
  fflush(stdout);
}

static void charMsgHnd(TCA_REF_PTR ref, char *sampleChar)
{
  ReplyType ReplyData;

  printf("sampleCharHnd: Start.\n");

  printf("sampleChar: %c\n", *sampleChar);

  printf("sampleCharHnd: End.\n");
  fflush(stdout);

  ReplyData = 3;

  tcaReply(ref, &ReplyData);

}

static void ucmatMapHnd(TCA_REF_PTR Ref, ucmat *ucmatMap)
{
  ReplyType ReplyData;

  printf("ucmatMapHnd: Start.\n");

  printf("%x\n", ucmatMap->el[1][5]);
  printf("%x\n", ucmatMap->el[1][6]);
  printf("%x\n", ucmatMap->el[1][7]);
  printf("%x\n", ucmatMap->el[2][5]);
  printf("%x\n", ucmatMap->el[2][6]);
  printf("%x\n", ucmatMap->el[2][7]);
  fflush(stdout);

  ReplyData = 0;

  tcaReply(Ref, &ReplyData);

  printf("ucmatMapHnd: End.\n");
  fflush(stdout);
}

static void cmatMapHnd(TCA_REF_PTR Ref, cmat *cmatMap)
{
  ReplyType ReplyData;

  printf("cmatMapHnd: Start.\n");

  printf("%c\n", cmatMap->el[1][5]);
  printf("%c\n", cmatMap->el[1][6]);
  printf("%c\n", cmatMap->el[1][7]);
  printf("%c\n", cmatMap->el[2][5]);
  printf("%c\n", cmatMap->el[2][6]);
  printf("%c\n", cmatMap->el[2][7]);
  fflush(stdout);

  ReplyData = 1;

  tcaReply(Ref, &ReplyData);

  printf("cmatMapHnd: End.\n");
  fflush(stdout);
}

static void smatMapHnd(TCA_REF_PTR Ref, smat *smatMap)
{
  ReplyType ReplyData;

  printf("smatMapHnd: Start.\n");

  printf("%d\n", smatMap->el[1][5]);
  printf("%d\n", smatMap->el[1][6]);
  printf("%d\n", smatMap->el[1][7]);
  printf("%d\n", smatMap->el[2][5]);
  printf("%d\n", smatMap->el[2][6]);
  printf("%d\n", smatMap->el[2][7]);
  fflush(stdout);

  ReplyData = 2;

  tcaReply(Ref, &ReplyData);

  printf("smatMapHnd: End.\n");
  fflush(stdout);
}

static void imatMapHnd(TCA_REF_PTR Ref, imat *imatMap)
{
  ReplyType ReplyData;

  printf("dmatMapHnd: Start.\n");

  printf("%d\n", imatMap->el[1][5]);
  printf("%d\n", imatMap->el[1][6]);
  printf("%d\n", imatMap->el[1][7]);
  printf("%d\n", imatMap->el[2][5]);
  printf("%d\n", imatMap->el[2][6]);
  printf("%d\n", imatMap->el[2][7]);
  fflush(stdout);

  ReplyData = 3;

  tcaReply(Ref, &ReplyData);

  printf("imatMapHnd: End.\n");
  fflush(stdout);
}

static void lmatMapHnd(TCA_REF_PTR Ref, lmat *lmatMap)
{
  ReplyType ReplyData;

  printf("lmatMapHnd: Start.\n");

  printf("%ld\n", lmatMap->el[1][5]);
  printf("%ld\n", lmatMap->el[1][6]);
  printf("%ld\n", lmatMap->el[1][7]);
  printf("%ld\n", lmatMap->el[2][5]);
  printf("%ld\n", lmatMap->el[2][6]);
  printf("%ld\n", lmatMap->el[2][7]);
  fflush(stdout);

  ReplyData = 4;

  tcaReply(Ref, &ReplyData);

  printf("lmatMapHnd: End.\n");
  fflush(stdout);
}

static void fmatMapHnd(TCA_REF_PTR Ref, fmat *fmatMap)
{
  ReplyType ReplyData;

  printf("fmatMapHnd: Start.\n");

  printf("%f\n", fmatMap->el[1][5]);
  printf("%f\n", fmatMap->el[1][6]);
  printf("%f\n", fmatMap->el[1][7]);
  printf("%f\n", fmatMap->el[2][5]);
  printf("%f\n", fmatMap->el[2][6]);
  printf("%f\n", fmatMap->el[2][7]);
  fflush(stdout);

  ReplyData = 5;

  tcaReply(Ref, &ReplyData);

  printf("fmatMapHnd: End.\n");
  fflush(stdout);
}

static void dmatMapHnd(TCA_REF_PTR Ref, dmat *dmatMap)
{
  ReplyType ReplyData;

  printf("dmatMapHnd: Start.\n");

  printf("%f\n", dmatMap->el[1][5]);
  printf("%f\n", dmatMap->el[1][6]);
  printf("%f\n", dmatMap->el[1][7]);
  printf("%f\n", dmatMap->el[2][5]);
  printf("%f\n", dmatMap->el[2][6]);
  printf("%f\n", dmatMap->el[2][7]);
  fflush(stdout);

  ReplyData = 6;

  tcaReply(Ref, &ReplyData);

  printf("dmatMapHnd: End.\n");
  fflush(stdout);
}

static void LinkHnd(TCA_REF_PTR Ref, s2Ptr s2)
{
  s2Ptr tmp;
  ReplyType ReplyData;

  printf("LinkHnd: Start.\n");

  tmp = s2;
  while(tmp) {
    printf("s2->a: %d\n", tmp->a);
    printf("s2->b: %d\n", tmp->b);
    printf("s2->s: %s\n", tmp->s);
    printf("\n");
    /* should free this list when we are done with it. */
    tmp = tmp->next;
  }
  fflush(stdout);

  ReplyData = 9;

  printf("LinkHnd: End.\n");
  fflush(stdout);

  tcaReply(Ref, &ReplyData);
}

static void FixedArrayHnd(TCA_REF_PTR Ref, two_d_array fixed_array)
{
  ReplyType ReplyData;
  int32       i, j;

  printf("FixedArrayHnd: Start.\n");

  for(i=0; i<FIXED_ARRAY_DIM1; i++) {
    for(j=0; j<FIXED_ARRAY_DIM2; j++)
      printf("%d ", fixed_array[i][j]);
    printf("\n");
  }

  ReplyData = 10;

  printf("FixedArrayHnd: End.\n");
  fflush(stdout);

  tcaReply(Ref, &ReplyData);
}

static void VarArrayHnd(TCA_REF_PTR Ref, var_array *varArray)
{ 
  ReplyType ReplyData;
  int32       i;

  printf("VarArrayHnd: Start.\n");

  for(i=0; i<varArray->dim1; i++){
    printf("%s ", varArray->elements1[i]);
    printf("\n");
  }

  for(i=0; i<varArray->dim2; i++){
    printf("%s ", varArray->elements2[i]);
    printf("\n");
  }
  
  ReplyData = 10;

  printf("VarArrayHnd: End.\n");
  fflush(stdout);

  tcaReply(Ref, &ReplyData);
}

static void VarArrayTwoHnd(TCA_REF_PTR Ref, var_two_d_array *varArray)
{ 
  ReplyType ReplyData;
  int32       i, j, accessor;

  printf("VarArrayTwoHnd: Start.\n");

  for(i=0; i<varArray->dim1; i++){
    for(j=0; j<varArray->dim2; j++) {
      /* Can't do multiple subscripts on variable length arrays */
      accessor = i + j*varArray->dim1;
      printf("%s ", varArray->elements[accessor]);
    }
    printf("\n");
  }

  ReplyData = 10;

  printf("VarArrayTwoHnd: End.\n");
  fflush(stdout);

  tcaReply(Ref, &ReplyData);
}

#define set_point(point, x1, y1, z1) \
{ (point).x = x1; (point).y = y1; (point).z = z1;}

#define set_two_points(two_points, Leg_No, Name, x1, y1, z1, x2, y2, z2) \
{ (two_points).leg_no = Leg_No; (two_points).name = Name; \
  set_point((two_points).pt1, x1, y1, z1); \
  set_point((two_points).pt2, x2, y2, z2);}

static void print_point (point *apoint)
{ 
  if (apoint)
    printf("Point: %f, %f, %f\n", apoint->x, apoint->y, apoint->z);
  else
    printf("No Point\n");
  fflush(stdout);
}

static void print_two_points (two_points *twopoints)
{ 
  if (twopoints) {
    printf("Two Points: %d, %s\n", twopoints->leg_no, twopoints->name);
    printf("     "); print_point(&(twopoints->pt1));
    printf("     "); print_point(&(twopoints->pt2));
  }
  else printf("No Points\n");
  fflush(stdout);
}

static void print_complex_points (complex_points *complexpoints)
{ 
  int32 i;

  printf("Complex Point:\n");
  for(i=0; i<6; i++) {
    printf("%d. ", i); 
    print_point(&(complexpoints->points[i]));
  }
  if (complexpoints->length)
    for(i=0; i<complexpoints->length; i++) {
      printf("%d. ", i); 
      print_two_points(&(complexpoints->more_points[i]));
    }
  else printf("No Points\n");
  print_point(complexpoints->pt_ptr);
  fflush(stdout);
}

static void PointsHnd(TCA_REF_PTR Ref, complex_points *Points)
{
  two_points reply_point;

  print_complex_points(Points);

  if (Points->more_points) reply_point = Points->more_points[1];
  else set_two_points(reply_point, -1,
		      "Null Reply", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

  tcaReply(Ref, &reply_point);
/*
  tcaClose();
  exit(0);
*/
}

static void structTest1Hnd(TCA_REF_PTR ref, STRUCT_TEST1_PTR t)
{
  int32 r;

  r = 1;

  printf("structTest1Hnd: start\n");

  printf("test1->x: %d\n", t->x);
  printf("test1->a: %c\n", t->a);
  printf("test1->y: %f\n", t->y);
  fflush(stdout);

  tcaReply(ref, &r);
  printf("structTest1Hnd: end\n");
  fflush(stdout);
}

static void structTest2Hnd(TCA_REF_PTR ref, STRUCT_TEST2_PTR t)
{
  int32 r;

  r = 2;

  printf("structTest2Hnd: start\n");

  printf("test2->x: %d\n", t->x);
  printf("test2->y: %f\n", t->y);
  printf("test2->a: %c\n", t->a);
  fflush(stdout);

  tcaReply(ref, &r);
  printf("structTest2Hnd: end\n");
  fflush(stdout);
}

static void structTest3Hnd(TCA_REF_PTR ref, STRUCT_TEST3_PTR t)
{
  int32 r;

  r = 3;

  printf("structTest3Hnd: start\n");

  printf("test3->x: %d\n", t->x);
  printf("test3->a: %c\n", t->a);
  fflush(stdout);

  tcaReply(ref, &r);
  printf("structTest3Hnd: end\n");
  fflush(stdout);
}

static void structTest4Hnd(TCA_REF_PTR ref, STRUCT_TEST4_PTR t)
{
  int32 r;

  r = 4;

  printf("structTest4Hnd: start\n");

  printf("test4->w: %d\n", t->w);
  printf("test4->t.x: %d\n", t->t.x);
  printf("test4->t.a: %c\n", t->t.a);
  printf("test4->z: %f\n", t->z);
  fflush(stdout);

  tcaReply(ref, &r);
  printf("structTest4Hnd: end\n");
  fflush(stdout);
}

static void sHnd(TCA_REF_PTR ref, int32 *item)
{
  printf("constraint test\n");

  printf("item: %d\n", *item);
/*
  printf("press return.\n");
  getchar();
*/
  fflush(stdout);
}

static void printTree(TREE_PTR tree) 
{
  if (tree == NULL) {
    printf("NULL\n");
  } else {
    printf("Node %d %d\n",tree->nodeValue, tree->numChildren);
    printTree(tree->children);
  }
}

static void treeHnd(TCA_REF_PTR ref, TREE_PTR tree)
{
  printf("Tree\n");
  printTree(tree);
  fflush(stdout);
}


static void regInit(void)
{
  tcaDirectResource("Module B");

  tcaRegisterQuery("SelfQueryMsg", "int", "int", SelfQueryHnd);

  tcaRegisterQuery("LinkTestMsg", s2TypeForm, ReplyDataForm, LinkHnd);
/*  tcaAddHndToResource("LinkTestMsg", "Module B");*/
  tcaRegisterGoal("GoalMsg", SampleDataForm, GoalHnd);

  tcaRegisterGoal("GoalMsg2", SampleDataForm, GoalHnd);

  tcaRegisterQuery("SampleMsg", SampleDataForm, ReplyDataForm, SampleHnd);
/*
  tcaRegisterResource("Miasma", 1);
  tcaRegisterResource("Vapor", 1);
  tcaAddHndToResource("SampleHnd", "Miasma");
  tcaAddHndToResource("SampleHnd", "Vapor");
*/
  
  tcaRegisterQuery("PolyMsg",
		   "{int, <float:4>, <float:4>, int}",
		   ReplyDataForm,
		   PolyHnd);

  tcaRegisterQuery("charMsg", "char", ReplyDataForm, charMsgHnd);

  tcaRegisterQuery("ucmatMsg", "cmat", ReplyDataForm, ucmatMapHnd);

  tcaRegisterQuery("cmatMsg", "cmat", ReplyDataForm, cmatMapHnd);

  tcaRegisterQuery("smatMsg", "smat", ReplyDataForm, smatMapHnd);

  tcaRegisterQuery("imatMsg", "imat", ReplyDataForm, imatMapHnd);

  tcaRegisterQuery("lmatMsg", "lmat", ReplyDataForm, lmatMapHnd);

  tcaRegisterQuery("fmatMsg", "fmat", ReplyDataForm, fmatMapHnd);

  tcaRegisterQuery("dmatMsg", "dmat", ReplyDataForm, dmatMapHnd);

  tcaRegisterQuery("FixedArrayMsg", two_d_array_form, 
		   ReplyDataForm, FixedArrayHnd);
  
  tcaRegisterQuery("VarArrayMsg", var_array_form, 
		   ReplyDataForm, VarArrayHnd);
  
  tcaRegisterQuery("VarArrayTwoMsg", var_two_d_array_form, 
		     ReplyDataForm, VarArrayTwoHnd);

  tcaRegisterNamedFormatter("point", point_format);
  tcaRegisterNamedFormatter("two_points", two_points_format);
  tcaRegisterQuery("StructuredFormatters", 
		     complex_points_format, "two_points", PointsHnd);


  tcaRegisterQuery("structTest1Msg", TEST1_FORM, ReplyDataForm,
		   structTest1Hnd);

  tcaRegisterQuery("structTest2Msg", TEST2_FORM, ReplyDataForm,
		   structTest2Hnd);

  tcaRegisterQuery("structTest3Msg", TEST3_FORM, ReplyDataForm,
		   structTest3Hnd);

  tcaRegisterQuery("structTest4Msg", TEST4_FORM, ReplyDataForm,
		   structTest4Hnd);

  tcaRegisterInform("sampleConstraint1", "int", sHnd);

  tcaRegisterInform("sampleConstraint2", "int", sHnd);

  tcaAddHndToResource("sampleConstraint1", "Module B");
  tcaAddHndToResource("sampleConstraint2", "Module B");
  tcaRegisterNamedFormatter(TREE_NAME, TREE_FORMAT);
  tcaRegisterInform("treeInform", TREE_NAME, treeHnd);
}

/*
void specialExit(void)
{
  printf("weee special exit.\n");
  fflush(stdout);
}
*/

#if defined(VXWORKS)
void b1main(char *host)
#else
void main(int argc, char **argv)
#endif
{
  printf("Connect ...\n");
  fflush(stdout);
  
#if defined(VXWORKS)
  tcaConnectModule("Module B", host);
  regInit();
#else
  tcaConnectModule("Module B", tcaServerMachine());
#endif

/*  tcaRegisterExitProc(specialExit);*/

  regInit();
  
  tcaWaitUntilReady();

  fprintf(stdout,"wait for reply: done\n");
  fflush(stdout);

  tcaModuleListen();
}
