/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1994.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/a1_var.c,v $ 
 * $Revision: 1.8 $
 * $Date: 1996/02/10 23:35:30 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: a1_var.c,v $
 * Revision 1.8  1996/02/10  23:35:30  rich
 * Fixed main calls.
 *
 * Revision 1.7  1995/12/17  20:23:13  rich
 * Flush stdout to work better with nanny.
 *
 * Revision 1.6  1995/07/12  04:56:17  rich
 * Release of 8.0.
 * Added test for new features.
 *
 * Revision 1.5  1995/04/07  05:04:42  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.4  1995/03/30  15:48:55  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 *
 * Revision 1.3  1995/03/16  18:05:51  rich
 * Merged in changes to the 7.9 branch.
 * Changed the VERSION_ to TCA_VERSION_
 *
 * Revision 1.2  1994/11/02  21:36:13  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Made libc.h and tcaMatrix.h module includes.
 *
 * Revision 1.1  1994/05/17  23:20:37  rich
 * Added global variable test routines a1_var and b1_var.  Also make some
 * changes so it would compile on an sgi machine.
 *
 *
 *****************************************************************************/

#include "tca/libc.h"

#include "tca.h"

#include "sample.h"

#if defined(VXWORKS)
void a1main(host)
char *host;
#else
void main(int argc, char **argv)
#endif
{
  int i;
  SampleType      sampleVar1, sampleVar2;
  
  printf("Connect ...\n");
  fflush(stdout);
  
#if defined(VXWORKS)
  tcaConnectModule("Module A", host);
#else
  tcaConnectModule("Module A", tcaServerMachine());
#endif
  
  tcaRegisterVar("SampleVar", SampleDataForm);
  
  tcaModuleRequires("Module B", NULL);
  tcaWaitUntilReady();
  
  sampleVar1.x = 17;
  sampleVar1.s = (StringType) malloc(sizeof(char)*4);
  sampleVar1.s[0] = 'a';
  sampleVar1.s[1] = 'b';
  sampleVar1.s[2] = 'c';
  sampleVar1.s[3] = '\0';

  for  (i=0; i<1000; i++) {
    tcaSetVar(SampleVarName, &sampleVar1);
    tcaGetVar(SampleVarName, &sampleVar2);
    sampleVar1.x = 33+i;
    tcaGetSetVar(SampleVarName, &sampleVar1, &sampleVar2);
/*    sleep(1);*/
  }

  tcaDisplayTaskTree(tcaRootNode());

  tcaClose();
  exit(0);
}
