
#include "tca/libc.h"
#include "tca.h"

#include "sample.h"

#define set_point(point, x1, y1, z1) \
{ (point).x = x1; (point).y = y1; (point).z = z1;}

#define set_two_points(two_points, Leg_No, Name, x1, y1, z1, x2, y2, z2) \
{ (two_points).leg_no = Leg_No; (two_points).name = Name; \
  set_point((two_points).pt1, x1, y1, z1); \
  set_point((two_points).pt2, x2, y2, z2);}

void print_point (apoint) point *apoint;
{ 
  if (apoint) 
    printf("Point: %f, %f, %f\n", apoint->x, apoint->y, apoint->z);
  else 
    printf("No Point\n");
  fflush(stdout);
}

void print_two_points (twopoints) two_points *twopoints;
{ 
  if (twopoints) {
    printf("Two Points: %d, %s\n", twopoints->leg_no, twopoints->name);
    printf("     "); print_point(&(twopoints->pt1));
    printf("     "); print_point(&(twopoints->pt2));
  }
  else 
    printf("No Points\n");
  fflush(stdout);
}

void print_complex_points (complexpoints) complex_points *complexpoints;
{ int i;

  printf("Complex Point:\n");
  for(i=0; i<6; i++) {
    printf("%d. ", i); 
    print_point(&(complexpoints->points[i]));
  }
  if (complexpoints->length)
    for(i=0; i<complexpoints->length; i++) {
      printf("%d. ", i); 
      print_two_points(&(complexpoints->more_points[i]));
    }
  else printf("No Points\n");
  print_point(complexpoints->pt_ptr);
}

void main(int argc, char **argv)
{ int             i, j, accessor;
  ReplyType       ReplyData;
  SampleType      Sample;
  PolyType        Poly;
  s2Ptr           s2;
  two_d_array     fixed_array;
  var_two_d_array var_array;
  complex_points the_points;
  two_points     the_answer;

  TCA_REF_PTR RandomGoalRef;

  ucmat ucmatMap;
  cmat cmatMap;
  smat smatMap;
  imat imatMap;
  lmat lmatMap;
  fmat fmatMap;
  dmat dmatMap;

  char sampleChar;

  int error;

  STRUCT_TEST1_TYPE test1;
  STRUCT_TEST2_TYPE test2;
  STRUCT_TEST3_TYPE test3;
  STRUCT_TEST4_TYPE test4;

  printf("Connect ...\n");
  tcaConnectModule("Module A", tcaServerMachine());

  tcaRegisterMessage("SampleMsg", QueryClass, SampleDataForm, ReplyDataForm);

  tcaModuleRequires("Module B", NULL);
  tcaWaitUntilReady();


  i = 42;
  tcaFailure(NULL, "Top Level Failure Test.", &i);

  tcaInform("sampleConstraint1", &i);

  tcaInform("sampleConstraint2", &i);

  Sample.x = 17;
  Sample.s = (StringType) malloc(sizeof(char)*4);
  Sample.s[0] = 'a';
  Sample.s[1] = 'b';
  Sample.s[2] = 'c';
  Sample.s[3] = '\0';

  Poly.silly = 17;

  Poly.x  = (double *)malloc(sizeof(double)*2);
  Poly.y  = (double *)malloc(sizeof(double)*2);

  Poly.x[0] = 1.0;
  Poly.x[1] = 2.0;

  Poly.y[0] = 3.0;
  Poly.y[1] = 4.0;

  Poly.n = 2;

  RandomGoalRef = tcaCreateReference("GoalMsg");

  tcaExpandGoal("GoalMsg", &Sample);
/*
  tcaExpandGoalWithConstraints(NULL, "GoalMsg", &Sample, SEQ_ACH+SEQ_PLANNING);
*/
/*
  printf("press return.\n");
  getchar();

  printf("continue with Query SampleMsg ...\n");
*/
  tcaQuery("SampleMsg", &Sample, &ReplyData);

/*
  printf("press return.\n");
  getchar();
*/

  printf("Poly.silly: %d\n", Poly.silly);
  printf("Poly.n: %d\n", Poly.n);
  for(i=0;i < 2;i++) {
    printf("Poly.x[%d]: %g\n", i, Poly.x[i]);
    printf("Poly.y[%d]: %g\n", i, Poly.y[i]);
  }
  tcaQuery("PolyMsg", &Poly, &ReplyData);
/*
  printf("press return.\n");
  getchar();
*/
  sampleChar = 'X';
  tcaQuery("charMsg", &sampleChar, &ReplyData);

  ucmatMap = newucmat2(1, 2, 5, 7, &error);
  ucmatMap.el[1][5] = 506;
  ucmatMap.el[1][6] = 507;
  ucmatMap.el[1][7] = 508;
  ucmatMap.el[2][5] = 509;
  ucmatMap.el[2][6] = 510;
  ucmatMap.el[2][7] = 511;

  printf("%x\n", ucmatMap.el[1][5]);
  printf("%x\n", ucmatMap.el[1][6]);
  printf("%x\n", ucmatMap.el[1][7]);
  printf("%x\n", ucmatMap.el[2][5]);
  printf("%x\n", ucmatMap.el[2][6]);
  printf("%x\n", ucmatMap.el[2][7]);

  tcaQuery("ucmatMsg", &ucmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  cmatMap = newcmat2(1, 2, 5, 7, &error);
  cmatMap.el[1][5] = 'a';
  cmatMap.el[1][6] = 'b';
  cmatMap.el[1][7] = 'c';
  cmatMap.el[2][5] = 'd';
  cmatMap.el[2][6] = 'e';
  cmatMap.el[2][7] = 'f';

  printf("%c\n", cmatMap.el[1][5]);
  printf("%c\n", cmatMap.el[1][6]);
  printf("%c\n", cmatMap.el[1][7]);
  printf("%c\n", cmatMap.el[2][5]);
  printf("%c\n", cmatMap.el[2][6]);
  printf("%c\n", cmatMap.el[2][7]);

  tcaQuery("cmatMsg", &cmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);
  
  smatMap = newsmat2(1, 2, 5, 7, &error);
  smatMap.el[1][5] = 1;
  smatMap.el[1][6] = 2;
  smatMap.el[1][7] = 3;
  smatMap.el[2][5] = 4;
  smatMap.el[2][6] = 5;
  smatMap.el[2][7] = 6;

  printf("%d\n", smatMap.el[1][5]);
  printf("%d\n", smatMap.el[1][6]);
  printf("%d\n", smatMap.el[1][7]);
  printf("%d\n", smatMap.el[2][5]);
  printf("%d\n", smatMap.el[2][6]);
  printf("%d\n", smatMap.el[2][7]);

  tcaQuery("smatMsg", &smatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  imatMap = newimat2(1, 2, 5, 7, &error);
  imatMap.el[1][5] = 1;
  imatMap.el[1][6] = 2;
  imatMap.el[1][7] = 3;
  imatMap.el[2][5] = 4;
  imatMap.el[2][6] = 5;
  imatMap.el[2][7] = 6;

  printf("%d\n", imatMap.el[1][5]);
  printf("%d\n", imatMap.el[1][6]);
  printf("%d\n", imatMap.el[1][7]);
  printf("%d\n", imatMap.el[2][5]);
  printf("%d\n", imatMap.el[2][6]);
  printf("%d\n", imatMap.el[2][7]);

  tcaQuery("imatMsg", &imatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  lmatMap = newlmat2(1, 2, 5, 7, &error);
  lmatMap.el[1][5] = 2147483640;
  lmatMap.el[1][6] = 2147483641;
  lmatMap.el[1][7] = 2147483642;
  lmatMap.el[2][5] = 2147483643;
  lmatMap.el[2][6] = 2147483644;
  lmatMap.el[2][7] = 2147483645;

  printf("%ld\n", lmatMap.el[1][5]);
  printf("%ld\n", lmatMap.el[1][6]);
  printf("%ld\n", lmatMap.el[1][7]);
  printf("%ld\n", lmatMap.el[2][5]);
  printf("%ld\n", lmatMap.el[2][6]);
  printf("%ld\n", lmatMap.el[2][7]);

  tcaQuery("lmatMsg", &lmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  fmatMap = newfmat2(1, 2, 5, 7, &error);
  fmatMap.el[1][5] = 1.1;
  fmatMap.el[1][6] = 2.2;
  fmatMap.el[1][7] = 3.3;
  fmatMap.el[2][5] = 4.4;
  fmatMap.el[2][6] = 5.5;
  fmatMap.el[2][7] = 6.6;

  printf("%f\n", fmatMap.el[1][5]);
  printf("%f\n", fmatMap.el[1][6]);
  printf("%f\n", fmatMap.el[1][7]);
  printf("%f\n", fmatMap.el[2][5]);
  printf("%f\n", fmatMap.el[2][6]);
  printf("%f\n", fmatMap.el[2][7]);

  tcaQuery("fmatMsg", &fmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  dmatMap = newdmat2(1, 2, 5, 7, &error);
  dmatMap.el[1][5] = 1.1;
  dmatMap.el[1][6] = 2.2;
  dmatMap.el[1][7] = 3.3;
  dmatMap.el[2][5] = 4.4;
  dmatMap.el[2][6] = 5.5;
  dmatMap.el[2][7] = 6.6;

  printf("%f\n", dmatMap.el[1][5]);
  printf("%f\n", dmatMap.el[1][6]);
  printf("%f\n", dmatMap.el[1][7]);
  printf("%f\n", dmatMap.el[2][5]);
  printf("%f\n", dmatMap.el[2][6]);
  printf("%f\n", dmatMap.el[2][7]);

  tcaQuery("dmatMsg", &dmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  s2 = (s2Type *)malloc(sizeof(s2Type));
  s2->a = 1;
  s2->b = 2;
  s2->s = (StringType) malloc(sizeof(char)*4);
  s2->s[0] = 'a';
  s2->s[1] = 'b';
  s2->s[2] = 'c';
  s2->s[3] = '\0';
  s2->next = (s2Type *)malloc(sizeof(s2Type));
  s2->next->a = 3;
  s2->next->b = 4;
  s2->next->s = (StringType) malloc(sizeof(char)*4);
  s2->next->s[0] = 'e';
  s2->next->s[1] = 'f';
  s2->next->s[2] = 'g';
  s2->next->s[3] = '\0';
  s2->next->next = NULL;

  printf("Query: LinkTestMsg\n");

  tcaQuery("LinkTestMsg", s2, &ReplyData);

  printf("Reply: %d\n", ReplyData);


  printf("Query: FixedArrayMsg %d\n", sizeof(fixed_array));

  for(i=0; i<FIXED_ARRAY_DIM1; i++) {
    for(j=0; j<FIXED_ARRAY_DIM2; j++) {
      fixed_array[i][j] = i+j;
      printf("%d ", fixed_array[i][j]);
    }
    printf("\n");
  }

  tcaQuery("FixedArrayMsg", fixed_array, &ReplyData);
  printf("Reply: %d\n", ReplyData);


  printf("Query: VarArrayMsg\n");

  var_array.dim1 = VAR_ARRAY_DIM1;
  var_array.dim2 = VAR_ARRAY_DIM2;
  var_array.elements = (StringType *)malloc(sizeof(StringType) * 
					    var_array.dim1 * var_array.dim2);
  for(i=0; i<var_array.dim1; i++){
    for(j=0; j<var_array.dim2; j++) {
      /* Can't do multiple subscripts on variable length arrays */
      accessor = i + j*var_array.dim1;
      var_array.elements[accessor] = (StringType)malloc(sizeof(char)*10);
      sprintf(var_array.elements[accessor], "%d-%d\0", i, j);
      printf("%s ", var_array.elements[accessor]);
    }
    printf("\n");
  }

  tcaQuery("VarArrayMsg", &var_array, &ReplyData);
  printf("Reply: %d\n", ReplyData);


  printf("Query: Structured Formatters Msg\n");

  for(i=0;i<6;i++) set_point(the_points.points[i], i+0.1, i+0.5, i+0.9);

  the_points.length = 3;
  the_points.more_points = (two_points *)malloc(the_points.length *
						sizeof(two_points));
  for(i=0;i<the_points.length;i++) 
    set_two_points(the_points.more_points[i], i, "", 
		   i+0.1, i+0.2, i+0.3, i+1.1, i+1.2, i+1.3);
  the_points.more_points[0].name = "The First";
  the_points.more_points[1].name = "The Second";
  the_points.more_points[2].name = "The Third";

  the_points.pt_ptr = NULL;

/*
  the_points.length = 0;
  the_points.more_points = NULL;

  the_points.pt_ptr = (point *)malloc(sizeof(point));
  set_point(*the_points.pt_ptr, 1.23, 4.56, 7.89);
*/
  print_complex_points(&the_points);

  tcaQuery("StructuredFormatters", &the_points, &the_answer);
  print_two_points(&the_answer);

  test1.x = 1;
  test1.a = 'a';
  test1.y = 2;

  tcaQuery("structTest1Msg", &test1, &ReplyData);
  printf("1: struct test: %d\n", ReplyData);

  test2.x = 2;
  test2.y = 3;
  test2.a = 'b';

  tcaQuery("structTest2Msg", &test2, &ReplyData);
  printf("2: struct test: %d\n", ReplyData);

  test3.x = 4;
  test3.a = 'c';

  tcaQuery("structTest3Msg", &test3, &ReplyData);
  printf("3: struct test: %d\n", ReplyData);

  test4.w = 5;
  test4.t.x = 6;
  test4.t.a = 'd';
  test4.z = 7;

  tcaQuery("structTest4Msg", &test4, &ReplyData);
  printf("4: struct test: %d\n", ReplyData);

/*  tcaClose();*/
}
