/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/a1.c,v $ 
 * $Revision: 1.17 $
 * $Date: 1996/02/14 22:13:11 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: a1.c,v $
 * Revision 1.17  1996/02/14  22:13:11  rich
 * Fix problems with static declarations.
 *
 * Revision 1.16  1996/02/10  23:35:28  rich
 * Fixed main calls.
 *
 * Revision 1.15  1996/01/27  21:55:36  rich
 * Pre-release of 8.4.
 * Added test for recursive named types.
 * Iain's windows changes.
 *
 * Revision 1.14  1995/12/17  20:23:11  rich
 * Flush stdout to work better with nanny.
 *
 * Revision 1.13  1995/07/12  04:56:14  rich
 * Release of 8.0.
 * Added test for new features.
 *
 * Revision 1.12  1995/04/07  05:04:37  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Fixed problems found by sgi cc compiler.  Many type problems.
 *
 * Revision 1.11  1995/03/30  15:48:48  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 *
 * Revision 1.10  1995/03/28  01:16:21  rich
 * Cleanup.
 *
 * Revision 1.9  1995/03/19  19:43:29  rich
 * Modified a1 and b1 to use direct connections.
 * Added a benchmark (sender3_1 and receiver3_1) to test direct connections.
 *
 * Revision 1.8  1995/03/16  18:05:50  rich
 * Merged in changes to the 7.9 branch.
 * Changed the VERSION_ to TCA_VERSION_
 *
 * Revision 1.7  1994/11/02  21:36:08  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Made libc.h and tcaMatrix.h module includes.
 *
 * Revision 1.6  1994/05/17  23:20:35  rich
 * Added global variable test routines a1_var and b1_var.  Also make some
 * changes so it would compile on an sgi machine.
 *
 * Revision 1.5  1994/04/16  19:47:00  rich
 * First release of TCA for the DEC alpha.
 *
 * New tests for variable length arrays.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.4  1994/01/31  19:15:14  reids
 * Minor cleanup to code.
 *
 * Revision 1.3  1993/06/22  14:02:44  rich
 * Fixed some warnings.
 * Updated the -D<arch> flags to correspond to those generated
 * automatically by the makefile.
 * Changed system includes to the proper format "stdio.h" -> <stdio.h>.
 * This was needed so that the automatic dependency generation can
 * distinguish between "local" and system headers.  The location of the
 * system headers changes from architecture to architecture and should not
 * be included in the dependency list.
 *
 * Revision 1.2  1993/05/27  22:22:59  rich
 * Added automatic logging.
 *
 *****************************************************************************/

#include "tca/libc.h"

#include "tca.h"

#include "sample.h"

#define set_point(point, x1, y1, z1) \
{ (point).x = x1; (point).y = y1; (point).z = z1;}

#define set_two_points(two_points, Leg_No, Name, x1, y1, z1, x2, y2, z2) \
{ (two_points).leg_no = Leg_No; (two_points).name = Name; \
  set_point((two_points).pt1, x1, y1, z1); \
  set_point((two_points).pt2, x2, y2, z2);}

static void print_point (point *apoint)
{ 
  if (apoint) 
    printf("Point: %f, %f, %f\n", apoint->x, apoint->y, apoint->z);
  else 
    printf("No Point\n");
  fflush(stdout);
}

static void print_two_points (two_points *twopoints)
{ 
  if (twopoints) {
    printf("Two Points: %d, %s\n", twopoints->leg_no, twopoints->name);
    printf("     "); print_point(&(twopoints->pt1));
    printf("     "); print_point(&(twopoints->pt2));
  }
  else printf("No Points\n");
  fflush(stdout);
}

static void print_complex_points (complex_points *complexpoints)
{ int i;

  printf("Complex Point:\n");
  for(i=0; i<6; i++) {
    printf("%d. ", i); 
    print_point(&(complexpoints->points[i]));
  }
  if (complexpoints->length)
    for(i=0; i<complexpoints->length; i++) {
      printf("%d. ", i); 
      print_two_points(&(complexpoints->more_points[i]));
    }
  else printf("No Points\n");
  print_point(complexpoints->pt_ptr);
  fflush(stdout);
}

/*
void tmpProc(void)
{
  printf("weeee\n");
  fflush(stdout);
}
*/

#if defined(VXWORKS)
void a1main(host)
char *host;
#else
void main(int argc, char **argv)
#endif
{ int             i, j, accessor;
  ReplyType       ReplyData;
  SampleType      Sample;
  PolyType        Poly;
  s2Ptr           s2;
  two_d_array     fixed_array;
  var_array       var_array;
  var_two_d_array var_two_array;
  complex_points the_points;
  two_points     the_answer;
  TREE_PTR tree;

  TCA_REF_PTR RandomGoalRef;

  ucmat ucmatMap;
  cmat cmatMap;
  smat smatMap;
  imat imatMap;
  lmat lmatMap;
  fmat fmatMap;
  dmat dmatMap;

  char sampleChar;

  int error;

  STRUCT_TEST1_TYPE test1;
  STRUCT_TEST2_TYPE test2;
  STRUCT_TEST3_TYPE test3;
  STRUCT_TEST4_TYPE test4;

  printf("Connect ...\n");
  fflush(stdout);

#if defined(VXWORKS)
  tcaConnectModule("Module A", host);
#else
  tcaConnectModule("Module A", tcaServerMachine());
#endif

  tcaRegisterMessage("SampleMsg", QueryClass, SampleDataForm, ReplyDataForm);

  tcaModuleRequires("Module B", NULL);
  tcaWaitUntilReady();

  test1.x = 1;
  test1.a = 'a';
  test1.y = 2.0;

  tcaQuery("structTest1Msg", &test1, &ReplyData);
  printf("1: struct test: %d\n", ReplyData);
  fflush(stdout);


  i = 42;
  tcaFailure(NULL, "Top Level Failure Test.", &i);

  tcaInform("sampleConstraint1", &i);

  tcaInform("sampleConstraint2", &i);

  Sample.x = 17;
  Sample.s = (StringType) malloc(sizeof(char)*4);
  Sample.s[0] = 'a';
  Sample.s[1] = 'b';
  Sample.s[2] = 'c';
  Sample.s[3] = '\0';

  Poly.silly = 17;

  Poly.x  = (float *)malloc(sizeof(float)*2);
  Poly.y  = (float *)malloc(sizeof(float)*2);

  Poly.x[0] = 1.0;
  Poly.x[1] = 2.0;

  Poly.y[0] = 3.0;
  Poly.y[1] = 4.0;

  Poly.n = 2;

  RandomGoalRef = tcaCreateReference("GoalMsg");

  tcaExpandGoal("GoalMsg", &Sample);
  tcaExpandGoal("GoalMsg2", &Sample);
/*
  tcaExpandGoalWithConstraints(NULL, "GoalMsg", &Sample, SEQ_ACH+SEQ_PLANNING);
*/

  printf("continue with Query SampleMsg ...\n");
  fflush(stdout);
  tcaQuery("SampleMsg", &Sample, &ReplyData);

  sampleChar = 'X';
  tcaQuery("charMsg", &sampleChar, &ReplyData);

  ucmatMap = newucmat2(1, 2, 5, 7, &error);
  ucmatMap.el[1][5] = (unsigned char) 506;
  ucmatMap.el[1][6] = (unsigned char) 507;
  ucmatMap.el[1][7] = (unsigned char) 508;
  ucmatMap.el[2][5] = (unsigned char) 509;
  ucmatMap.el[2][6] = (unsigned char) 510;
  ucmatMap.el[2][7] = (unsigned char) 511;

  printf("%x\n", ucmatMap.el[1][5]);
  printf("%x\n", ucmatMap.el[1][6]);
  printf("%x\n", ucmatMap.el[1][7]);
  printf("%x\n", ucmatMap.el[2][5]);
  printf("%x\n", ucmatMap.el[2][6]);
  printf("%x\n", ucmatMap.el[2][7]);
  fflush(stdout);

  tcaQuery("ucmatMsg", &ucmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);
  fflush(stdout);

  cmatMap = newcmat2(1, 2, 5, 7, &error);
  cmatMap.el[1][5] = 'a';
  cmatMap.el[1][6] = 'b';
  cmatMap.el[1][7] = 'c';
  cmatMap.el[2][5] = 'd';
  cmatMap.el[2][6] = 'e';
  cmatMap.el[2][7] = 'f';

  printf("%c\n", cmatMap.el[1][5]);
  printf("%c\n", cmatMap.el[1][6]);
  printf("%c\n", cmatMap.el[1][7]);
  printf("%c\n", cmatMap.el[2][5]);
  printf("%c\n", cmatMap.el[2][6]);
  printf("%c\n", cmatMap.el[2][7]);
  fflush(stdout);

  tcaQuery("cmatMsg", &cmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);
  fflush(stdout);
  
  smatMap = newsmat2(1, 2, 5, 7, &error);
  smatMap.el[1][5] = 1;
  smatMap.el[1][6] = 2;
  smatMap.el[1][7] = 3;
  smatMap.el[2][5] = 4;
  smatMap.el[2][6] = 5;
  smatMap.el[2][7] = 6;

  printf("%d\n", smatMap.el[1][5]);
  printf("%d\n", smatMap.el[1][6]);
  printf("%d\n", smatMap.el[1][7]);
  printf("%d\n", smatMap.el[2][5]);
  printf("%d\n", smatMap.el[2][6]);
  printf("%d\n", smatMap.el[2][7]);
  fflush(stdout);

  tcaQuery("smatMsg", &smatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);
  fflush(stdout);

  imatMap = newimat2(1, 2, 5, 7, &error);
  imatMap.el[1][5] = 1;
  imatMap.el[1][6] = 2;
  imatMap.el[1][7] = 3;
  imatMap.el[2][5] = 4;
  imatMap.el[2][6] = 5;
  imatMap.el[2][7] = 6;

  printf("%d\n", imatMap.el[1][5]);
  printf("%d\n", imatMap.el[1][6]);
  printf("%d\n", imatMap.el[1][7]);
  printf("%d\n", imatMap.el[2][5]);
  printf("%d\n", imatMap.el[2][6]);
  printf("%d\n", imatMap.el[2][7]);
  fflush(stdout);

  tcaQuery("imatMsg", &imatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);
  fflush(stdout);

  lmatMap = newlmat2(1, 2, 5, 7, &error);
  lmatMap.el[1][5] = 2147483640;
  lmatMap.el[1][6] = 2147483641;
  lmatMap.el[1][7] = 2147483642;
  lmatMap.el[2][5] = 2147483643;
  lmatMap.el[2][6] = 2147483644;
  lmatMap.el[2][7] = 2147483645;

  printf("%ld\n", lmatMap.el[1][5]);
  printf("%ld\n", lmatMap.el[1][6]);
  printf("%ld\n", lmatMap.el[1][7]);
  printf("%ld\n", lmatMap.el[2][5]);
  printf("%ld\n", lmatMap.el[2][6]);
  printf("%ld\n", lmatMap.el[2][7]);
  fflush(stdout);

  tcaQuery("lmatMsg", &lmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);
  fflush(stdout);

  fmatMap = newfmat2(1, 2, 5, 7, &error);
  fmatMap.el[1][5] = 1.1;
  fmatMap.el[1][6] = 2.2;
  fmatMap.el[1][7] = 3.3;
  fmatMap.el[2][5] = 4.4;
  fmatMap.el[2][6] = 5.5;
  fmatMap.el[2][7] = 6.6;

  printf("%f\n", fmatMap.el[1][5]);
  printf("%f\n", fmatMap.el[1][6]);
  printf("%f\n", fmatMap.el[1][7]);
  printf("%f\n", fmatMap.el[2][5]);
  printf("%f\n", fmatMap.el[2][6]);
  printf("%f\n", fmatMap.el[2][7]);
  fflush(stdout);

  tcaQuery("fmatMsg", &fmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);
  fflush(stdout);

  dmatMap = newdmat2(1, 2, 5, 7, &error);
  dmatMap.el[1][5] = 1.1;
  dmatMap.el[1][6] = 2.2;
  dmatMap.el[1][7] = 3.3;
  dmatMap.el[2][5] = 4.4;
  dmatMap.el[2][6] = 5.5;
  dmatMap.el[2][7] = 6.6;

  printf("%f\n", dmatMap.el[1][5]);
  printf("%f\n", dmatMap.el[1][6]);
  printf("%f\n", dmatMap.el[1][7]);
  printf("%f\n", dmatMap.el[2][5]);
  printf("%f\n", dmatMap.el[2][6]);
  printf("%f\n", dmatMap.el[2][7]);
  fflush(stdout);

  tcaQuery("dmatMsg", &dmatMap, &ReplyData);
  printf("Reply: %d\n", ReplyData);
  fflush(stdout);

  s2 = (s2Type *)malloc(sizeof(s2Type));
  s2->a = 1;
  s2->b = 2;
  s2->s = (StringType) malloc(sizeof(char)*4);
  s2->s[0] = 'a';
  s2->s[1] = 'b';
  s2->s[2] = 'c';
  s2->s[3] = '\0';
  s2->next = (s2Type *)malloc(sizeof(s2Type));
  s2->next->a = 3;
  s2->next->b = 4;
  s2->next->s = (StringType) malloc(sizeof(char)*4);
  s2->next->s[0] = 'e';
  s2->next->s[1] = 'f';
  s2->next->s[2] = 'g';
  s2->next->s[3] = '\0';
  s2->next->next = NULL;

  printf("Query: LinkTestMsg\n");
  fflush(stdout);

  tcaQuery("LinkTestMsg", s2, &ReplyData);

  printf("Reply: %d\n", ReplyData);
  fflush(stdout);


  printf("Query: FixedArrayMsg %ld\n", sizeof(fixed_array));
  fflush(stdout);

  for(i=0; i<FIXED_ARRAY_DIM1; i++) {
    for(j=0; j<FIXED_ARRAY_DIM2; j++) {
      fixed_array[i][j] = i+j;
      printf("%d ", fixed_array[i][j]);
    }
    printf("\n");
  }
  fflush(stdout);

  tcaQuery("FixedArrayMsg", fixed_array, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  printf("Query: VarArrayMsg\n");
  fflush(stdout);

  var_array.dim1 = VAR_ARRAY_DIM1;
  var_array.dim2 = VAR_ARRAY_DIM2;
  var_array.elements1 = (StringType *)malloc(sizeof(StringType) * 
					    var_array.dim1);
  var_array.elements2 = (StringType *)malloc(sizeof(StringType) * 
					    var_array.dim2);
  for(i=0; i<var_array.dim1; i++){
    var_array.elements1[i] = (StringType)malloc(sizeof(char)*10);
    sprintf(var_array.elements1[i], "%d-%d", i, j);
    printf("%s ", var_array.elements1[i]);
  }
  printf("\n");
  fflush(stdout);

  for(j=0; j<var_array.dim2; j++) {
    var_array.elements2[j] = (StringType)malloc(sizeof(char)*10);
    sprintf(var_array.elements2[j], "%d-%d", i, j);
    printf("%s ", var_array.elements2[j]);
  }
  printf("\n");
  fflush(stdout);
  
  tcaQuery("VarArrayMsg", &var_array, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  printf("Query: VarArrayTwoMsg\n");
  fflush(stdout);

  var_two_array.dim1 = VAR_ARRAY_DIM1;
  var_two_array.dim2 = VAR_ARRAY_DIM2;
  var_two_array.elements = (StringType *)malloc(sizeof(StringType) * 
					    var_two_array.dim1 * var_two_array.dim2);
  for(i=0; i<var_two_array.dim1; i++){
    for(j=0; j<var_two_array.dim2; j++) {
      /* Can't do multiple subscripts on variable length arrays */
      accessor = i + j*var_two_array.dim1;
      var_two_array.elements[accessor] = (StringType)malloc(sizeof(char)*10);
      sprintf(var_two_array.elements[accessor], "%d-%d", i, j);
      printf("%s ", var_two_array.elements[accessor]);
    }
    printf("\n");
  }

  tcaQuery("VarArrayTwoMsg", &var_two_array, &ReplyData);
  printf("Reply: %d\n", ReplyData);

  printf("Query: Structured Formatters Msg\n");
  fflush(stdout);

  for(i=0;i<6;i++) set_point(the_points.points[i], i+0.1, i+0.5, i+0.9);

  the_points.length = 3;
  the_points.more_points = (two_points *)malloc(the_points.length *
						sizeof(two_points));
  for(i=0;i<the_points.length;i++) 
    set_two_points(the_points.more_points[i], i, "", 
		   i+0.1, i+0.2, i+0.3, i+1.1, i+1.2, i+1.3);
  the_points.more_points[0].name = "The First";
  the_points.more_points[1].name = "The Second";
  the_points.more_points[2].name = "The Third";

  the_points.pt_ptr = NULL;

/*
  the_points.length = 0;
  the_points.more_points = NULL;

  the_points.pt_ptr = (point *)malloc(sizeof(point));
  set_point(*the_points.pt_ptr, 1.23, 4.56, 7.89);
*/

  printf("Poly.silly: %d\n", Poly.silly);
  printf("Poly.n: %d\n", Poly.n);
  for(i=0;i < 2;i++) {
    printf("Poly.x[%d]: %g\n", i, Poly.x[i]);
    printf("Poly.y[%d]: %g\n", i, Poly.y[i]);
  }
  fflush(stdout);

  tcaQuery("PolyMsg", &Poly, &ReplyData);

  print_complex_points(&the_points);

  tcaQuery("StructuredFormatters", &the_points, &the_answer);
  print_two_points(&the_answer);

  test1.x = 1;
  test1.a = 'a';
  test1.y = 2.0;

  tcaQuery("structTest1Msg", &test1, &ReplyData);
  printf("1: struct test: %d\n", ReplyData);
  fflush(stdout);

  test2.x = 2;
  test2.y = 3;
  test2.a = 'b';

  tcaQuery("structTest2Msg", &test2, &ReplyData);
  printf("2: struct test: %d\n", ReplyData);
  fflush(stdout);

  test3.x = 4;
  test3.a = 'c';

  tcaQuery("structTest3Msg", &test3, &ReplyData);
  printf("3: struct test: %d\n", ReplyData);
  fflush(stdout);

  test4.w = 5;
  test4.t.x = 6;
  test4.t.a = 'd';
  test4.z = 7;

  tcaQuery("structTest4Msg", &test4, &ReplyData);
  printf("4: struct test: %d\n", ReplyData);
  fflush(stdout);

  tree = (TREE_PTR)malloc(sizeof(TREE_TYPE));
  tree->nodeValue = 111;
  tree->numChildren = 1;
  tree->children = (TREE_PTR)malloc(sizeof(TREE_TYPE));
  tree->children->nodeValue = 54;
  tree->children->numChildren = 0;
  tree->children->children = NULL;

  printf("Tree inform\n");
  tcaInform("treeInform",tree);

  tcaClose();

  printf("Completed Successfully\n");
  exit(0);
}
