#############################################################################
#       $Id: windowNT.mak,v 1.3 1996/01/27 21:54:42 rich Exp $
# $Revision: 1.3 $
#     $Date: 1996/01/27 21:54:42 $
#   $Author: rich $
#    $State: Exp $
#
# PROJECT:	TCA
#
# FILE:		Makefile
#
# DESCRIPTION:
# Makes the tca libraries and central server for windows NT using borland C.
#
# Requires a WINSOCK implementation.
#
# EXPORTS:
#
# HISTORY:
#
# $Log: windowNT.mak,v $
# Revision 1.3  1996/01/27  21:54:42  rich
# Pre-release of 8.4.
# Added recursive named formatters and "BAD" formats.  Also incorporated
# Iain's windows changes.
#
# Revision 1.2  1996/01/05  16:31:52  rich
# Added windows NT port.
#
# Revision 1.1  1996/01/04  03:54:41  rich
# Saving port to windowsNT by Iain Shigeoka <shigeoka@mars.eecs.ukans.edu>.
#
#
#############################################################################
.AUTODEPEND

.PATH.obj = ..\obj

#		*Translator Definitions*
CC = Bcc32
TASM = TASM
TLIB = TLib
TLINK = TLink32
IMPLIB  = Implib
BRC32   = Brc32
LIBPATH = -L..\LIB; -LC:\BC45\LIB; -LD:\BC45\LIB; -LC:\BORLANDC\LIB; -LD:\BORLANDC\LIB;
INCLUDEPATH = -I..\INCLUDE; -I..\SRC; -IC:\BORLANDC\INCLUDE; -IC:\BC45\INCLUDE; -ID:\BORLANDC\INCLUDE; -ID:\BC45\INCLUDE;


#		*Implicit Rules*
.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

#		*List Macros*


EXE_dependencies =  \
 ..\obj\comserve.obj \
 ..\obj\dispatch.obj \
 ..\obj\lex.obj \
 ..\obj\recvmsg.obj \
 ..\obj\queue.obj \
 ..\obj\res.obj \
 ..\obj\tplconst.obj \
 ..\obj\tms.obj \
 ..\obj\cells.obj \
 ..\obj\qlattice.obj \
 ..\obj\rules.obj \
 ..\obj\mon.obj \
 ..\obj\tcerror.obj \
 ..\obj\logging.obj \
 ..\obj\tasktree.obj \
 ..\obj\msgtap.obj \
 ..\obj\printdat.obj \
 ..\obj\exceptio.obj \
 ..\obj\globals.obj \
 ..\obj\parsefmt.obj \
 ..\obj\centrali.obj \
 ..\obj\globalva.obj \
 ..\obj\central.obj \
 ..\obj\sizetest.obj \
 ..\lib\tca.lib
 
LIB_dependencies =  \
 ..\obj\list.obj \
 ..\obj\behavior.obj \
 ..\obj\tcmoderr.obj \
 ..\obj\datamsg.obj \
 ..\obj\formatte.obj \
 ..\obj\hash.obj \
 ..\obj\idtable.obj \
 ..\obj\key.obj \
 ..\obj\monmod.obj \
 ..\obj\primfmtt.obj \
 ..\obj\reg.obj \
 ..\obj\resmod.obj \
 ..\obj\sendmsg.obj \
 ..\obj\tsktreem.obj \
 ..\obj\tcamatri.obj \
 ..\obj\tcamem.obj \
 ..\obj\tcaref.obj \
 ..\obj\tplmodul.obj \
 ..\obj\msgtapmo.obj \
 ..\obj\excepmod.obj \
 ..\obj\commodul.obj \
 ..\obj\com.obj \
 ..\obj\globalm.obj \
 ..\obj\globalmu.obj \
 ..\obj\modvar.obj\
 ..\obj\modLoggi.obj \
 ..\obj\strList.obj 

all: ..\lib\tca.lib ..\bin\central.exe ..\bin\sizetest.exe

#		*Explicit Rules*
..\lib\tca.lib: tca.cfg $(LIB_dependencies)
  - del ..\lib\tca.lib
  $(TLIB) $< /e/E/P128 @&&|
-+..\obj\list.obj &
-+..\obj\strList.obj &
-+..\obj\behavior.obj &
-+..\obj\tcmoderr.obj &
-+..\obj\datamsg.obj &
-+..\obj\formatte.obj &
-+..\obj\hash.obj &
-+..\obj\idtable.obj &
-+..\obj\key.obj &
-+..\obj\monmod.obj &
-+..\obj\primfmtt.obj &
-+..\obj\reg.obj &
-+..\obj\resmod.obj &
-+..\obj\sendmsg.obj &
-+..\obj\tsktreem.obj &
-+..\obj\tcamatri.obj &
-+..\obj\tcamem.obj &
-+..\obj\tcaref.obj &
-+..\obj\tplmodul.obj &
-+..\obj\msgtapmo.obj &
-+..\obj\excepmod.obj &
-+..\obj\commodul.obj &
-+..\obj\modLoggi.obj &
-+..\obj\com.obj &
-+..\obj\globalm.obj &
-+..\obj\globalmu.obj &
-+..\obj\modvar.obj,$*.lst
|

..\bin\central.exe: central.cfg $(EXE_dependencies)
  $(TLINK) -Tpe -ap  -v $(LIBPATH) @&&|
c0x32.obj+
..\obj\comserve.obj+
..\obj\dispatch.obj+
..\obj\lex.obj+
..\obj\recvmsg.obj+
..\obj\queue.obj+
..\obj\res.obj+
..\obj\tplconst.obj+
..\obj\tms.obj+
..\obj\cells.obj+
..\obj\qlattice.obj+
..\obj\rules.obj+
..\obj\mon.obj+
..\obj\tcerror.obj+
..\obj\logging.obj+
..\obj\printdat.obj+
..\obj\tasktree.obj+
..\obj\msgtap.obj+
..\obj\exceptio.obj+
..\obj\globals.obj+
..\obj\parsefmt.obj+
..\obj\centrali.obj+
..\obj\globalva.obj+
..\obj\central.obj
..\bin\central,..\bin\central
..\lib\tca.lib+
bidsf.lib+
import32.lib+
cw32mt.lib
|

..\bin\sizeTest.exe: sizeTest.cfg $(EXE_dependencies)
  $(TLINK) -Tpe -ap  -v $(LIBPATH) @&&|
c0x32.obj+
..\obj\comserve.obj+
..\obj\dispatch.obj+
..\obj\lex.obj+
..\obj\recvmsg.obj+
..\obj\queue.obj+
..\obj\res.obj+
..\obj\tplconst.obj+
..\obj\tms.obj+
..\obj\cells.obj+
..\obj\qlattice.obj+
..\obj\rules.obj+
..\obj\mon.obj+
..\obj\tcerror.obj+
..\obj\logging.obj+
..\obj\printdat.obj+
..\obj\tasktree.obj+
..\obj\msgtap.obj+
..\obj\exceptio.obj+
..\obj\globals.obj+
..\obj\parsefmt.obj+
..\obj\centrali.obj+
..\obj\globalva.obj+
..\obj\sizeTest.obj
..\bin\sizetest,..\bin\sizetest
..\lib\tca.lib+
bidsf.lib+
import32.lib+
cw32mt.lib
|

#		*Individual File Dependencies*

..\obj\list.obj: tca.cfg list.c 
	$(CC) +tca.cfg -c list.c

..\obj\behavior.obj: tca.cfg behavior.c 
	$(CC) +tca.cfg -c behavior.c

..\obj\tcmoderr.obj: tca.cfg tcmoderr.c 
	$(CC) +tca.cfg -c tcmoderr.c

..\obj\datamsg.obj: tca.cfg datamsg.c 
	$(CC) +tca.cfg -c datamsg.c

..\obj\formatte.obj: tca.cfg formatte.c 
	$(CC) +tca.cfg -c formatte.c

..\obj\hash.obj: tca.cfg hash.c 
	$(CC) +tca.cfg -c hash.c

..\obj\idtable.obj: tca.cfg idtable.c 
	$(CC) +tca.cfg -c idtable.c

..\obj\key.obj: tca.cfg key.c 
	$(CC) +tca.cfg -c key.c

..\obj\monmod.obj: tca.cfg monmod.c 
	$(CC) +tca.cfg -c monmod.c

..\obj\primfmtt.obj: tca.cfg primfmtt.c 
	$(CC) +tca.cfg -c primfmtt.c

..\obj\reg.obj: tca.cfg reg.c 
	$(CC) +tca.cfg -c reg.c

..\obj\resmod.obj: tca.cfg resmod.c 
	$(CC) +tca.cfg -c resmod.c

..\obj\sendmsg.obj: tca.cfg sendmsg.c 
	$(CC) +tca.cfg -c sendmsg.c

..\obj\tsktreem.obj: tca.cfg tsktreem.c 
	$(CC) +tca.cfg -c tsktreem.c

..\obj\tcamatri.obj: tca.cfg tcamatri.c 
	$(CC) +tca.cfg -c tcamatri.c

..\obj\tcamem.obj: tca.cfg tcamem.c 
	$(CC) +tca.cfg -c tcamem.c

..\obj\tcaref.obj: tca.cfg tcaref.c 
	$(CC) +tca.cfg -c tcaref.c

..\obj\tplmodul.obj: tca.cfg tplmodul.c 
	$(CC) +tca.cfg -c tplmodul.c 

..\obj\msgtapmo.obj: tca.cfg msgtapmo.c 
	$(CC) +tca.cfg -c msgtapmo.c 

..\obj\excepmod.obj: tca.cfg excepmod.c 
	$(CC) +tca.cfg -c excepmod.c 

..\obj\commodul.obj: tca.cfg commodul.c 
	$(CC) +tca.cfg -c commodul.c 

..\obj\com.obj: tca.cfg com.c 
	$(CC) +tca.cfg -c com.c 

..\obj\globalm.obj: tca.cfg globalm.c 
	$(CC) +tca.cfg -c globalm.c 

..\obj\globalmu.obj: tca.cfg globalmu.c 
	$(CC) +tca.cfg -c globalmu.c 

..\obj\modvar.obj: tca.cfg modvar.c 
	$(CC) +tca.cfg -c modvar.c 

..\obj\modLoggi.obj: tca.cfg modLoggi.c 
	$(CC) +tca.cfg -c modLoggi.c 

..\obj\strList.obj: tca.cfg strList.c 
	$(CC) +tca.cfg -c strList.c

..\obj\comserve.obj: central.cfg comserve.c 
	$(CC) +CENTRAL.CFG -c comserve.c 

..\obj\dispatch.obj: central.cfg dispatch.c 
	$(CC) +CENTRAL.CFG -c dispatch.c 

..\obj\lex.obj: central.cfg lex.c 
	$(CC) +CENTRAL.CFG -c lex.c 

..\obj\recvmsg.obj: central.cfg recvmsg.c 
	$(CC) +CENTRAL.CFG -c recvmsg.c 

..\obj\queue.obj: central.cfg queue.c 
	$(CC) +CENTRAL.CFG -c queue.c 

..\obj\res.obj: central.cfg res.c 
	$(CC) +CENTRAL.CFG -c res.c 

..\obj\tplconst.obj: central.cfg tplconst.c 
	$(CC) +CENTRAL.CFG -c tplconst.c 

..\obj\tms.obj: central.cfg tms.c 
	$(CC) +CENTRAL.CFG -c tms.c 

..\obj\cells.obj: central.cfg cells.c 
	$(CC) +CENTRAL.CFG -c cells.c 

..\obj\qlattice.obj: central.cfg qlattice.c 
	$(CC) +CENTRAL.CFG -c qlattice.c 

..\obj\rules.obj: central.cfg rules.c 
	$(CC) +CENTRAL.CFG -c rules.c 

..\obj\mon.obj: central.cfg mon.c 
	$(CC) +CENTRAL.CFG -c mon.c 

..\obj\logging.obj: central.cfg logging.c 
	$(CC) +CENTRAL.CFG -c logging.c 

..\obj\tcerror.obj: central.cfg tcerror.c 
	$(CC) +CENTRAL.CFG -c tcerror.c 

..\obj\tasktree.obj: central.cfg tasktree.c 
	$(CC) +CENTRAL.CFG -c tasktree.c 

..\obj\msgtap.obj: central.cfg msgtap.c 
	$(CC) +CENTRAL.CFG -c msgtap.c 

..\obj\printdat.obj: central.cfg printdat.c 
	$(CC) +CENTRAL.CFG -c printdat.c 

..\obj\exceptio.obj: central.cfg exceptio.c 
	$(CC) +CENTRAL.CFG -c exceptio.c 

..\obj\globals.obj: central.cfg globals.c 
	$(CC) +CENTRAL.CFG -c globals.c 

..\obj\parsefmt.obj: central.cfg parsefmt.c 
	$(CC) +CENTRAL.CFG -c parsefmt.c 

..\obj\centrali.obj: central.cfg centrali.c 
	$(CC) +CENTRAL.CFG -c centrali.c 

..\obj\globalva.obj: central.cfg globalva.c 
	$(CC) +CENTRAL.CFG -c globalva.c 

..\obj\central.obj: central.cfg central.c 
	$(CC) +CENTRAL.CFG -c central.c 

..\obj\sizeTest.obj: central.cfg sizeTest.c 
	$(CC) +CENTRAL.CFG -c sizeTest.c 

#		*Compiler Configuration File*
tca.cfg: windowNT.mak
	- mkdir ..\obj
	- mkdir ..\lib
	- mkdir ..\bin
	- mkdir ..\include
	- copy tca.h ..\include
	- mkdir ..\include\tca
	- copy libc.h ..\include\tca
	- copy tcaMatrix.h ..\include\tca
	- rename tcaInternal.h tcaInter.h
	- rename tcaMatrix.h tcaMatri.h
	- rename formatters.h formatte.h
	- rename behaviors.h behavior.h
	- rename comModule.h comModul.h
	- rename centralMsg.h centralM.h
	- rename modLogging.h modLoggi.h 
	- rename tplConstr.h tplConst.h
	- rename printData.h printDat.h
	- rename comServer.h comServe.h
	- rename parseFmttrs.h parseFmt.h
	- rename exception.h exceptio.h
	- rename centralIO.h centralI.h 
	- rename globalVar.h globalVa.h
	copy &&|
-R
-v
-vi
-H
-H=central.csm
-w-sus
-w-par
-w-rch
-WM
-WC
-w-aus
-n..\obj
$(INCLUDEPATH)
$(LIBPATH)
-DNEED_READV=1; -DNO_UNIX_SOCKETS=1
-D_WINSOCK_; -DDOS_FILE_NAMES
-w32
-Tpe 
-x
| tca.cfg

central.cfg: windowNT.mak
	mkdir ..\obj
	mkdir ..\lib
	mkdir ..\bin
	copy &&|
-R
-v
-vi
-H
-H=central.csm
-w-sus
-w-par
-w-rch
-WM
-WC
-w-aus
-n..\obj
$(INCLUDEPATH)
$(LIBPATH)
-DNEED_READV=1; -DNO_UNIX_SOCKETS=1
-D_WINSOCK_; -DDOS_FILE_NAMES
-w32
-Tpe 
-x
| CENTRAL.CFG


sizetest.cfg: windowNT.mak
	copy &&|
-R
-v
-vi
-H
-H=central.csm
-w-sus
-w-par
-w-rch
-WM
-WC
-w-aus
-n..\obj
$(INCLUDEPATH)
$(LIBPATH)
-DNEED_READV=1; -DNO_UNIX_SOCKETS=1
-D_WINSOCK_; -DDOS_FILE_NAMES
-w32
-Tpe 
-x
| sizetest.cfg

