/*****************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: Temporal Constraints
 *
 * FILE: tplModule.c
 *
 * ABSTRACT:
 * Modules interface for using temporal constraints
 *
 * REVISION HISTORY:
 *
 * $Log: tplModule.c,v $
 * Revision 1.9  1995/05/31  19:37:18  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.8  1995/03/19  19:39:52  rich
 * Implemented direct connections using tcaDirectResouce call.
 * Also made the basics.h file a module include.
 * Changed class in the interval structure to be interval_class to avoid a
 * conflict with C++.
 *
 * Revision 1.7  1995/01/18  22:43:46  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.6  1994/05/17  23:18:43  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.5  1993/11/21  20:20:10  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.4  1993/08/30  21:55:15  fedor
 * V7+V6+VXWORKS Everything compiles but there are initialization problems.
 *
 * Revision 1.3  1993/08/27  07:17:45  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:20:03  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:41  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:33:06  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:26:41  fedor
 * Added Logging.
 *
 * 12-May-89  Reid Simmons, School of Computer Science, CMU
 * Split from tplConstr.c
 *
 * $Revision: 1.9 $
 * $Date: 1995/05/31 19:37:18 $
 * $Author: rich $
 *
 *****************************************************************************/

#include "globalM.h"

TCA_TIME_POINT_TYPE tcaStartOf(TCA_INTERVAL_TYPE interval)
{ 
  TCA_TIME_POINT_TYPE startTime;
  
  startTime.point_class = StartPoint;
  startTime.interval = interval;
  return startTime;
}

TCA_TIME_POINT_TYPE tcaEndOf(TCA_INTERVAL_TYPE interval)
{ 
  TCA_TIME_POINT_TYPE endTime;
  
  endTime.point_class = EndPoint;
  endTime.interval = interval;
  return endTime;
}

TCA_INTERVAL_TYPE tcaHandlingOf(TCA_REF_PTR msgRef)
{ 
  TCA_INTERVAL_TYPE handlingInterval;
  
  handlingInterval.interval_class = HandlingInterval;
  handlingInterval.msgRef = (msgRef) ? msgRef->refId : -1;
  return handlingInterval;
}

TCA_INTERVAL_TYPE tcaPlanningOf(TCA_REF_PTR msgRef)
{ 
  TCA_INTERVAL_TYPE planningInterval;
  
  planningInterval.interval_class = PlanningInterval;
  planningInterval.msgRef = (msgRef) ? msgRef->refId : -1;
  return planningInterval;
}

TCA_INTERVAL_TYPE tcaAchievementOf(TCA_REF_PTR msgRef)
{ 
  TCA_INTERVAL_TYPE achievementInterval;
  
  achievementInterval.interval_class = AchievementInterval;
  achievementInterval.msgRef = (msgRef) ? msgRef->refId : -1;
  return achievementInterval;
}

void tcaTplConstrain(TCA_TIME_POINT_TYPE timePoint1, const char *relationship,
		     TCA_TIME_POINT_TYPE timePoint2)
{ 
  TCA_TPL_CONSTRAINT_TYPE tplConstraint;
  
  tplConstraint.timePoint1 = timePoint1;
  tplConstraint.relationship = relationship;
  tplConstraint.timePoint2 = timePoint2;
  
  (void)tcaInform(TCA_CONTRAINT_INFORM, (void *)&tplConstraint);
}
