/******************************************************************************
 *  tplconstr.h
 *
 *  Partial temporal ordering constraints
 *
 * $Log: tplConstr.h,v $
 * Revision 1.15  1996/02/10  16:50:51  rich
 * Fixed header problems and a crash related to direct connections.
 *
 * Revision 1.14  1996/01/30  15:05:11  rich
 * Fixed var array index problem.  Index refers to the enclosing structure.
 * Added ability to force 32 bit enums and changed some #defs to enums to
 * ease debugging.  Fixed initialization problems for central.
 *
 * Revision 1.13  1996/01/27  21:54:41  rich
 * Pre-release of 8.4.
 * Added recursive named formatters and "BAD" formats.  Also incorporated
 * Iain's windows changes.
 *
 * Revision 1.12  1995/12/17  20:22:34  rich
 * Have free routines set pointers to NULL.
 * Removed old makefiles.
 *
 * Revision 1.11  1995/05/31  19:37:16  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.10  1995/04/19  14:29:17  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.9  1995/01/18  22:43:44  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.8  1994/05/17  23:18:41  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.7  1993/12/14  17:35:49  rich
 * Changed getMGlobal to GET_M_GLOBAL and changed getSGlobal to
 * GET_S_GLOBAL to conform to Chris' software standards.
 *
 * Patched problem with connecting between machines with different byte
 * orders.  The real fix requires changing the way formats are stored.
 * Searching for structural similar formats does not guarantee that you
 * find the right format.
 *
 * Revision 1.6  1993/12/01  18:04:52  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.5  1993/11/21  20:20:07  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.4  1993/08/27  08:39:02  fedor
 * Pass 2 aat a V7+V6+VxWorks merge. Many many problems with pointless casting.
 *
 * Revision 1.3  1993/08/27  07:17:42  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:20:00  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:51  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:33:04  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:26:39  fedor
 * Added Logging.
 *
 *  14-Aug-89 Reid Simmons       Added routines for killing task trees
 *                               (Cancel_Activation_Message, FreeInterval, and
 *                               KillAfterAttending check).
 *   2-Aug-89 Reid Simmons       Changed "printf"s to use logging facilities.
 *                               Made changes so you can now issue 
 *                               commands and goals from a Query.
 *  15-May-89 Christopher Fedor  Changed interval type not to make use of
 *                               quantity_ptr typedef to minimize include files
 *                               needed in modules that do not use qlattice.
 *  28-Apr-89 Reid Simmons       Created (based on existing QLattice code)
 *
 * $Revision: 1.15 $
 * $Date: 1996/02/10 16:50:51 $
 * $Author: rich $
 *
 *****************************************************************************/

#ifndef INCtplConstr
#define INCtplConstr

typedef enum {
  start_point=0, end_point=1
#ifdef FORCE_32BIT_ENUM
    , dummyTimeTypes = 0x7FFFFFFF
#endif
} TIME_TYPES;

typedef enum {
  handlingInterval=0, achievementInterval=1, 
  planningInterval=2
#ifdef FORCE_32BIT_ENUM
    , dummyInterval = 0x7FFFFFFF
#endif
} INTERVAL_TYPES;

typedef struct {
  TIME_TYPES     time;
  INTERVAL_TYPES interval;
} time_selection_type, *time_selection_ptr;

typedef struct _interval_type {
  struct _QUANTITY_TYPE *start, *end;
} interval_type, *interval_ptr;

#define IS_TEMPORAL_DISPATCH(dispatch) \
((dispatch)->treeNode && (dispatch)->treeNode->handlingInterval)

#define ATTENDABLE(tree_node) \
!QIs_True(GET_S_GLOBAL(Now), "<", tree_node->handlingInterval->start)

void addTplConstraints(DISPATCH_PTR dispatch, int32 tplConstr);
int32 Less_Than_Now_Relp(TMS_NODE_PTR relationship_node);
int32 Less_Or_Equal_Than_Now_Relp(TMS_NODE_PTR relationship_node);
int32 Relp_Still_Out(TMS_NODE_PTR relationship_node);

void AssertHoldingConstraint(TASK_TREE_NODE_PTR TreeNode);
void RetractHoldingConstraint(TASK_TREE_NODE_PTR TreeNode);
void PendingConstraints(DISPATCH_PTR dispatch);
void InactiveConstraints(DISPATCH_PTR dispatch);
void AttendingConstraints(DISPATCH_PTR dispatch);
void CompletionConstraints(DISPATCH_PTR dispatch);

void Initialize_TaskTreeNode(DISPATCH_PTR dispatch, int32 parentId);
int32 removeParentChildRelations(TASK_TREE_NODE_PTR parentNode, 
			       TASK_TREE_NODE_PTR childNode);
void FreeInterval(interval_ptr *Interval);
QUANTITY_PTR Time_Of(TCA_TIME_POINT_PTR timePoint);
void Tpl_Initialize(void);
char *qName(QUANTITY_PTR q);

#endif /* INCtplConstr */
