/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: tms.h
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/tms.h,v $ 
 * $Revision: 1.12 $
 * $Date: 1995/12/17 20:22:31 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: tms.h,v $
 * Revision 1.12  1995/12/17  20:22:31  rich
 * Have free routines set pointers to NULL.
 * Removed old makefiles.
 *
 * Revision 1.11  1995/07/06  21:17:52  rich
 * Solaris and Linux changes.
 *
 * Revision 1.10  1995/05/31  19:37:12  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.9  1995/01/18  22:43:40  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.8  1994/05/17  23:18:29  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.7  1993/12/14  17:35:41  rich
 * Changed getMGlobal to GET_M_GLOBAL and changed getSGlobal to
 * GET_S_GLOBAL to conform to Chris' software standards.
 *
 * Patched problem with connecting between machines with different byte
 * orders.  The real fix requires changing the way formats are stored.
 * Searching for structural similar formats does not guarantee that you
 * find the right format.
 *
 * Revision 1.6  1993/12/01  18:04:50  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.5  1993/11/21  20:20:03  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.4  1993/08/30  21:55:10  fedor
 * V7+V6+VXWORKS Everything compiles but there are initialization problems.
 *
 * Revision 1.3  1993/08/23  17:41:16  rich
 * Fixed the type definitions for function pointers. Added const
 * declarations.  Removed definitions VOID_FN and INT_FN.
 *
 * Revision 1.2  1993/05/27  22:21:33  rich
 * Added automatic logging.
 *
 *****************************************************************************/

#ifndef INCtms
#define INCtms

typedef struct { 
  const char *informant;
  LIST_PTR supporters;
} JUSTIFICATION_TYPE, *JUSTIFICATION_PTR;

typedef struct _TMS_NODE_TYPE {
  const char *datum;
  LIST_PTR consequents;
  LIST_PTR justifications;
  LIST_PTR rules;
  JUSTIFICATION_PTR supportJustification;
  /* should be "CELL_PTR" but I wanted to keep this modular */
  struct _CELL_TYPE *cell;
} TMS_NODE_TYPE, *TMS_NODE_PTR;

typedef struct { 
  TMS_NODE_PTR node;
  JUSTIFICATION_PTR justification;
} CONSEQUENT_TYPE, *CONSEQUENT_PTR;

#define IS_IN(tms_node) (!IS_OUT(tms_node))
#define IS_OUT(tms_node) ((tms_node)->supportJustification == NULL)
#define NODE_DATUM(tms_node) ((tms_node)->datum)
#define NODE_JUSTIFICATIONS(tms_node) ((tms_node)->justifications)

/**** Returns TRUE if the justification is the assumption justification ****/
#define IS_ASSUMPTION_JUST(just) \
((just) == GET_S_GLOBAL(tmsAssumpJustificationGlobal))

#define NODE_SUPPORT_JUSTIFICATION(tms_node) \
((tms_node)->supportJustification)

#define IS_ASSUMED(tms_node) \
((tms_node)->supportJustification == \
 GET_S_GLOBAL(tmsAssumpJustificationGlobal))

char *String_Copy(const char *string_to_copy);
TMS_NODE_PTR tmsCreateNode(const void *datum);
void tmsFreeNode(TMS_NODE_PTR *node);
JUSTIFICATION_PTR tmsCreateJustification1(const char *informant, 
					  LIST_PTR supporters);
JUSTIFICATION_PTR tmsCreateJustification(const char *informant,
					 LIST_PTR supporters);
LIST_PTR tmsSupport(TMS_NODE_PTR node);
int32 tmsIsPremise(TMS_NODE_PTR node);
void tmsAssumeNode(TMS_NODE_PTR node);
void tmsAssertNode(TMS_NODE_PTR node, const char *reason);
void tmsJustifyNode(TMS_NODE_PTR node, JUSTIFICATION_PTR just);
void tmsUnassumeNode(TMS_NODE_PTR node);
int32 sameReason(const char *reason, JUSTIFICATION_PTR just);
void tmsUnassertNode(TMS_NODE_PTR node, const char *reason);
void tmsContradictory(LIST_PTR nodes_list, const char *reason);
void tmsInit(void);
void tmsPrintTruth(TMS_NODE_PTR node);
void freeJustification(JUSTIFICATION_PTR *justification);

#endif /* INCtms */
