/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: tcerror.h
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/tcerror.h,v $ 
 * $Revision: 1.5 $
 * $Date: 1995/01/18 22:43:34 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: tcerror.h,v $
 * Revision 1.5  1995/01/18  22:43:34  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.4  1994/10/25  17:11:09  reids
 * Changed the logging functions to accept variable number of arguments.
 *
 * Revision 1.3  1994/05/17  23:18:25  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.2  1993/12/01  18:04:46  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.1  1993/08/31  06:02:25  fedor
 * Forgot to include tcerror.h in repository
 *
 * Revision 1.3  1993/08/23  17:41:08  rich
 * Fixed the type definitions for function pointers. Added const
 * declarations.  Removed definitions VOID_FN and INT_FN.
 *
 * Revision 1.2  1993/05/27  22:21:26  rich
 * Added automatic logging.
 *
 *****************************************************************************/

#ifndef INCtcerror
#define INCtcerror

/* These functions take a variable number of arguments, just like printf */
void tcaError(const char *Description, ...);
void tcaModError(const char *description, ...);
void tcaModWarning(const char *description, ...);

#endif /* INCtcerror */
