/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: tcaRef.c 
 *
 * ABSTRACT:
 * Implements TCA_REF_PTR
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/tcaRef.h,v $ 
 * $Revision: 1.4 $
 * $Date: 1995/04/19 14:29:13 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: tcaRef.h,v $
 * Revision 1.4  1995/04/19  14:29:13  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.3  1994/05/17  23:18:23  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.2  1993/12/01  18:04:43  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.1  1993/08/27  07:17:29  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.3  1993/08/23  17:41:01  rich
 * Fixed the type definitions for function pointers. Added const
 * declarations.  Removed definitions VOID_FN and INT_FN.
 *
 * Revision 1.2  1993/05/27  22:21:19  rich
 * Added automatic logging.
 *
 *****************************************************************************/

#ifndef INCtcaRef
#define INCtcaRef

void tcaRefInitialize(void);
TCA_REF_PTR tcaRefCreate(MSG_PTR msg, const char *name, int32 refId);
void tcaRefFree(TCA_REF_PTR tcaRef);

#endif /* INCtcaRef */
