/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: memory
 *
 * FILE: tcaMem.h
 *
 * ABSTRACT:
 * 
 * Interface to memory management routines.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/tcaMem.h,v $ 
 * $Revision: 1.11 $
 * $Date: 1995/07/10 16:18:58 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: tcaMem.h,v $
 * Revision 1.11  1995/07/10  16:18:58  rich
 * Interm save.
 *
 * Revision 1.10  1995/07/06  21:17:44  rich
 * Solaris and Linux changes.
 *
 * Revision 1.9  1995/06/14  03:22:50  rich
 * Added DBMALLOC_DIR.
 * More support for DOS.  Fixed some problems with direct connections.
 *
 * Revision 1.8  1995/05/31  19:37:10  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.7  1995/04/19  14:29:10  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.6  1995/03/28  01:15:10  rich
 * - Added ability to log data with direct connections.  Also fixed some
 * problems with global variables. It now uses broadcasts for watching variables.
 * - Added preliminary memory recovery routines to handle out of memory
 * conditions.  It currently purges items from resource queues.  Needs to
 * be tested.
 * - If the CENTRALHOST environment variable is not set, try the current
 * host.
 * - Fixed a problem with central registered messages that caused the parsed
 * formatters to be lost.
 * - Added const declarations where needed to the prototypes in tca.h.
 * - tcaGetConnections: Get the fd_set.  Needed for direct connections.
 * - Added tcaExecute and tcaExecuteWithConstraints.  Can "execute" a goal
 *   or command.
 * - tcaPreloadMessage: Preload the definition of a message from the
 *   central server.
 *
 * Revision 1.5  1994/05/17  23:18:15  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.4  1994/04/16  19:43:31  rich
 * First release of TCA for the DEC alpha.
 * Changes were needed because longs are 64 bits.
 * Fixed alignment assumption in the data message format.
 * Fixed the way offsets are calculated for variable length arrays.  This
 * was a problem even without 64 bit longs and pointers.
 *
 * Added the commit date to the version information printed out with the -v
 * option.
 *
 * Now uses standard defines for byte order
 * (BYTE_ORDER = BIG_ENDIAN, LITTLE_ENDIAN or PDP_ENDIAN)
 *
 * Defined alignment types: ALIGN_INT ALINE_LONGEST and ALIGN_WORD.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.3  1993/12/01  18:04:40  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.2  1993/11/21  20:19:56  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.1  1993/08/27  07:17:25  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/27  22:21:12  rich
 * Added automatic logging.
 *
 ****************************************************************/

#ifndef INCtcaMem
#define INCtcaMem

#if defined(DBMALLOC)
#define tcaMalloc(amount) tcaDBMalloc(__FILE__,__LINE__,(amount))
void *tcaDBMalloc(const char* file, int line, SIZETYPE amount);

void tcaFree(char *item);
void tcaDBFree(const char *file, int line, char *item);
#define tcaFree(item) tcaDBFree(__FILE__,__LINE__,(item))
#elif defined(__TURBOC__)
void *tcaMalloc(unsigned long amount);
void tcaFree(char *item);
#else
void *tcaMalloc(size_t amount);
void tcaFree(char *item);
#endif

void tcaStats(FILE *stream);

#endif /* INCtcaMem */
