/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * MODULE: matrix
 *
 * FILE: tcaMatrix.h
 *
 * ABSTRACT: Generalization of the matrix package: Implements a single
 *           "generic matrix" and methods for accessing elements of the 
 *           matrix, under the assumption that the elements have different
 *           sizes.
 *
 * REVISION HISTORY:
 *
 * $Log: tcaMatrix.h,v $
 * Revision 1.12  1995/05/31  19:37:06  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.11  1995/04/21  03:53:40  rich
 * Added central commands to kill the task tree and close a module.
 * Added tcaGetContext and tcaSetContext to support connections to multiple
 * central servers.  tcaConnectModules can be called multiple times.
 * Fixed a bug in the resource limit pending.
 * Created seperate routines to print help and option messages.
 *
 * Revision 1.10  1995/04/19  14:29:09  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.9  1995/04/07  05:03:37  rich
 * Fixed GNUmakefiles to find the release directory.
 * Cleaned up libc.h file for sgi and vxworks.  Moved all system includes
 * into libc.h
 * Got direct queries to work.
 * Fixed problem in allocating/initializing generic mats.
 * The direct flag (-c) now mostly works.  Connect message has been extended to
 * indicate when direct connections are the default.
 * Problem with failures on sunOS machines.
 * Fixed problem where tcaError would not print out its message if logging had
 * not been initialized.
 * Fixed another memory problem in modVar.c.
 * Fixed problems found in by sgi cc compiler.  Many type problems.
 *
 * Revision 1.8  1995/04/05  19:11:20  rich
 * Adding Reid's Changes.
 * Consolidating the matrix code.
 *
 * Revision 1.7  1995/01/18  22:43:23  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.6  1994/05/17  23:18:06  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.5  1994/04/28  16:17:43  reids
 * Changes in TCA Version 7.6:
 *  1) New functions: tcaIgnoreLogging and tcaResumeLogging
 *  2) Code for MacIntosh (MPW) version of TCA
 *
 * Revision 1.4  1993/12/01  18:04:38  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.3  1993/08/27  07:17:21  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:19:44  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:50  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:32:46  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:26:19  fedor
 * Added Logging.
 *
 * 17-Apr-90 Christopher Fedor at School of Computer Science, CMU
 * Added ucmat. Seems that the gil vision version of matrix.h is different.
 *
 *  3-Apr-90 Christopher Fedor at School of Computer Science, CMU
 * Created from matrix.h to avoid perception link conflicts.
 *
 * $Revision: 1.12 $
 * $Date: 1995/05/31 19:37:06 $
 * $Author: rich $
 *
 *****************************************************************************/

/* matrix.h -- define types for matrices using Iliffe vectors
 *************************************************************
 * HISTORY
 * 25-Nov-80  David Smith (drs) at Carnegie-Mellon University
 * Changed virtual base address name to "el" for all data
 * types (Previously vali, vald, ...)  This was possible due to the
 * compiler enhancement which keeps different structure declarations
 * separate.
 *
 * 30-Oct-80  David Smith (drs) at Carnegie-Mellon University
 *	Rewritten for record-style matrices
 *
 */

#ifndef INCtcaMatrix
#define INCtcaMatrix

typedef struct {
  int32	lb1, ub1, lb2, ub2;
  char	*mat_sto;
  char	**el;
}
genericMatrix;

typedef struct {
  int32	lb1, ub1, lb2, ub2;
  char	*mat_sto;
  unsigned char	**el;
}
ucmat;

typedef struct {
  int32	lb1, ub1, lb2, ub2;
  char	*mat_sto;
  char	**el;
}
cmat;

typedef struct {
  int32	lb1, ub1, lb2, ub2;
  char	*mat_sto;
  short	**el;
}
smat;

typedef struct {
  int32	lb1, ub1, lb2, ub2;
  char	*mat_sto;
  int32	**el;
}
imat;

typedef struct {
  int32	lb1, ub1, lb2, ub2;
  char	*mat_sto;
  long	**el;
}
lmat;

typedef struct {
  int32	lb1, ub1, lb2, ub2;
  char	*mat_sto;
  float	**el;
}
fmat;

typedef struct {
  int32	lb1, ub1, lb2, ub2;
  char	*mat_sto;
  double	**el;
}
dmat;

genericMatrix newmat(int32 elementSize,
		     int32 rs, int32 re, int32 cs, int32 ce, 
		     int32 *error);


ucmat newucmat2(int32 rs, int32 re, int32 cs, int32 ce, int32 *error);
cmat newcmat2(int32 rs, int32 re, int32 cs, int32 ce, int32 *error);
smat newsmat2(int32 rs, int32 re, int32 cs, int32 ce, int32 *error);
imat newimat2(int32 rs, int32 re, int32 cs, int32 ce, int32 *error);
lmat newlmat2(int32 rs, int32 re, int32 cs, int32 ce, int32 *error);
fmat newfmat2(int32 rs, int32 re, int32 cs, int32 ce, int32 *error);
dmat newdmat2(int32 rs, int32 re, int32 cs, int32 ce, int32 *error);

#if defined(THINK_C) || defined(applec)
#include <stdlib.h>
#endif
#define FREEMAT(m) {free((m).mat_sto); (m).mat_sto=NULL;}

/* Return the given element of a "genericMatrix" */
#define MATRIX_ELEMENT(matrix, row, col, elementSize) \
  ((matrix).el[row] + ((elementSize)*col))
#define MATRIX_FIRST_ELEMENT(matrix, elementSize) \
  MATRIX_ELEMENT(matrix, (matrix).lb1, (matrix).lb2, elementSize)

#endif /* INCtcaMatrix */
