/*
 * tcaModError.c
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons. All rights reserved.
 * 
 
 *
 * $Log: tcModError.c,v $
 * Revision 1.17  1996/06/25  20:51:42  rich
 * Fixed memory and other problems found with purify.
 *
 * Revision 1.16  1996/05/09  18:31:34  reids
 * Changes to keep TCA consistent with the NASA IPC package.
 * Some bug fixes (mainly to do with freeing formatters).
 *
 * Revision 1.15  1996/03/05  05:04:52  reids
 * Changes (mainly delineated by NMP_IPC conditionals) to support the
 *   New Millennium IPC.
 *
 * Revision 1.14  1996/01/05  16:31:39  rich
 * Added windows NT port.
 *
 * Revision 1.13  1995/06/14  03:22:33  rich
 * Added DBMALLOC_DIR.
 * More support for DOS.  Fixed some problems with direct connections.
 *
 * Revision 1.12  1995/04/09  20:30:13  rich
 * Added /usr/local/include and /usr/local/lib to the paths for compiling
 * for sunOS machines. (Support for new vendor OS).
 * Create a tca directory in /tmp and put the socket in there so others can
 * delete dead sockets.  The /tmp directory has the sticky bit set so you
 * can't delete files even if you have write permission on the directory.
 * Fixes to libc.h to use the new declarations in the gcc header files and
 * avoid problems with dbmalloc.
 *
 * Revision 1.11  1995/01/18  22:43:11  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.10  1994/11/02  21:34:42  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile.
 * Made libc.h and tcaMatrix.h module includes.
 * Reduced the size of libc.h by using more system includes.
 *
 * Revision 1.9  1994/10/25  17:10:57  reids
 * Changed the logging functions to accept variable number of arguments.
 *
 * Revision 1.8  1994/04/28  16:17:37  reids
 * Changes in TCA Version 7.6:
 *  1) New functions: tcaIgnoreLogging and tcaResumeLogging
 *  2) Code for MacIntosh (MPW) version of TCA
 *
 * Revision 1.7  1994/04/26  16:23:40  rich
 * Now you can register an exit handler before anything else and it will
 * get called if connecting to central fails.
 * Also added code to handle pipe breaks during writes.
 *
 * Revision 1.6  1994/04/16  19:43:22  rich
 * First release of TCA for the DEC alpha.
 * Changes were needed because longs are 64 bits.
 * Fixed alignment assumption in the data message format.
 * Fixed the way offsets are calculated for variable length arrays.  This
 * was a problem even without 64 bit longs and pointers.
 *
 * Added the commit date to the version information printed out with the -v
 * option.
 *
 * Now uses standard defines for byte order
 * (BYTE_ORDER = BIG_ENDIAN, LITTLE_ENDIAN or PDP_ENDIAN)
 *
 * Defined alignment types: ALIGN_INT ALINE_LONGEST and ALIGN_WORD.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.5  1993/12/14  17:35:27  rich
 * Changed getMGlobal to GET_M_GLOBAL and changed getSGlobal to
 * GET_S_GLOBAL to conform to Chris' software standards.
 *
 * Patched problem with connecting between machines with different byte
 * orders.  The real fix requires changing the way formats are stored.
 * Searching for structural similar formats does not guarantee that you
 * find the right format.
 *
 * Revision 1.4  1993/11/21  20:19:47  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.3  1993/08/27  07:17:12  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/06/13  23:28:33  rich
 * Made changes for lisp needed for vx works style global variables.
 * Fixed some random compiler warnings.
 * Moved test routines to test directory.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:39  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:32:38  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:26:09  fedor
 * Added Logging.
 *
 * $Revision: 1.17 $
 * $Date: 1996/06/25 20:51:42 $
 * $Author: rich $
 *
 *
 * 27-Oct-92 Richard Goodwin, School of Computer Science, CMU
 * Changed printf to fprintf(stderr... for warning messages.
 *
 * 25-Oct-90: fedor: created to avoid logging in modules.
 *****************************************************************/

#include "globalM.h"
#include <stdarg.h>

void tcaModWarning(const char *description, ...)
{
  if (description) {
    va_list args;
    va_start(args, description);
    vfprintf(stderr, (char *)description, args);
    va_end(args);
    FLUSH_IF_NEEDED(stderr);
  }
}  

void tcaModError(const char *description, ...)
{
#ifndef NMP_IPC
  tcaStats(stderr);
#endif
  
  if (description) {
    va_list args;
    va_start(args, description);
    vfprintf(stderr, (char *)description, args);
    fprintf(stderr, "\n");
    va_end(args);
    FLUSH_IF_NEEDED(stderr);
  }
  
  tcaClose();
  
#if defined(LISP)
  if (GET_M_GLOBAL(lispExitGlobal) != NULL)
    (*(GET_M_GLOBAL(lispExitGlobal)))();
#else
  if (GET_M_GLOBAL(tcaExitHnd)) {
    (*(GET_M_GLOBAL(tcaExitHnd)))();
  } else {
#ifdef _WINSOCK_
    WSACleanup();
    printf("Socket cleaned up.");
#endif /* Unload Winsock DLL */
    exit(-1);
  }
#endif
}
