/**************************************************************************
 * 
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *
 * MODULE: list
 *
 * FILE: list.h
 *
 * ABSTRACT: The list module provides basic list creation and manipulation
 * routines and serves as the base abstract data type for the tca.
 * The include file list.h provides the top level routines for other modules.
 *
 * EXPORTS:
 *
 * REVISION HISTORY:
 *
 * $Log: strList.h,v $
 * Revision 1.7  1996/02/10  16:50:33  rich
 * Fixed header problems and a crash related to direct connections.
 *
 * Revision 1.6  1996/01/23  00:06:42  rich
 * Fixed memory leak when a module connects and disconnects.  Also fixed a
 * problem with using the direct connection flag.  This was introduced when
 * we added contexts for keeping track of the central server.
 *
 * Revision 1.5  1995/12/17  20:22:15  rich
 * Have free routines set pointers to NULL.
 * Removed old makefiles.
 *
 * Revision 1.4  1995/10/07  19:07:48  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Added tcaWillListen.
 * Only transmit broadcast messages when there is a handler to receive them.
 * All system messages now start with "tca_".  Old messages are also supported.
 *
 * Revision 1.3  1995/07/12  04:55:32  rich
 * Release of 8.0.
 * Fixed problems with sending between machines of different endien.
 *
 * Revision 1.2  1995/04/04  19:43:04  rich
 * Added sgi support.
 * Split low level com routines out to be used in devUtils.
 * Improved some error messages.
 * Added central switch to default to direct connections.  Does not work yet.
 * Fixed the vectorization code.
 *
 * Revision 1.1  1995/03/30  15:44:09  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added simple list of strings data structure that can be passed via tca
 * messages.
 * Use the string list to maintain a global variable of messages with taps.
 * Tapped messages are not sent via direct connections.
 * Implemented code to vectorize data to be sent so that it does not have
 * to be copied.  Currently, only flat, packed data structures are
 * vectored.  This can now be easily extended.
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 * Fixed bug were central would try and free the "***New Module***" and
 * "*** Unkown Host***" strings when a module crashed on startup.
 * Fixed a bug reported by Jay Gowdy where the code to find the size of a
 * variable lenght array would access already freed data when called from
 * tcaFreeData.
 *
 * Revision 1.8  1995/01/18  22:41:06  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.7  1994/05/17  23:16:18  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.6  1993/12/01  18:03:49  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.5  1993/11/21  20:18:14  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.4  1993/08/27  08:38:46  fedor
 * Pass 2 aat a V7+V6+VxWorks merge. Many many problems with pointless casting.
 *
 * Revision 1.3  1993/08/27  07:15:26  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:18:01  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:45  rich
 * Importing tca version 8
 *
 * Revision 1.2  1993/05/19  17:24:26  fedor
 * Added Logging.
 *
 * See list.c for history.
 *
 * $Revision: 1.7 $
 * $Date: 1996/02/10 16:50:33 $
 * $Author: rich $
 *
 **************************************************************************/

#ifndef INCstrList
#define INCstrList

typedef struct _STR_LIST {
  char *item;
  struct _STR_LIST *next;
} STR_LIST_TYPE, *STR_LIST_PTR;

#define TCA_STR_LIST_FORMAT "{string,*!}"

void strListFree(STR_LIST_PTR *strList, BOOLEAN FreeStrings);

#if defined(DBMALLOC)
STR_LIST_PTR strListDBCreate(const char* file, int line);
#define strListCreate() strListDBCreate(__FILE__,__LINE__)
#else
STR_LIST_PTR strListCreate(void);
#endif

#if defined(DBMALLOC)
void strListDBPush(const char* file, int line,
		   const char *item, STR_LIST_PTR strList);
#define strListPush(item,list) strListDBPush(__FILE__,__LINE__,item,list)
#else
void strListPush(const char *item, STR_LIST_PTR strList);
#endif

#if defined(DBMALLOC)
void strListDBPushUnique(const char* file, int line,
			 const char *item, STR_LIST_PTR strList);
#define strListPushUnique(item,list) \
strListDBPushUnique(__FILE__,__LINE__,item,list)
#else
void strListPushUnique(const char *item, STR_LIST_PTR strList);
#endif

const char *strListPopItem(STR_LIST_PTR strList);

void strListRemoveItem(const char *item, STR_LIST_PTR strList);

BOOLEAN strListMemberItem(const char *item, STR_LIST_PTR strList);

int strListLength(STR_LIST_PTR strList);
int strListEmpty(STR_LIST_PTR strList);
int strListEqual(STR_LIST_PTR strList1, STR_LIST_PTR strList2);

STR_LIST_PTR strListMake1(const void *item);
STR_LIST_PTR strListMake2(const void *item1, const void *item2);

const char *strListFirst(STR_LIST_PTR strList);
const char *strListLast(STR_LIST_PTR strList);

int strListDeleteItem(const char *item, STR_LIST_PTR strList,
		      BOOLEAN freeString);

#endif /* INCstrList */
