
#include "globalS.h"

#include "tca.h"
#ifdef DOS_FILE_NAMES
#include "formatte.h"
#include "parseFmt.h"
#include "com.h"
#include "comModul.h"
#else
#include "formatters.h"
#include "parseFmttrs.h"
#include "com.h"
#include "comModule.h"
#endif

/*int bufferSize();*/
/*FORMAT_PTR ParseFormatString();*/
/*void formatInitialize();*/

static void testSize (int32 size, char *formatString)
{
  int32 formatSize;
  
  formatSize = dataStructureSize(ParseFormatString(formatString));
  if (size != formatSize) 
    printf("Sizes Differ\n  ");
  printf("Size of %s -- Structure: %d, Format: %d\n", 
	 formatString, size, formatSize);
  fflush(stdout);
}

void main(int32 argc, char **argv)
{
  
  tcaModuleInitialize();
  
  testSize(sizeof(int32), "int");
  testSize(sizeof(int16), "short");
  testSize(sizeof(long), "long");
  testSize(sizeof(char), "char");
  testSize(sizeof(float), "float");
  testSize(sizeof(double), "double");
  
  testSize(sizeof(struct{int32 a;char b;double c;}), "{int, char, double}");
  testSize(sizeof(struct{int32 a;double c;char b;}), "{int, double, char}");
  testSize(sizeof(struct{int32 a;char b;}), "{int, char}");
  testSize(sizeof(struct{char b; int32 a;}), "{char, int}");
  testSize(sizeof(struct{int32 a;struct{int32 a; char b;} b;double c;}),
	   "{int, {int, char}, double}");
  
  testSize(sizeof(struct{int32 a;char b;float c;}), "{int, char, float}");
  testSize(sizeof(struct{int32 a;float c;char b;}), "{int, float, char}");
  testSize(sizeof(struct{int32 a;struct{int a; char b;} b;float c;}),
	   "{int, {int, char}, float}");
  
  testSize(sizeof(struct{int32 a;char b;double c;}), "{int, char, double}");
  testSize(sizeof(struct{double a; char b;}), "{double, char}");
  testSize(sizeof(struct{int32 a;char b,d;double c;}),
	   "{int, char, char, double}");
  testSize(sizeof(struct{int32 a;char b,d,e;double c;}),
	   "{int, char, char, char, double}");
  
  testSize(sizeof(struct{int32 a;struct{int32 a; char b; double c;} b;float c;}),
	   "{int, {int, char, double}, float}");
  testSize(sizeof(struct{int32 a;struct{int32 a; char b,d; double c;} b;float c;}),
	   "{int, {int, char, char, double}, float}");
  testSize(sizeof(struct{int32 a;struct{int32 a; char b,d,e; double c;}
			 b;float c;}),
	   "{int, {int, char, char, char, double}, float}");
  
  testSize(sizeof(struct{char b;}), "{char}");  
  testSize(sizeof(struct{char b,c;}), "{char, char}");  
  testSize(sizeof(struct{char b,c,d;}), "{char, char, char}");  
  testSize(sizeof(struct{char b,c,d,e;}), "{char, char, char, char}");  
  testSize(sizeof(struct{char b,c,d,e,f;}),
	   "{char, char, char, char, char}");  
  testSize(sizeof(struct{char b,c,d,e,f,g;}),
	   "{char, char, char, char, char, char}");  
  testSize(sizeof(struct{int32 a;struct{char b;} b;float c;}),
	   "{int, {char}, float}");
  
  testSize(sizeof(int16), "short");
  testSize(sizeof(struct{int16 a;}), "{short}");
  testSize(sizeof(struct{short a,b;}), "{short, short}");
  testSize(sizeof(struct{int16 a,b,c;}), "{short, short, short}");
  testSize(sizeof(struct{int16 a,b,c; char d;}),
	   "{short, short, short, char}");
  
  testSize(sizeof(long), "long");
  testSize(sizeof(struct{long a;}), "{long}");
  testSize(sizeof(struct{long a,b;}), "{long, long}");
  testSize(sizeof(struct{long a,b,c;}), "{long, long, long}");
  testSize(sizeof(struct{long a,b,c; char d;}), "{long, long, long, char}");
  
  testSize(sizeof(struct{int16 a; struct{char a,b;} b; int16 c;}),
	   "{short, {char, char}, short}");
  testSize(sizeof(struct{int16 a; struct{char a,b;} b; float c;}),
	   "{short, {char, char}, float}");
  testSize(sizeof(struct{double a; struct{char a,b;} b; int16 c;}),
	   "{double, {char, char}, short}");
  testSize(sizeof(struct{double a; struct{char a,b;} b; int32 c;}),
	   "{double, {char, char}, int}");
  testSize(sizeof(struct{char a; struct{char a,b;} b; int16 c;}),
	   "{char, {char, char}, short}");
  testSize(sizeof(struct{char a; struct{char a,b,c,d,e;} b; int16 c;}),
	   "{char, {char, char, char, char, char}, short}");
  testSize(sizeof(struct{char a,d,e; struct{char a,b,c;} b; int16 c;}),
	   "{char, char, char, {char, char, char}, short}");
  testSize(sizeof(struct{char a; int16 b;}), "{char, short}");
  testSize(sizeof(struct{char a; struct{char a; int16 b;} b; int16 c;}),
	   "{char, {char, short}, short}");
  testSize(sizeof(struct{char a; 
			 struct{char a; int16 b; struct {int32 a;} c;} b;
			 int16 c;}),
	   "{char, {char, short, {int}}, short}");
  
  testSize(sizeof(struct{int32 a[5];}), "{[int:5]}");
  testSize(sizeof(struct{double a[5];}), "{[double:5]}");
  testSize(sizeof(struct{char a[5];}), "{[char:5]}");
  
  testSize(sizeof(struct{char b; int32 a;}), "{char, int}");
  testSize(sizeof(struct{char b,c; int32 a;}), "{char, char, int}");
  testSize(sizeof(struct{int32 a; char b,c;}), "{int, char, char}");
  testSize(sizeof(struct{double a; char b,c;}), "{double, char, char}");
  testSize(sizeof(struct{char b; struct{char c; int32 a;} c;}),
	   "{char, {char, int}}");
  testSize(sizeof(struct{char b; struct{char c; int32 a;} c; char d;}),
	   "{char, {char, int}, char}");
  testSize(sizeof(struct{struct {int32 a; char b;} a; char c;}), 
	   "{{int, char}, char}");
  testSize(sizeof(struct{struct {double a; char b;} a; char c;}), 
	   "{{double, char}, char}");
  
  /* added for alpha testing */
  testSize(sizeof(struct {
    int32 silly;
    float *x;
    float *y;
    int32 n;
  }), 
	   "{int, <float:4>, <float:4>, int}");
  
  testSize(sizeof(struct{
    int32 refCount;
    char *classData;
    char *msgData;
    int32 classTotal;
    int32 msgTotal;
    int32 parentRef;
    int32 intent;
    int32 classId;
    int32 dispatchRef;
    int32 msgRef;
  }),
	   "{int,*char,*char,int,int,int,int,int,int,int}");

  testSize(sizeof(enum { Ea0=0, Ea1=1}), "{enum Ea0, Ea1}");
  testSize(sizeof(enum { Eb0=0, Eb1000 = 1000}), "{enum : 1000}");
  testSize(sizeof(enum { Ec0=0, EcBig = 16777000}), "{enum : 16777000}");

  testSize(sizeof(struct{
    int32 i1;
    enum { Ed0=0, EdBig = 16777000} enumD;
    enum { Ee0=0, Ee1000 = 1000} enumE;
    enum { Ef0=0, Ef1=1} enumF;
  }),
	   "{int, {enum : 16777000}, {enum : 1000}, {enum Ef0, Ef1}}");
}
