/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: sendMsg
 *
 * FILE: sendMsg.h
 *
 * ABSTRACT:
 *
 * Send Message Include.
 *
 * REVISION HISTORY:
 *
 * $Log: sendMsg.h,v $
 * Revision 1.8  1995/05/31  19:36:49  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.7  1995/03/19  19:39:44  rich
 * Implemented direct connections using tcaDirectResouce call.
 * Also made the basics.h file a module include.
 * Changed class in the interval structure to be interval_class to avoid a
 * conflict with C++.
 *
 * Revision 1.6  1995/01/18  22:42:54  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.5  1994/05/17  23:17:46  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.4  1993/12/01  18:04:28  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.3  1993/08/27  07:17:02  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:19:16  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:49  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:32:22  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:25:49  fedor
 * Added Logging.
 *
 *  6-Aug-90 Christopher Fedor, School of Computer Science, CMU
 * created.
 *
 * $Revision: 1.8 $
 * $Date: 1995/05/31 19:36:49 $
 * $Author: rich $
 *
 *****************************************************************************/

#ifndef INCsendMsg
#define INCsendMsg

void msgInfoMsgInitialize(void);
int32 nextSendMessageRef(void);
TCA_RETURN_VALUE_TYPE sendMessage(TCA_REF_PTR ref, MSG_PTR msg,
				  void *msgData, void *classData);
TCA_RETURN_VALUE_TYPE sendResponse(TCA_REF_PTR ref, MSG_PTR msg,
				   void *resData,
				   TCA_MSG_CLASS_TYPE resClass,
				   void *resClassData,
				   int sd);
void classModInitialize(void);

#endif /* INCsendMsg */
