/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: resources
 *
 * FILE: resMod.h
 *
 * ABSTRACT:
 * 
 * Resources - Module Routines.
 *
 * REVISION HISTORY
 *
 * $Log: resMod.h,v $
 * Revision 1.6  1995/05/31  19:36:37  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.5  1994/05/25  17:32:39  reids
 * Added utilities to limit the number of pending messages
 *
 * Revision 1.4  1994/05/17  23:17:31  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.3  1993/11/21  20:19:27  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.2  1993/05/26  23:19:06  rich
 * Fixed up the comments at the top of the file.
 *
 * 26-Aug-90 Christopher Fedor, School of Computer Science, CMU
 * New implmentation of resources - tca version 5.0.
 *
 * 13-Mar-89 Christopher Fedor, School of Computer Science, CMU
 * created.
 *
 * $Revision: 1.6 $
 * $Date: 1995/05/31 19:36:37 $
 * $Author: rich $
 *
 *****************************************************************************/

#ifndef INCresMod
#define INCresMod

typedef struct {
  const char *hndName;
  const char *resName;
} ADD_HND_FORM_TYPE, *ADD_HND_FORM_PTR;

typedef struct {
  int32 capacity;
  const char *resName;
} ADD_RES_FORM_TYPE, *ADD_RES_FORM_PTR;

typedef struct {
  const char *msgName;
  const char *resName;
  int32 limit;
} LIMIT_PENDING_TYPE, *LIMIT_PENDING_PTR;

#endif /* INCresMod */
