/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: registration
 *
 * FILE: reg.c
 *
 * ABSTRACT:
 * 
 * Register messages and handlers
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/reg.h,v $ 
 * $Revision: 1.8 $
 * $Date: 1996/06/25 20:51:30 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: reg.h,v $
 * Revision 1.8  1996/06/25  20:51:30  rich
 * Fixed memory and other problems found with purify.
 *
 * Revision 1.7  1995/12/17  20:22:03  rich
 * Have free routines set pointers to NULL.
 * Removed old makefiles.
 *
 * Revision 1.6  1995/07/06  21:17:16  rich
 * Solaris and Linux changes.
 *
 * Revision 1.5  1995/05/31  19:36:29  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.4  1995/01/18  22:42:27  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.3  1994/05/17  23:17:21  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.2  1993/12/01  18:04:22  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.1  1993/08/27  07:16:38  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.4  1993/08/23  17:40:16  rich
 * Fixed the type definitions for function pointers. Added const
 * declarations.  Removed definitions VOID_FN and INT_FN.
 *
 * Revision 1.3  1993/07/05  18:11:26  reids
 * Added tcaDeregisterHandler function
 *
 * Revision 1.2  1993/05/27  22:20:12  rich
 * Added automatic logging.
 *
 *
 ****************************************************************/

#ifndef INCreg
#define INCreg

MSG_PTR msgCreate(MSG_DATA_PTR msgData);
void msgFree(char *name, MSG_PTR msg);
void hndFree(HND_KEY_PTR key, HND_PTR hnd);

MSG_PTR findOrRegisterMessage(const char *name);
HND_PTR selfRegisterHnd(int sd, MODULE_PTR hndOrg,
			HND_DATA_PTR hndData, TCA_HND_FN hndProc);
void hndDelete(HND_PTR hnd);
int32 deregisterHnd(int sd, HND_DATA_PTR hndData);

#endif /* INCreg */
