/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT:
 The abstractions defined are QUEUE, STACK, PRIORITY_QUEUE and MEMORY.
 Each abstraction `X' supports the functions CREATE_X, FREE_X, 
 CLEAR_X, and IS_X_EMPTY.
 
 QUEUE additionally supports ENQUEUE and DEQUEUE, and it supports
 HEAD_ENQUEUE for getting items in a LIFO manner.
 
 STACK additionally supports PUSH_STACK and POP_STACK.
 
 PRIORITY_QUEUE supports PRIORITY_ENQUEUE and PRIORITY_DEQUEUE.
 
 MEMORY supports REMEMBER and DO_MEMORY (which applys a function to each
 `remembered' item in a last in, first out manner).
 
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/queue.h,v $ 
 * $Revision: 1.9 $
 * $Date: 1995/12/17 20:22:00 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: queue.h,v $
 * Revision 1.9  1995/12/17  20:22:00  rich
 * Have free routines set pointers to NULL.
 * Removed old makefiles.
 *
 * Revision 1.8  1995/07/06  21:17:06  rich
 * Solaris and Linux changes.
 *
 * Revision 1.7  1995/05/31  19:36:17  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.6  1995/03/30  15:43:55  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added simple list of strings data structure that can be passed via tca
 * messages.
 * Use the string list to maintain a global variable of messages with taps.
 * Tapped messages are not sent via direct connections.
 * Implemented code to vectorize data to be sent so that it does not have
 * to be copied.  Currently, only flat, packed data structures are
 * vectored.  This can now be easily extended.
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 * Fixed bug were central would try and free the "***New Module***" and
 * "*** Unkown Host***" strings when a module crashed on startup.
 * Fixed a bug reported by Jay Gowdy where the code to find the size of a
 * variable lenght array would access already freed data when called from
 * tcaFreeData.
 *
 * Revision 1.5  1995/01/18  22:42:16  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.4  1993/12/01  18:04:18  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.3  1993/08/27  07:16:28  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.3  1993/08/23  17:40:03  rich
 * Fixed the type definitions for function pointers. Added const
 * declarations.  Removed definitions VOID_FN and INT_FN.
 *
 * Revision 1.2  1993/05/27  22:20:01  rich
 * Added automatic logging.
 *
 29-Jul-91 Reid Simmons   Rewrote entirely to use Chris' list package.
 *****************************************************************************/

#ifndef QUEUE_H
#define QUEUE_H

typedef struct { 
  struct _LIST *list;
} queue_type, *queue_ptr;

queue_ptr Create_Queue(void);
void Clear_Queue(queue_ptr queue);
void Enqueue(const void *data, queue_ptr queue);
const void *Dequeue(queue_ptr queue);
void Head_Enqueue(const void *data, queue_ptr queue);

/*                STACKS                */

typedef struct {
  struct _LIST *list;
} stack_type, *stack_ptr;

stack_ptr Create_Stack(void);
void Push_Stack(const void *data, stack_ptr stack);
const void *Pop_Stack(stack_ptr stack);

/*                PRIORITY_QUEUES                */

typedef struct { 
  struct _LIST *list;
  BOOLEAN (* valueLesspFn)(const char *, const char *);
} priority_queue_type, *priority_queue_ptr;

/*                MEMORIES                */

typedef struct { 
  struct _LIST *list;
} memory_type, *memory_ptr;

typedef void 
(* DO_MEMORY_FN)(const void *);

memory_ptr Create_Memory(void);
void Clear_Memory(memory_ptr memory);
void Remember(const void *data, memory_ptr memory);
void Do_Memory(memory_ptr memory, DO_MEMORY_FN memoryFn);

void Free_Memory(memory_ptr *memory);
void Free_Stack(stack_ptr *stack);
void Free_Queue(queue_ptr *queue);

#endif /* QUEUE_H */
