/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: print data
 *
 * FILE: printData.h
 *
 * ABSTRACT:
 * 
 * Print Data Interface Routines - central server only.
 *
 * REVISION HISTORY
 *
 * $Log: printData.h,v $
 * Revision 1.12  1996/05/09  18:31:33  reids
 * Changes to keep TCA consistent with the NASA IPC package.
 * Some bug fixes (mainly to do with freeing formatters).
 *
 * Revision 1.11  1995/07/10  16:18:26  rich
 * Interm save.
 *
 * Revision 1.10  1995/05/31  19:36:12  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.9  1995/04/19  14:28:45  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.8  1995/04/05  19:11:12  rich
 * Adding Reid's Changes.
 * Consolidating the matrix code.
 *
 * Revision 1.7  1995/01/18  22:42:01  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.6  1994/05/17  23:17:08  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.5  1993/12/01  18:04:07  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.4  1993/11/21  20:19:01  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.3  1993/08/27  07:16:14  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:18:36  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:46  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:31:38  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:25:03  fedor
 * Added Logging.
 *
 * 28-Oct-90 Christopher Fedor, School of Computer Science, CMU
 * (slightly) revised to standards.
 *
 * 24-Jul-89 Reid Simmons, School of Computer Science, CMU
 * created.
 *
 * $Revision: 1.12 $
 * $Date: 1996/05/09 18:31:33 $
 * $Author: reids $
 *
 *****************************************************************************/

#ifndef INCprintData
#define INCprintData

/*
 * Number of characters to keep on a line following the beginning of a
 * structured formatter. 10 was choosen arbitrarily. Might not always
 * work
 */
#define DEFAULT_KEEP 10   

#define LINE_LENGTH  80  /* Number of characters per line. */
#define PRINT_LENGTH  5  /* Maximum number of lines printed. */
#define DEC_PLACES    2  /* Number of decimal places for floats and doubles. */

void printString(FILE *stream, const char *pString, int32 keepWithNext);
void printInt(FILE *stream, const int32 *intPtr, int32 keepWithNext);
void printBoolean(FILE *stream, const int32 *intPtr, int32 keepWithNext);
void printChar(FILE *stream, const char *charPtr, int32 keepWithNext);
void printShort(FILE *stream, const int16 *shortPtr, int32 keepWithNext);
void printLong(FILE *stream, const long *longPtr, int32 keepWithNext);
void printFloat(FILE *stream, const float *floatPtr, int32 keepWithNext);
void printDouble(FILE *stream, const double *doublePtr,
		 int32 keepWithNext);
void printByte(FILE *stream, const char *bytePtr, int32 keepWithNext);
void printUByte(FILE *stream, const char *bytePtr, int32 keepWithNext);
void printTwoByte(FILE *stream, const char *twoBytePtr,
		  int32 keepWithNext);

void Print_Formatted_Data(FILE *stream, CONST_FORMAT_PTR format, 
			  const void *dataPtr);
void Print_Data(const char *formatString, const void *dataPtr);
void Print_Formatter(FILE *stream, CONST_FORMAT_PTR format);

void dPrintSTR(FILE *stream, const char *pString, int32 next);
void dPrintFORMAT(FILE *stream, CONST_FORMAT_PTR format, int32 next);
#ifndef NMP_IPC
void mapPrint(FILE *stream, const genericMatrix *map, CONST_FORMAT_PTR format,
	      int32 keepWithNext, const void *mapElements);
#endif
void dPrintTCA(FILE *stream, const TCA_REF_TYPE *ref, int32 next);

#endif /* INCprintData */
