/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: monitors
 *
 * FILE: monMod.h
 *
 * ABSTRACT:
 *
 * Monitors Module Side
 *
 * REVISION HISTORY:
 *
 * $Log: monMod.h,v $
 * Revision 1.5  1995/05/31  19:36:00  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.4  1994/05/17  23:16:46  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.3  1993/11/21  20:18:37  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.2  1993/05/26  23:18:16  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:46  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:31:11  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:24:42  fedor
 * Added Logging.
 *
 *  3-Oct-90 Christopher Fedor, School of Computer Science, CMU
 * created.
 *
 * $Revision: 1.5 $
 * $Date: 1995/05/31 19:36:00 $
 * $Author: rich $
 *
 *****************************************************************************/

#ifndef INCmonMod
#define INCmonMod

typedef struct {
  TCA_MSG_CLASS_TYPE msg_class;
  const char *monitorName, *conditionName, *actionName, *setUpName;
} MON_REG_DATA_TYPE, *MON_REG_DATA_PTR;

typedef struct {
  TCA_TIME_POINT_TYPE start, expire;
  INTERVAL_MONITOR_OPTIONS_PTR options;
} INTERVAL_MON_CLASS_TYPE, *INTERVAL_MON_CLASS_PTR;

#endif /* INCmonMod */
