/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: monitors
 *
 * FILE: mon.h
 *
 * ABSTRACT:
 *
 * Monitors
 *
 * REVISION HISTORY:
 *
 * $Log: mon.h,v $
 * Revision 1.10  1996/06/30  20:17:50  reids
 * Handling of polling monitors was severely broken.
 *
 * Revision 1.9  1995/08/06  16:44:04  reids
 * A bug existed in that two demon monitors that sent the same ID number
 * would conflict (causing the wrong one to fire).  This has been fixed, and
 * in the process, one of the hash-key functions was made a bit more general.
 *
 * Revision 1.8  1995/04/19  14:28:24  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.7  1995/01/18  22:41:22  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.6  1994/05/17  23:16:41  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.5  1993/12/01  18:04:02  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.4  1993/08/30  21:53:52  fedor
 * V7+V6+VXWORKS Everything compiles but there are initialization problems.
 *
 * Revision 1.3  1993/08/27  07:15:38  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:18:12  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:45  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:31:07  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:24:38  fedor
 * Added Logging.
 *
 * 19-Mar-91 Christopher Fedor, School of Computer Science, CMU
 * Replaced fireEveryCounter with condSatifiedCounter to be more explicit.
 *
 *  6-Aug-90 Christopher Fedor, School of Computer Science, CMU
 * created.
 *
 * $Revision: 1.10 $
 * $Date: 1996/06/30 20:17:50 $
 * $Author: reids $
 *
 *****************************************************************************/

#ifndef INCmon
#define INCmon

#include "monMod.h" /* can this be rewritten to remove this? */

typedef INT_STR_KEY_TYPE DEMON_MON_KEY_TYPE, *DEMON_MON_KEY_PTR;

typedef struct {
  int32 *id;
  unsigned long fireTime;
  int32 maxFireCounter;
  int32 condSatisfiedCounter;
  DISPATCH_PTR dispatch;
  MON_REG_DATA_PTR monInfo;
  QUANTITY_PTR expirationTime;
  INTERVAL_MON_CLASS_PTR intMonOps;
  struct _DURABLE_ITEM *durableItem;
} INTERVAL_MONITOR_DATA_TYPE, *INTERVAL_MONITOR_DATA_PTR;

typedef struct _DURABLE_ITEM {
  unsigned long endTime;
  DISPATCH_PTR dispatch;
  INTERVAL_MONITOR_DATA_PTR intMon;
} DURABLE_ITEM_TYPE, *DURABLE_ITEM_PTR;

#define NO_KEY -1
#define ALREADY_FIRED -1
#define ALREADY_CANCELLED -2

void monitorPoll(void);
void setIntervalMonitorStartTime (DISPATCH_PTR dispatch, 
				  INTERVAL_MON_CLASS_PTR intMonOps);
void cancelIfAttendingIntervalMonitor(DISPATCH_PTR dispatch);
void fireDemonHnd(DISPATCH_PTR dispatch, int32 *id);
void parseMonitorMsg(MSG_PTR msg);
void monitorInitialize(void);

#endif /* INCmon */
