/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: communications
 *
 * FILE: globalVar.c
 *
 * ABSTRACT:
 * 
 * Provides a system global variables.
 *
 * REVISION HISTORY
 *
 * $Log: modVar.h,v $
 * Revision 1.2  1995/03/28  01:14:48  rich
 * - Added ability to log data with direct connections.  Also fixed some
 * problems with global variables. It now uses broadcasts for watching variables.
 * - Added preliminary memory recovery routines to handle out of memory
 * conditions.  It currently purges items from resource queues.  Needs to
 * be tested.
 * - If the CENTRALHOST environment variable is not set, try the current
 * host.
 * - Fixed a problem with central registered messages that caused the parsed
 * formatters to be lost.
 * - Added const declarations where needed to the prototypes in tca.h.
 * - tcaGetConnections: Get the fd_set.  Needed for direct connections.
 * - Added tcaExecute and tcaExecuteWithConstraints.  Can "execute" a goal
 *   or command.
 * - tcaPreloadMessage: Preload the definition of a message from the
 *   central server.
 *
 * Revision 1.1  1994/05/17  23:16:34  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 *
 * $Revision: 1.2 $
 * $Date: 1995/03/28 01:14:48 $
 * $Author: rich $
 *
 *****************************************************************************/


#ifndef INCmodVar
#define INCmodVar

#define VAR_SET_PREFIX      "V_set_"
#define VAR_GET_PREFIX      "V_get_"
#define VAR_GET_SET_PREFIX  "V_get_set_"
#define VAR_WATCH_PREFIX    "V_watch_"

typedef struct _varMsg {
  const char *varName;
  const char *format;
  void *value;
} VAR_REG_TYPE, *VAR_REG_PTR;

void modVarInitialize(void);

#endif /* INCmodVar */
