/*****************************************************************************
 * 
 * PROJECT: Task Control Architecture.
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: logging
 *
 * FILE: modLogging.h
 *
 * ABSTRACT:
 * External declarations for message and status logging facilities.
 *
 * REVISION HISTORY
 *
 * $Log: modLogging.h,v $
 * Revision 1.2  1995/03/30  15:43:29  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added simple list of strings data structure that can be passed via tca
 * messages.
 * Use the string list to maintain a global variable of messages with taps.
 * Tapped messages are not sent via direct connections.
 * Implemented code to vectorize data to be sent so that it does not have
 * to be copied.  Currently, only flat, packed data structures are
 * vectored.  This can now be easily extended.
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 * Fixed bug were central would try and free the "***New Module***" and
 * "*** Unkown Host***" strings when a module crashed on startup.
 * Fixed a bug reported by Jay Gowdy where the code to find the size of a
 * variable lenght array would access already freed data when called from
 * tcaFreeData.
 *
 * Revision 1.1  1995/03/28  01:22:35  rich
 * Moved some logging functions to a seperate file so they can be used by
 * modules to determine if logging is active.
 *
 *
 * $Revision: 1.2 $
 * $Date: 1995/03/30 15:43:29 $
 * $Author: rich $
 *
 *****************************************************************************/

#ifndef INCmodLogging
#define INCmodLogging

int LogMessagesP(void);
int LogDataP(void);
int LogIgnoreP(void);

#endif /* INCmodLogging */
