/*****************************************************************************
 * 
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: Logging
 *
 * FILE: modLogging.c
 *
 * ABSTRACT:
 * Facilities for logging TCA data on the terminal or in a log file.
 *
 * REVISION HISTORY
 *
 * $Log: modLogging.c,v $
 * Revision 1.2  1996/07/12  13:54:49  reids
 * Fixed the logic of "ignore logging".
 *
 * Revision 1.1  1995/03/28  01:22:33  rich
 * Moved some logging functions to a seperate file so they can be used by
 * modules to determine if logging is active.
 *
 *
 * $Revision: 1.2 $
 * $Date: 1996/07/12 13:54:49 $
 * $Author: reids $
 *
 *****************************************************************************/

#include "globalM.h"

int LogMessagesP(void)
{
  LOG_PTR *log = GET_M_GLOBAL(logList);
  
  for(; (((*log) != NULL) && ((*log)->theFile != NULL)); log++) {
    if ((*log)->messages)
      return(TRUE);
  }
  return(FALSE);
}

/* Return TRUE if data logging is turned on for *at least* one of the files */
int LogDataP(void)
{
  LOG_PTR *log = GET_M_GLOBAL(logList);
  
  for(; (((*log) != NULL) && ((*log)->theFile != NULL)); log++) {
    if ((*log)->data)
      return(TRUE);
  }
  return(FALSE);
}

/* Return TRUE if *some* log-file is ignoring messages */
int LogIgnoreP(void)
{
  LOG_PTR *log = GET_M_GLOBAL(logList);
  
  for(; (((*log) != NULL) && ((*log)->theFile != NULL)); log++) {
    if ((*log)->ignore)
      return(TRUE);
  }
  return(FALSE);
}
