/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE:
 *
 * FILE:
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/libc.h,v $ 
 * $Revision: 1.50 $
 * $Date: 1996/08/05 16:06:58 $
 * $Author: rich $
 *
 * REVISION HISTORY
 * $Log: libc.h,v $
 * Revision 1.50  1996/08/05  16:06:58  rich
 * Added comments to endifs.
 *
 * Revision 1.49  1996/07/23  19:32:28  reids
 * Changes to support Windows 95.
 *
 * Revision 1.48  1996/06/20  15:46:37  rich
 * Small changes for new os versions for linux and OSF1.
 *
 * Revision 1.47  1996/05/15  02:25:54  rich
 * Lisp does not mean sparc now.
 *
 * Revision 1.46  1996/05/09  18:31:07  reids
 * Changes to keep TCA consistent with the NASA IPC package.
 * Some bug fixes (mainly to do with freeing formatters).
 *
 * Revision 1.45  1996/05/07  16:49:37  rich
 * Changes for clisp.
 *
 * Revision 1.44  1996/04/04  18:18:08  rich
 * Fixed problems found by the SGI compiler.
 *
 * Revision 1.43  1996/02/14  22:12:33  rich
 * Eliminate extra variable logging on startup.
 *
 * Revision 1.42  1996/02/14  03:43:23  rich
 * Added setpgrp for sunos.
 *
 * Revision 1.41  1996/02/13  21:29:01  rich
 * Added environment for linux.
 *
 * Revision 1.40  1996/02/10  16:50:03  rich
 * Fixed header problems and a crash related to direct connections.
 *
 * Revision 1.39  1996/02/06  19:04:54  rich
 * Changes for VXWORKS pipes.  Note: the read and write sockets descriptors
 * can be different.
 *
 * Revision 1.38  1996/01/30  15:04:27  rich
 * Fixed var array index problem.  Index refers to the enclosing structure.
 * Added ability to force 32 bit enums and changed some #defs to enums to
 * ease debugging.  Fixed initialization problems for central.
 *
 * Revision 1.37  1996/01/05  16:31:29  rich
 * Added windows NT port.
 *
 * Revision 1.36  1995/12/17  20:21:32  rich
 * Have free routines set pointers to NULL.
 * Removed old makefiles.
 *
 * Revision 1.35  1995/07/25  20:09:08  rich
 * Changes for NeXT machine (3.0).
 *
 * Revision 1.34  1995/07/10  16:17:39  rich
 * Interm save.
 *
 * Revision 1.33  1995/07/08  18:24:47  rich
 * Change all /afs/cs to /afs/cs.cmu.edu to get ride of conflict problems.
 *
 * Revision 1.32  1995/07/08  17:51:09  rich
 * Linux Changes.  Also added GNUmakefile.defs.
 *
 * Revision 1.31  1995/07/06  21:16:41  rich
 * Solaris and Linux changes.
 *
 * Revision 1.30  1995/06/14  17:51:00  rich
 * Fixes for Linux 1.2.
 *
 * Revision 1.29  1995/06/05  23:59:03  rich
 * Improve support of detecting broken pipes.  Add support for OSF 2.
 * Add return types to the global variable routines.
 *
 * Revision 1.28  1995/05/31  19:35:49  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.27  1995/04/17  16:33:37  rich
 * Adding lisp as a subdirectory so it gets included in the tar file.
 *
 * Revision 1.26  1995/04/09  20:30:10  rich
 * Added /usr/local/include and /usr/local/lib to the paths for compiling
 * for sunOS machines. (Support for new vendor OS).
 * Create a tca directory in /tmp and put the socket in there so others can
 * delete dead sockets.  The /tmp directory has the sticky bit set so you
 * can't delete files even if you have write permission on the directory.
 * Fixes to libc.h to use the new declarations in the gcc header files and
 * avoid problems with dbmalloc.
 *
 * Revision 1.25  1995/04/08  02:06:24  rich
 * Added waitForReplyFrom to be able to block on replies from only one
 * source.  Useful when querying for the msg info information.  Added a
 * tcaQueryCentral that only accepts input from the central server.  Fixed
 * timing problems with direct connections.
 *
 * Revision 1.24  1995/04/07  05:03:19  rich
 * Fixed GNUmakefiles to find the release directory.
 * Cleaned up libc.h file for sgi and vxworks.  Moved all system includes
 * into libc.h
 * Got direct queries to work.
 * Fixed problem in allocating/initializing generic mats.
 * The direct flag (-c) now mostly works.  Connect message has been extended to
 * indicate when direct connections are the default.
 * Problem with failures on sunOS machines.
 * Fixed problem where tcaError would not print out its message if logging had
 * not been initialized.
 * Fixed another memory problem in modVar.c.
 * Fixed problems found in by sgi cc compiler.  Many type problems.
 *
 * Revision 1.23  1995/04/04  19:42:27  rich
 * Added sgi support.
 * Split low level com routines out to be used in devUtils.
 * Improved some error messages.
 * Added central switch to default to direct connections.  Does not work yet.
 * Fixed the vectorization code.
 *
 * Revision 1.22  1995/03/19  19:39:34  rich
 * Implemented direct connections using tcaDirectResouce call.
 * Also made the basics.h file a module include.
 * Changed class in the interval structure to be interval_class to avoid a
 * conflict with C++.
 *
 * Revision 1.21  1995/03/16  18:05:28  rich
 * Merged in changes to the 7.9 branch.
 * Changed the VERSION_ to TCA_VERSION_
 *
 * Revision 1.20  1995/01/30  16:18:06  rich
 * Added indications of message byte order and alignment to the message
 * header in the upper two bytes of the classID.
 * Now the receiver translates the byte order but must receive data in
 * "PACKED" alignment.
 * Made -gstabs come after -g for i386_mach machines so the debugger will work.
 *
 * Revision 1.19  1995/01/25  00:01:20  rich
 * Release of tca 7.9.  Mostly speed improvements.
 * The cvs binaries may now be located in /usr/local.
 * Fixed problems with little endian translation.
 *
 * Revision 1.18  1995/01/18  22:41:00  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.17  1994/11/08  05:14:39  rich
 * Change for sun4_mach.
 *
 * Revision 1.16  1994/11/03  06:48:08  rich
 * Fixed some problems with MACH machines.
 *
 * Revision 1.15  1994/11/02  21:34:25  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile.
 * Made libc.h and tcaMatrix.h module includes.
 * Reduced the size of libc.h by using more system includes.
 *
 * Revision 1.14  1994/06/07  02:30:26  rich
 * Include the top level README and other files in the tarfile.
 * Include extra header infomation to get rid of warnings.
 *
 * Revision 1.13  1994/05/18  02:30:07  rich
 * Accidently flipped the conditions on the include #ifdef.
 *
 * Revision 1.12  1994/05/17  23:16:15  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.11  1994/05/06  07:12:11  rich
 * Fixed makefile so it includes centralIO.[hc].
 * Updated INSTALL for systems without gunzip and gmake.
 *
 * Revision 1.10  1994/05/05  00:46:20  rich
 * Added a gmake makefile GNUmakefile so that the system can be easily
 * compiled on different machines.
 * Can now create the targets: tarfile and ftp for creating versions for
 * export.
 *
 * Fixed a number of places were tcaExitHnd was not expected to return.
 * Set the tcaSeverGlobal to 0 when the socket is closed.
 *
 * Revision 1.9  1994/04/28  16:16:15  reids
 * Changes in TCA Version 7.6:
 *  1) New functions: tcaIgnoreLogging and tcaResumeLogging
 *  2) Code for MacIntosh (MPW) version of TCA
 *
 * Revision 1.8  1994/04/16  19:42:26  rich
 * First release of TCA for the DEC alpha.
 * Changes were needed because longs are 64 bits.
 * Fixed alignment assumption in the data message format.
 * Fixed the way offsets are calculated for variable length arrays.  This
 * was a problem even without 64 bit longs and pointers.
 *
 * Added the commit date to the version information printed out with the -v
 * option.
 *
 * Now uses standard defines for byte order
 * (BYTE_ORDER = BIG_ENDIAN, LITTLE_ENDIAN or PDP_ENDIAN)
 *
 * Defined alignment types: ALIGN_INT ALINE_LONGEST and ALIGN_WORD.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.7  1994/04/04  16:01:18  reids
 * Fixed the way data transfer occurred from/to big and little Endian machines
 *
 * Revision 1.6  1994/03/28  02:22:58  rich
 * parseFmttrs needs to be in the server objects and not the module objects.
 *
 * Revision 1.5  1994/03/27  22:50:32  rich
 * Fixed problem with lisp version not working because of some compiler
 * flags used for the shared library version.
 * TCA now compiles for alphas, but does not run.
 *
 * Revision 1.4  1994/01/31  18:28:00  reids
 * Several major changes (and some minor ones)
 * 1. tcaFreeData and tcaFreeReply now work even if the data or message format
 *    is NULL
 * 2. Using the "-t" option in central, message taps are added as a child of
 *    the task tree node that was tapped.
 * 3. Named formatters are now expanded only when needed
 * For more details, see ../doc/tca-7-4.release.notes
 *
 * Revision 1.3  1993/11/21  20:18:09  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.2  1993/10/21  03:55:55  rich
 * Removed junk from libc.h
 *
 * Revision 1.1  1993/08/27  07:15:21  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.5  1993/08/23  17:38:47  rich
 * Fixed the type definitions for function pointers. Added const
 * declarations.  Removed definitions VOID_FN and INT_FN.
 *
 * Revision 1.4  1993/07/08  05:38:40  rich
 * Added function prototypes
 *
 * Revision 1.3  1993/06/22  13:59:19  rich
 * Added makefile.depend.  Dependencies automatically generated using gcc.
 * Fixed some warnings.
 * Updated the -D<arch> flags to correspond to those generated
 * automatically by the makefile.
 * Changed system includes to the proper format "stdio.h" -> <stdio.h>.
 * This was needed so that the automatic dependency generation can
 * distinguish between "local" and system headers.  The location of the
 * system headers changes from architecture to architecture and should not
 * be included in the dependency list.
 *
 * Revision 1.2  1993/05/27  22:17:50  rich
 * Added automatic logging.
 *
 * Revision 1.1.1.1  1993/05/20  05:42:28  rich
 * Importing tca version 7
 *
 * Revision 1.2  1993/02/19  21:41:04  rich
 * RTG - fixed libc.h for pmax
 *
 * Revision 1.1  1993/02/19  20:16:26  rich
 * RTG - forgot libc.h
 *
 * Revision 1.7  89/04/03  11:10:45  vanryzin
 * 	Changed definition of qsort for c++ to indicate the procedure
 * 	passed to qsort has parameters.  Since we were unsure if ANSI C
 * 	could handle the syntax I placed the new definition within #if
 * 	defined(c_plusplus) conditionals.  This may not be necessary
 * 	and perhaps should be fixed at a later time.
 * 	[89/04/03            vanryzin]
 * 
 * Revision 1.6  89/02/05  15:55:57  gm0w
 * 	Added extern char *errmsg().
 * 	[89/02/04            gm0w]
 * 
 * Revision 1.5  89/01/20  15:34:40  gm0w
 * 	Moved all of the STDC changes to other existing include files
 * 	back into this one.  Added non-STDC extern declarations for
 * 	all functions without int return values to match those defined
 * 	by STDC.  Added include of sysent.h.  Removed obsolete cdate
 * 	extern declaration.
 * 	[88/12/17            gm0w]
 * 
 * Revision 1.4  88/12/22  16:58:56  mja
 * 	Correct __STDC__ parameter type for getenv().
 * 	[88/12/20            dld]
 * 
 * Revision 1.3  88/12/14  23:31:42  mja
 * 	Made file reentrant.  Added declarations for __STDC__.
 * 	[88/01/06            jjk]
 * 
 * 30-Apr-88  Glenn Marcy (gm0w) at Carnegie-Mellon University
 *	Added pathof() extern.
 *
 * 01-Dec-85  Glenn Marcy (gm0w) at Carnegie-Mellon University
 *	Added getname() extern.
 *
 * 29-Nov-85  Glenn Marcy (gm0w) at Carnegie-Mellon University
 *	Added lseek() extern.
 *
 * 02-Nov-85  Glenn Marcy (gm0w) at Carnegie-Mellon University
 *	Added salloc() extern.
 *
 * 14-Aug-81  Mike Accetta (mja) at Carnegie-Mellon University
 *	Created.
 *
 ***********************************************************************/

#ifndef _T_LIBC_H_
#define	_T_LIBC_H_ 1

#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus)
#define _PARAMS(ARGS) ARGS
#else
#define _PARAMS(ARGS) ()
#endif
#endif /* _PARAMS */

/* Standard includes that should be available */

/* The newest gcc compiler will give the prototypes if this is defined. */
#define __USE_FIXED_PROTOTYPES__ 1
/*#define __STDC__ 1*/

/* Include the debugging malloc library, if requested. */

#ifdef DBMALLOC
#include "dbmalloc/malloc.h"
#define	__string_h
#endif /* DBMALLOC */

/* Standard UNIX includes that should be available */

#if defined(__unix__) && !defined(linux) && !defined(VXWORKS) && !defined(__osf__) && !defined(MACH) && !defined(__MACH__) && !defined(__sgi)
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#if !defined(DBMALLOC) && !defined(__cplusplus)
#include <string.h>
#endif
#include <unistd.h>
#include <memory.h>
#include <sys/socket.h>
#include <ctype.h>
#include <sys/socketvar.h>
#include <sys/stat.h>
#include <sys/ttold.h>
#include <sys/ttydev.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <netdb.h>
#include <errno.h>
#ifndef _REENTRANT
extern int errno;
#endif
#include <signal.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/filio.h>
#endif /* unix */

#if defined(applec)
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <ctype.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <netdb.h>
#include <errno.h>
extern int errno;
#include <machine/endian.h>
#undef bzero
#define bzero(buf, len) memset((void *)(buf), 0, (size_t)(len))

#undef bcopy
#define bcopy(from, to, len) memcpy((void *)(to), (void *)(from), (size_t)len)
#define FORCE_32BIT_ENUM 1
#endif /* applec */

#if defined(Next) ||  defined(__NeXT__)
#include <stdio.h>
#include <stdlib.h>
#include <bsd/libc.h>
#include <signal.h>
#include <limits.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <errno.h>
extern int errno;
#include <sys/uio.h>
#include <bsd/netinet/in.h>
#include <bsd/netinet/tcp.h>
#include <bsd/netdb.h>
#include <ansi/string.h>
#include <ansi/ctype.h>
#define	S_IRWXU 	0000700	/* rwx, owner */
#define		S_IRUSR	0000400	/* read permission, owner */
#define		S_IWUSR	0000200	/* write permission, owner */
#define		S_IXUSR	0000100	/* execute/search permission, owner */
#define	S_IRWXG		0000070	/* rwx, group */
#define		S_IRGRP	0000040	/* read permission, group */
#define		S_IWGRP	0000020	/* write permission, grougroup */
#define		S_IXGRP	0000010	/* execute/search permission, group */
#define	S_IRWXO		0000007	/* rwx, other */
#define		S_IROTH	0000004	/* read permission, other */
#define		S_IWOTH	0000002	/* write permission, other */
#define		S_IXOTH	0000001	/* execute/search permission, other */
#include <machine/endian.h>
#endif /* Next */

#if defined(linux)
#define __NO_MATH_INLINES
#include <bsd/bsd.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include <unistd.h>
#ifndef DBMALLOC
#include <string.h>
#endif
#include <ctype.h>
#include <endian.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <netdb.h>
#include <errno.h>
/*#include <sys/uio.h>*/
/*#include <sys/filio.h>*/
#include <bsd/sgtty.h>
#define  TIOCSDTR _IO('t', 121)           /* set data terminal ready */
#define	TIOCCDTR _IO('t', 120)		/* clear data terminal ready */
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/resource.h>

extern char **environment;

#endif /* linux */

#if defined(__sgi)

#define	LITTLE_ENDIAN	1234 /* least-significant byte first (vax) */
#define	BIG_ENDIAN	4321 /* most-significant byte first (IBM, net) */
#define	PDP_ENDIAN	3412 /* LSB first in word, MSW first in long (pdp) */
#define BYTE_ORDER BIG_ENDIAN

#ifndef _SVR4_SOURCE
#define _SVR4_SOURCE
#endif

#ifndef _SGI_SOURCE
#define _SGI_SOURCE
#endif

/*#ifndef _XOPEN_SOURCE*/
/*#define _XOPEN_SOURCE*/
/*#endif*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include <ctype.h>
#include <signal.h>
#include <unistd.h>
#include <bstring.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <sys/ttold.h>
#include <sys/ttydev.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <netdb.h>
#include <errno.h>
extern int errno;
#include <fcntl.h>
#include <sys/filio.h>
#include <strings.h>
#ifndef DBMALLOC
#include <string.h>
#endif

extern long	random(void);
extern int	srandom(unsigned);

#endif /* __sgi */

#if defined(VXWORKS)
#include <vxWorks.h>
#include <stdioLib.h>
#include <stdlib.h>
#include <ctype.h>
#include <socket.h>
#include <in.h>
#include <sigLib.h>
#include <errno.h>
#ifndef __vxworks_5
#include <strLib.h>
#endif
#include <systime.h>
#ifdef VX_5_0_2B
#include <sys/uio.h>
#include <net/tcp.h>
#include <ioLib.h>
#include <sys/un.h>
#else /* VX_5_0_2B */
#include <arpa/inet.h>
#include <netinet/tcp.h>
#include <sys/fcntlcom.h>
#include <sys/stat.h>
#include <net/uio.h>
#include <sockLib.h>
#include <hostLib.h>
#include <fcntl.h>
#define BYTE_ORDER _BYTE_ORDER
#define LITTLE_ENDIAN _LITTLE_ENDIAN
#define BIG_ENDIAN _BIG_ENDIAN
#define	PDP_ENDIAN 3412	/* LSB first in word, MSW first in long (pdp) */
#include <selectLib.h>
#include <usrLib.h>
#include <taskVarLib.h>
#include <tickLib.h>
#include <sysLib.h>
#endif /* VX_5_0_2B */

#define strdup(str)      (strcpy(malloc((unsigned) strlen(str) + 1), str))

#define NO_UNIX_SOCKETS 1
#define VX_PIPES 1
#include <pipeDrv.h>
#define NEED_READV 1

#endif /* VXWORKS */

/* SUN Sparcstation definitions */

#if defined(sparc) && ! defined(MACH) && ! defined(__svr4__)
/* sparc, sunOS */

#ifndef DBMALLOC
#include <malloc.h>
extern	malloc_t	valloc _PARAMS((__SIZE_TYPE__ ));
#else
DATATYPE	* valloc __stdcargs((SIZETYPE));
#endif

#include <sys/mman.h>
#include <sys/fcntlcom.h>

#include <time.h>
#include <sys/ttold.h>
#include <sys/ttydev.h>

#define	LITTLE_ENDIAN	1234	/* least-significant byte first (vax) */
#define	BIG_ENDIAN	4321	/* most-significant byte first (IBM, net) */
#define	PDP_ENDIAN	3412	/* LSB first in word, MSW first in long (pdp) */
#define BYTE_ORDER BIG_ENDIAN

extern int fclose _PARAMS((FILE *));
extern int fflush _PARAMS((FILE *));
extern int fgetc _PARAMS((FILE *));
extern int fgetpos _PARAMS((FILE *, long *));
extern int fprintf _PARAMS((FILE *, const char *, ...));
extern int fputc _PARAMS((int, FILE *));
extern int fputs _PARAMS((const char *, FILE *));
extern long unsigned int fread _PARAMS((void *,
					long unsigned int,
					long unsigned int , FILE *));
extern int fscanf _PARAMS((FILE *, const char *, ...));
extern int fseek _PARAMS((FILE *, long int, int));
extern int fsetpos _PARAMS((FILE *, const long *));
extern long unsigned int fwrite _PARAMS((const void *,
					 long unsigned int,
					 long unsigned int , FILE *));
extern void perror _PARAMS((const char *));
extern int printf _PARAMS((const char *, ...));
extern int puts _PARAMS((const char *));
extern int remove _PARAMS((const char *));
extern int rename _PARAMS((const char *, const char *));
extern void rewind _PARAMS((FILE *));
extern int scanf _PARAMS((const char *, ...));
extern void setbuf _PARAMS((FILE *, char *));
extern int setvbuf _PARAMS((FILE *, char *, int, long unsigned int ));
extern int sscanf _PARAMS((const char *, const char *, ...));
extern int ungetc _PARAMS((int, FILE *));
extern int _filbuf _PARAMS((FILE *));

extern unsigned int usleep _PARAMS((unsigned useconds));

extern int bcmp _PARAMS((const void *, const void *, int));
extern void bcopy _PARAMS((const void *src, const void *dest, int len));
extern void bzero _PARAMS((void *ptr, size_t len));

/* defines that should be in <sys/socket.h> */
extern int accept _PARAMS((int, struct sockaddr *, int *));
extern int bind _PARAMS((int, struct sockaddr *, int));
extern int connect _PARAMS((int s, const struct sockaddr *name, int namelen));
extern int getsockopt _PARAMS((int, int, int, void *optval, int *));
extern int setsockopt _PARAMS((int s, int level, int optname,
			       const char *optval, int optlen));
extern int listen _PARAMS((int, int));
extern int socket _PARAMS((int, int, int));
extern int gethostname _PARAMS((char *name, int namelen));
extern int getsockname _PARAMS((int, struct sockaddr *, int *));
extern int select _PARAMS((int, fd_set*, fd_set*, fd_set*,
			   const struct timeval*));

extern int gettimeofday _PARAMS((struct timeval *, struct timezone *));
extern long time _PARAMS((long*));

extern shutdown _PARAMS((int s, int how));
extern void cfree _PARAMS((void *));

extern int ioctl _PARAMS((int fd, int request, ...));
extern int brk _PARAMS((caddr_t addr));

extern caddr_t sbrk _PARAMS((int incr));

extern void srandom _PARAMS((unsigned seed));
extern long random _PARAMS((void));

extern int readv _PARAMS((int, struct iovec *, int));
extern int writev _PARAMS((int, struct iovec *, int));

extern int fchmod _PARAMS((int, int));

#ifndef DBMALLOC
extern char *index(const char*, char);
#endif

#include <sys/resource.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/param.h>
int wait4(int pid, union wait *status, int options, struct rusage *rusage);

extern char **environment;
extern int setpgrp(int, int);

#endif /* sparc, sunOS */

#if defined(sparc) && defined(__svr4__)
/* sparc, Solaris */
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#ifndef DBMALLOC
#include <string.h>
#endif
#include <unistd.h>
#include <memory.h>
#include <sys/sunddi.h>
#include <sys/socket.h>
#include <ctype.h>
#include <sys/socketvar.h>
#include <sys/stat.h>
#include <sys/ttold.h>
#include <sys/ttydev.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <netdb.h>
#include <errno.h>
#ifndef _REENTRANT
extern int errno;
#endif
#include <signal.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/filio.h>

#ifndef DBMALLOC
#include <malloc.h>
#endif
#include <sys/ttold.h>
#include <sys/ttydev.h>
#include <fcntl.h>

#define	LITTLE_ENDIAN	1234	/* least-significant byte first (vax) */
#define	BIG_ENDIAN	4321	/* most-significant byte first (IBM, net) */
#define	PDP_ENDIAN	3412	/* LSB first in word, MSW first in long (pdp) */
#define BYTE_ORDER BIG_ENDIAN

#undef bzero
#define bzero(buf, len) memset((void *)(buf), 0, (size_t)(len))

#undef bcopy
#define bcopy(from, to, len) memcpy((void *)(to), (void *)(from), (size_t)len)

#endif /* sparc, Solaris */

/* Mach definitions */

#if defined(MACH)
#include <stdio.h>
#include <math.h>
#include <limits.h>
#include <stdlib.h>
#ifndef DBMALLOC
#include <string.h>
#endif
/*#include <unistd.h>*/
#include <memory.h>
#include <sys/socket.h>
#include <ctype.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <netdb.h>
#include <errno.h>
extern int errno;
#include <signal.h>
#include <sys/time.h>
#include <machine/endian.h>
#include <time.h>
#include <sys/file.h>
#include <sysent.h>
#include <sys/uio.h>
#include "/usr/cs/include/libc.h"

extern int read _PARAMS((int, void *, int));
extern int write _PARAMS((int, void *, int));
extern void usleep _PARAMS((unsigned));
extern void sleep _PARAMS((unsigned));

extern int bcmp _PARAMS((const void *, const void *, int));
extern void bcopy _PARAMS((const void *, void *, int));
extern void bzero _PARAMS((void *, int));

extern int close _PARAMS((int));

/* defines that should be in <sys/socket.h> */
extern int gethostname _PARAMS((char *name, int namelen));
extern shutdown _PARAMS((int s, int how));
extern int select _PARAMS((int, fd_set*, fd_set*, fd_set*,
			   struct timeval*));

#ifndef vprintf
extern int vprintf _PARAMS((const char *, void * ));
#endif
#ifndef vsprintf
extern char	*vsprintf _PARAMS((char *, const char *, void *));
#endif
#ifndef vfprintf
extern int	vfprintf _PARAMS((FILE *, const char *, void *));
#endif

#define	S_IRWXU 	0000700	/* rwx, owner */
#define		S_IRUSR	0000400	/* read permission, owner */
#define		S_IWUSR	0000200	/* write permission, owner */
#define		S_IXUSR	0000100	/* execute/search permission, owner */
#define	S_IRWXG		0000070	/* rwx, group */
#define		S_IRGRP	0000040	/* read permission, group */
#define		S_IWGRP	0000020	/* write permission, grougroup */
#define		S_IXGRP	0000010	/* execute/search permission, group */
#define	S_IRWXO		0000007	/* rwx, other */
#define		S_IROTH	0000004	/* read permission, other */
#define		S_IWOTH	0000002	/* write permission, other */
#define		S_IXOTH	0000001	/* execute/search permission, other */

/* From ttold.t */
#define		O_ECHO		0x00000008	/* echo input */
#define		O_RAW		0x00000020	/* no i/o processing */

#define HUGE_VAL HUGE
#endif /* Mach */

#if defined(__osf__)
#define _XOPEN_SOURCE
#define _OSF_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#ifndef DBMALLOC
#include <string.h>
#endif
#include <unistd.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <ctype.h>
#include <sys/socketvar.h>
#include <sys/stat.h>
#include <netinet/in.h>
#ifndef TCPOPT_NOP
#include <netinet/tcp.h>
#endif
#include <arpa/inet.h>
#include <sys/un.h>
#include <netdb.h>
#include <errno.h>
extern int errno;
#include <signal.h>
#include <sys/time.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/uio.h>
/* This should be changed when we rename libc.h */
#include "/usr/local/include/libc.h"
/* Ones that are missed. */

/*extern int srandom _PARAMS((int));*/
/*extern long random _PARAMS((void));*/

/*extern int bcmp _PARAMS((const void *, const void *, int));*/
/*extern void bcopy _PARAMS((const void *, void *, int));*/
/*extern void bzero _PARAMS((void *, int));*/

/* defines that should be in <sys/socket.h> */
extern int accept _PARAMS((int, struct sockaddr *, int *));
/*extern int bind _PARAMS((int, struct sockaddr *, int));*/
extern int connect _PARAMS((int s, const struct sockaddr *name, int namelen));
extern int getsockopt _PARAMS((int, int, int, void *optval, int *));
/*extern int setsockopt _PARAMS((int s, int level, int optname,*/
/*			       const char *optval, int optlen));*/
extern int listen _PARAMS((int, int));
extern int socket _PARAMS((int, int, int));
extern int gethostname _PARAMS((char *name, int namelen));
extern int getsockname _PARAMS((int, struct sockaddr *, int *));
/*extern int select _PARAMS((int, fd_set*, fd_set*, fd_set*,*/
/*			   struct timeval*));*/

extern void usleep _PARAMS((unsigned));

extern int ioctl _PARAMS((int fd, int request, ...));
extern void cfree _PARAMS((void *));

extern shutdown _PARAMS((int s, int how));

extern long unsigned int strftime _PARAMS((char *,
					   long unsigned int,
					   const char *, const struct tm *));
/*extern int fchmod _PARAMS((int, int));*/

#include <curses.h>
#include <sys/ioctl.h>
#undef NOFLSH
#include <sys/ioctl_compat.h>
#define  O_RAW           0x00000020     /* no i/o processing */
#define  O_ECHO           0x00000008      /* echo input */

#define _BSD
#include <sys/wait.h>
#define setpgrp tcsetpgrp

#endif /* __osf__ */

#ifdef THINK_C
#include <console.h>
#include <unix.h>
#endif /* THINK_C */

#if defined(__TURBOC__) && !defined(_WINSOCK_)

#include <stdio.h>
#include <errno.h>
#include <netdb.h>
#include <sys/types.h>
#include <time.h>
#include <limits.h>
#include <alloc.h>

#define AF_INET         2               /* internetwork: UDP, TCP, etc. */

#define	LITTLE_ENDIAN	1234 /* least-significant byte first (vax) */
#define	BIG_ENDIAN	4321 /* most-significant byte first (IBM, net) */
#define	PDP_ENDIAN	3412 /* LSB first in word, MSW first in long (pdp) */
#define BYTE_ORDER LITTLE_ENDIAN

struct	iovec {
	caddr_t	iov_base;
	long	iov_len;
};

struct	sockaddr_un {
	short	sun_family;		/* AF_UNIX */
	char	sun_path[108];		/* path name (gag) */
};

#undef bzero
#define bzero(buf, len) memset((void *)(buf), 0, (size_t)(len))

#undef bcopy
#define bcopy(from, to, len) memcpy((void *)(to), (void *)(from), (size_t)len)

#endif /* __TURBOC__ */

#ifdef THINK_C
#include <unix.h>
#undef bzero
#define bzero(buf, len) memset((void *)(buf), 0, (size_t)(len))

#undef bcopy
#define bcopy(from, to, len) memcpy((void *)(to), (void *)(from), (size_t)len)
#endif /* THINK_C */

#if defined(__TURBOC__) && !defined(_WINSOCK_)

#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#define SOCKETS
#include <arpa/inet.h>

#define SOCK_STREAM     1               /* stream socket */
/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#define SOL_SOCKET      0xffff          /* options for socket level */
#define SO_REUSEADDR    0x0004          /* allow local address reuse */

/*
 * Additional options.
 */
#define SO_SNDBUF       0x1001          /* send buffer size */
#define SO_RCVBUF       0x1002          /* receive buffer size */
#define SO_SNDLOWAT     0x1003          /* send low-water mark */
#define SO_RCVLOWAT     0x1004          /* receive low-water mark */
#define SO_SNDTIMEO     0x1005          /* send timeout */
#define SO_RCVTIMEO     0x1006          /* receive timeout */
#define SO_ERROR        0x1007          /* get error status and clear */
#define SO_TYPE         0x1008          /* get socket type */

/*
 * TCP options.
 */
#define TCP_NODELAY     0x0001
#define AF_UNIX         1               /* local to host (pipes, portals) */

#define	S_IRWXU 	0000700	/* rwx, owner */
#define		S_IRUSR	0000400	/* read permission, owner */
#define		S_IWUSR	0000200	/* write permission, owner */
#define		S_IXUSR	0000100	/* execute/search permission, owner */
#define	S_IRWXG		0000070	/* rwx, group */
#define		S_IRGRP	0000040	/* read permission, group */
#define		S_IWGRP	0000020	/* write permission, grougroup */
#define		S_IXGRP	0000010	/* execute/search permission, group */
#define	S_IRWXO		0000007	/* rwx, other */
#define		S_IROTH	0000004	/* read permission, other */
#define		S_IWOTH	0000002	/* write permission, other */
#define		S_IXOTH	0000001	/* execute/search permission, other */

/* #define int long */
#define int32 long
#define int16 short
#define NO_UNIX_SOCKETS 1
#define NEED_READV 1
#elif defined(_WINSOCK_)
#include <arpa/inet.h>

#include <sys/un.h>

#endif /* __TURBOC__ */

#ifdef _WINSOCK_ 
/* Begin Winsock defines */

#include <winsock.h>
#include <dos.h>
#include <io.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>  /* Time types */
#include <time.h>			/* Time defines */
#include <limits.h>
#include <alloc.h>

#define  NO_UNIX_SOCKETS 1
#define  NEED_READV 1

#define	LITTLE_ENDIAN	1234 /* least-significant byte first (vax) */
#define	BIG_ENDIAN	4321 /* most-significant byte first (IBM, net) */
#define	PDP_ENDIAN	3412 /* LSB first in word, MSW first in long (pdp) */
#define BYTE_ORDER LITTLE_ENDIAN

struct	iovec {
	char*	iov_base;
	long	iov_len;
};

struct	sockaddr_un {
	short	sun_family;		/* AF_UNIX */
	char	sun_path[108];		/* path name (gag)*/
};

#undef bzero
#define bzero(buf, len) memset((void *)(buf), 0, (size_t)(len))

#undef bcopy
#define bcopy(from, to, len) memcpy((void *)(to), (void *)(from), (size_t)len)

/* #define int long */
#define int32 long
#define int16 short

#endif /* _WINSOCK */


#if defined(sparc) && ! defined(MACH) && ! defined(__svr4__)
#if defined(LISP)
extern int strcasecmp(char *, char *);
#endif
#endif

#endif	/* not _T_LIBC_H_ */
