/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: idTable
 *
 * FILE: idtable.h
 *
 * ABSTRACT:
 * 
 * Generic dynamic array abstract data type.
 *
 * REVISION HISTORY
 *
 * $Log: idtable.h,v $
 * Revision 1.9  1995/05/31  19:35:43  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.8  1995/04/19  14:28:20  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.7  1995/01/18  22:40:51  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.6  1994/05/25  04:57:38  rich
 * Defined macros for registering simple messages and handlers at once.
 * Added function to ignore logging for all messages associated with a
 * global variable.
 * Moved module global variable routines to a new file so they are not
 * included in the .sa library file.  Gets better code sharing and lets you
 * debug these routines.
 * Added code to force the module variables to be re-initialized after the
 * server goes down.
 * tcaClose now will not crash if the server is down and frees some module
 * memory.
 * The command line flag "-u" turns off the simple user interface.
 * Added routines to free hash tables and id tables.
 *
 * Revision 1.5  1994/05/17  23:16:05  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.4  1993/12/01  18:03:41  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.3  1993/08/27  07:15:10  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:17:41  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:44  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:30:14  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:24:07  fedor
 * Added Logging.
 *
 * 25-Aug-90 Christopher Fedor, School of Computer Science, CMU
 * Revised to Software Standards.
 *
 * 20-Feb-89 Christopher Fedor, School of Computer Science, CMU
 * created.
 *
 * $Revision: 1.9 $
 * $Date: 1995/05/31 19:35:43 $
 * $Author: rich $
 *
 *****************************************************************************/

#ifndef INCidtable
#define INCidtable


typedef struct _TELEM {
  int32 ref;
  char *data;
  struct _TELEM *next;
} TELEM_TYPE, *TELEM_PTR;

typedef struct {
  char *name;
  int32 incSize;
  int32 freeTotal; 
  int32 currentSize;
  TELEM_PTR table, freeList;
} ID_TABLE_TYPE, *ID_TABLE_PTR;

#define idTableItem(id, idTable) ((idTable->table+id)->data)

ID_TABLE_PTR idTableCreate(char *name, int32 incSize);
void idTableFree(ID_TABLE_PTR *table);
int32 idTableInsert(void *item, ID_TABLE_PTR table);
void *idTableRemove(int32 id, ID_TABLE_PTR table);
void idTablePrintInfo(ID_TABLE_PTR table);

int32 idTableSearch(void *item, ID_TABLE_PTR table);
#endif /* INCidtable */
