/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * MODULE: burying globals under a rock!
 *
 * FILE: global.c
 *
 * ABSTRACT: define module global support routines.
 *
 * REVISION HISTORY
 *
 * $Log: globalMUtil.c,v $
 * Revision 1.30  1996/07/25  22:24:24  rich
 * Fixed some memory leaks with handlers and removed some problems where a
 * disconnection caused a cleanup, but a variable would be assumed to still
 * be valid.
 *
 * Revision 1.29  1996/07/03  21:43:35  reids
 * Have "tcaWaitUntilReady" print out any required resources it is waiting for
 *
 * Revision 1.28  1996/06/27  15:40:12  rich
 * Added tcaGetAcceptFds.
 *
 * Revision 1.27  1996/06/25  20:50:40  rich
 * Fixed memory and other problems found with purify.
 *
 * Revision 1.26  1996/05/09  18:30:58  reids
 * Changes to keep TCA consistent with the NASA IPC package.
 * Some bug fixes (mainly to do with freeing formatters).
 *
 * Revision 1.25  1996/05/07  16:49:33  rich
 * Changes for clisp.
 *
 * Revision 1.24  1996/03/05  05:04:31  reids
 * Changes (mainly delineated by NMP_IPC conditionals) to support the
 *   New Millennium IPC.
 *
 * Revision 1.23  1996/02/21  18:30:23  rich
 * Created single event loop.
 *
 * Revision 1.22  1996/02/06  19:04:45  rich
 * Changes for VXWORKS pipes.  Note: the read and write sockets descriptors
 * can be different.
 *
 * Revision 1.21  1996/01/30  15:04:14  rich
 * Fixed var array index problem.  Index refers to the enclosing structure.
 * Added ability to force 32 bit enums and changed some #defs to enums to
 * ease debugging.  Fixed initialization problems for central.
 *
 * Revision 1.20  1996/01/27  21:53:31  rich
 * Pre-release of 8.4.
 * Added recursive named formatters and "BAD" formats.  Also incorporated
 * Iain's windows changes.
 *
 * Revision 1.19  1996/01/05  16:31:22  rich
 * Added windows NT port.
 *
 * Revision 1.18  1995/12/17  20:21:26  rich
 * Have free routines set pointers to NULL.
 * Removed old makefiles.
 *
 * Revision 1.17  1995/12/15  01:23:12  rich
 * Moved Makefile to Makefile.generic to encourage people to use
 * GNUmakefile.
 * Fixed a memory leak when a module is closed and some other small fixes.
 *
 * Revision 1.16  1995/10/25  22:48:24  rich
 * Fixed problems with context switching.  Now the context is a separate
 * data structure accessed from the module data structure, using the
 * currentContext field.  GET_C_GLOBAL is used instead of GET_M_GLOBAL for
 * the context dependent fields.
 *
 * Revision 1.15  1995/10/07  19:07:20  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Added tcaWillListen.
 * Only transmit broadcast messages when there is a handler to receive them.
 * All system messages now start with "tca_".  Old messages are also supported.
 *
 * Revision 1.14  1995/07/19  14:26:15  rich
 * Added display and dump to the central interface.
 * Fixed problem with direct querries not returning to the correct module.
 * Added Argv versions of provides and requires.
 *
 * Revision 1.13  1995/07/06  21:16:27  rich
 * Solaris and Linux changes.
 *
 * Revision 1.12  1995/05/31  19:35:38  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.11  1995/04/07  05:03:11  rich
 * Fixed GNUmakefiles to find the release directory.
 * Cleaned up libc.h file for sgi and vxworks.  Moved all system includes
 * into libc.h
 * Got direct queries to work.
 * Fixed problem in allocating/initializing generic mats.
 * The direct flag (-c) now mostly works.  Connect message has been extended to
 * indicate when direct connections are the default.
 * Problem with failures on sunOS machines.
 * Fixed problem where tcaError would not print out its message if logging had
 * not been initialized.
 * Fixed another memory problem in modVar.c.
 * Fixed problems found in by sgi cc compiler.  Many type problems.
 *
 * Revision 1.10  1995/03/30  15:43:03  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added simple list of strings data structure that can be passed via tca
 * messages.
 * Use the string list to maintain a global variable of messages with taps.
 * Tapped messages are not sent via direct connections.
 * Implemented code to vectorize data to be sent so that it does not have
 * to be copied.  Currently, only flat, packed data structures are
 * vectored.  This can now be easily extended.
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 * Fixed bug were central would try and free the "***New Module***" and
 * "*** Unkown Host***" strings when a module crashed on startup.
 * Fixed a bug reported by Jay Gowdy where the code to find the size of a
 * variable lenght array would access already freed data when called from
 * tcaFreeData.
 *
 * Revision 1.9  1995/03/28  01:14:34  rich
 * - Added ability to log data with direct connections.  Also fixed some
 * problems with global variables. It now uses broadcasts for watching variables.
 * - Added preliminary memory recovery routines to handle out of memory
 * conditions.  It currently purges items from resource queues.  Needs to
 * be tested.
 * - If the CENTRALHOST environment variable is not set, try the current
 * host.
 * - Fixed a problem with central registered messages that caused the parsed
 * formatters to be lost.
 * - Added const declarations where needed to the prototypes in tca.h.
 * - tcaGetConnections: Get the fd_set.  Needed for direct connections.
 * - Added tcaExecute and tcaExecuteWithConstraints.  Can "execute" a goal
 *   or command.
 * - tcaPreloadMessage: Preload the definition of a message from the
 *   central server.
 *
 * Revision 1.8  1995/03/19  19:39:31  rich
 * Implemented direct connections using tcaDirectResouce call.
 * Also made the basics.h file a module include.
 * Changed class in the interval structure to be interval_class to avoid a
 * conflict with C++.
 *
 * Revision 1.7  1995/02/06  14:46:08  reids
 * Removed the "Global" suffix from tcaRootNode, tcaServer and tcaDefaultTime
 *
 * Revision 1.6  1995/01/30  16:18:03  rich
 * Added indications of message byte order and alignment to the message
 * header in the upper two bytes of the classID.
 * Now the receiver translates the byte order but must receive data in
 * "PACKED" alignment.
 * Made -gstabs come after -g for i386_mach machines so the debugger will work.
 *
 * Revision 1.5  1995/01/18  22:40:37  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.4  1994/11/02  21:34:17  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile.
 * Made libc.h and tcaMatrix.h module includes.
 * Reduced the size of libc.h by using more system includes.
 *
 * Revision 1.3  1994/07/26  15:03:25  reids
 * Changed the order of an initialization test to make globalMInit work with
 * the Xavier navigation code.
 *
 * Revision 1.2  1994/05/29  16:20:29  reids
 * Changes needed to successfully make a VxWorks version
 *
 * Revision 1.1  1994/05/25  05:10:44  rich
 * Moved module global routines to a new file so they don't get included in
 * the .sa library file.
 *
 * Revision 1.14  1994/05/24  13:48:44  reids
 * Fixed so that messages are not sent until a tcaWaitUntilReady is received
 * (and the expected number of modules have all connected)
 *
 * Revision 1.13  1994/05/11  01:57:28  rich
 * Now set an invalid tcaServerGlobal (a socket fd) to -1 rather than 0
 * which is stdout.
 * Added checks to make sure tcaServerGlobal is a valid socket before
 * sending messages or waiting for messages.
 *
 * Revision 1.12  1994/04/28  16:16:07  reids
 * Changes in TCA Version 7.6:
 *  1) New functions: tcaIgnoreLogging and tcaResumeLogging
 *  2) Code for MacIntosh (MPW) version of TCA
 *
 * Revision 1.11  1994/04/26  16:23:28  rich
 * Now you can register an exit handler before anything else and it will
 * get called if connecting to central fails.
 * Also added code to handle pipe breaks during writes.
 *
 * Revision 1.10  1994/04/16  19:42:14  rich
 * First release of TCA for the DEC alpha.
 * Changes were needed because longs are 64 bits.
 * Fixed alignment assumption in the data message format.
 * Fixed the way offsets are calculated for variable length arrays.  This
 * was a problem even without 64 bit longs and pointers.
 *
 * Added the commit date to the version information printed out with the -v
 * option.
 *
 * Now uses standard defines for byte order
 * (BYTE_ORDER = BIG_ENDIAN, LITTLE_ENDIAN or PDP_ENDIAN)
 *
 * Defined alignment types: ALIGN_INT ALINE_LONGEST and ALIGN_WORD.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.9  1994/04/15  17:09:53  reids
 * Changes to support vxWorks version of TCA 7.5
 *
 * Revision 1.8  1993/12/14  17:33:40  rich
 * Changed getMGlobal to GET_M_GLOBAL and changed getSGlobal to
 * GET_S_GLOBAL to conform to Chris' software standards.
 *
 * Patched problem with connecting between machines with different byte
 * orders.  The real fix requires changing the way formats are stored.
 * Searching for structural similar formats does not guarantee that you
 * find the right format.
 *
 * Revision 1.7  1993/11/21  20:17:54  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.6  1993/10/20  19:00:33  rich
 * Fixed bug with self registed messages in the lisp version.
 * Added new routine : tcaGetServerGlobal to get the server socket.
 * Fixed some bad global references for the lisp version.
 * Updated some prototypes.
 *
 * Revision 1.5  1993/08/30  21:53:31  fedor
 * V7+V6+VXWORKS Everything compiles but there are initialization problems.
 *
 * Revision 1.4  1993/08/27  08:38:37  fedor
 * Pass 2 aat a V7+V6+VxWorks merge. Many many problems with pointless casting.
 *
 * Revision 1.3  1993/08/27  07:14:56  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/06/13  23:28:09  rich
 * Made changes for lisp needed for vx works style global variables.
 * Fixed some random compiler warnings.
 * Moved test routines to test directory.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:23  rich
 * Importing tca version 8
 *
 * Revision 8.1  1993/05/20  00:29:57  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:23:50  fedor
 * Added Logging.
 *
 * $Revision: 1.30 $
 * $Date: 1996/07/25 22:24:24 $
 * $Author: rich $
 *
 *****************************************************************************/

#include "globalM.h"

/* Can remove when next release of GUSI comes out */
#if defined(applec)
FILE * _lastbuf = _iob + _NFILE;
#endif

#if defined(CLISP)
extern int (lispbuffersize) (u_int32 g695, u_int32 g696, void* g697);
extern int (lispdecode) (u_int32 g667, u_int32 g668);
extern int (lispencode) (u_int32 g681, void* g682, u_int32 g683);
extern int (lispexit) (void);
extern int (lispreply) (void* g711);
#endif

void globalMInit(void)
{
#if defined(VXWORKS)
  if (taskVarAdd(0, (int *)&gM) != OK) {
    printErr("taskVarAdd failed\n");
  }
#endif
  
  if (mGlobalp() && GET_C_GLOBAL(valid)) {
    /* Already initialized, nothing to do. */
    return;
  } else if (isValidServerConnection()) {
    /* Already running, shut down and reinitialize. */
    shutdown(GET_C_GLOBAL(tcaServerReadGlobal), 2);
#ifdef _WINSOCK_
    closesocket(GET_C_GLOBAL(tcaServerReadGlobal));
#else
    close(GET_C_GLOBAL(tcaServerReadGlobal));
    if (GET_C_GLOBAL(tcaServerReadGlobal) != 
	GET_C_GLOBAL(tcaServerWriteGlobal))
      close(GET_C_GLOBAL(tcaServerWriteGlobal));
#endif
    globalMInvalidate();
    globalMFree();
  } else if (mGlobalp()){
    /* Was initialized, but the current values are not valid. */
    /* Free some memory and reinitialize. */
    globalMFree();
  } 
  /* Never created or has been freed, set the global pointer. */
#if defined(VXWORKS)
  gM = (GM_TYPE *)malloc(sizeof(GM_TYPE));
  bzero((void *)gM,sizeof(GM_TYPE));
#else
  gM_ptr = &gM;
#endif
  GET_M_GLOBAL(currentContext) = 
    (TCA_CONTEXT_PTR)malloc(sizeof(TCA_CONTEXT_TYPE));
  
#if defined(VXWORKS)
  GET_M_GLOBAL(enableDistributedResponses) = TRUE;
#else
  GET_M_GLOBAL(enableDistributedResponses) = FALSE;
#endif
  
  GET_C_GLOBAL(willListen) = -1;
  GET_C_GLOBAL(valid) = FALSE;
  
#if defined(LISP)
  GET_M_GLOBAL(lispRefSaveGlobal) = NULL;
#endif
  
  GET_C_GLOBAL(tcaServerReadGlobal) = NO_SERVER_GLOBAL;
  GET_C_GLOBAL(tcaServerWriteGlobal) = NO_SERVER_GLOBAL;
  GET_C_GLOBAL(directDefault) = FALSE;
  
  GET_M_GLOBAL(pipeBroken) = FALSE;
  
  GET_M_GLOBAL(bufferToAlloc) = NULL;
  
  /* not done */
  GET_M_GLOBAL(byteFormat) = NULL;
  GET_M_GLOBAL(charFormat) = NULL;
  GET_M_GLOBAL(doubleFormat) = NULL;
  GET_M_GLOBAL(floatFormat) = NULL;
  GET_M_GLOBAL(intFormat) = NULL;
  GET_M_GLOBAL(longFormat) = NULL;
  GET_M_GLOBAL(shortFormat) = NULL;
  
  GET_M_GLOBAL(classFormatTable) = NULL;
  GET_M_GLOBAL(formatNamesTable) = NULL;
  GET_C_GLOBAL(handlerTable) = NULL;
  GET_C_GLOBAL(messageTable) = NULL;
  GET_C_GLOBAL(resourceTable) = NULL;
  GET_C_GLOBAL(hndIdTable) = NULL;
  GET_C_GLOBAL(msgIdTable) = NULL;
  GET_M_GLOBAL(listCellFreeListGlobal) = NULL;
  GET_M_GLOBAL(dataMsgBufferList) = NULL;
  GET_M_GLOBAL(listFreeListGlobal) = NULL;
  GET_C_GLOBAL(moduleConnectionTable) = NULL;
  GET_C_GLOBAL(tcaPendingRepliesGlobal) = NULL;
  GET_C_GLOBAL(queryNotificationList) = NULL;
  GET_C_GLOBAL(tcaRefFreeList) = NULL;
  /* GET_M_GLOBAL(tcaDefaultTimeGlobal) = {NoTime, {NoInterval, 0}}; */
  /* 16-Jan-93 */
  /* GET_M_GLOBAL(versionGlobal);*/
#if defined(DBMALLOC)
  GET_M_GLOBAL(tcaMallocMemHnd) = debug_malloc;
#elif defined(__TURBOC__)
  GET_M_GLOBAL(tcaMallocMemHnd) = farmalloc;
#else
  GET_M_GLOBAL(tcaMallocMemHnd) = malloc;
#endif
  GET_M_GLOBAL(modNameGlobal) = NULL;
  GET_C_GLOBAL(servHostGlobal) = NULL;
  
  FD_ZERO(&(GET_C_GLOBAL(tcaConnectionListGlobal)));
  FD_ZERO(&(GET_C_GLOBAL(tcaListenMaskGlobal)));
  
#if defined(LISP)
#if defined(CLISP)
  GET_M_GLOBAL(lispBufferSizeGlobal) = lispbuffersize;
  GET_M_GLOBAL(lispDecodeMsgGlobal) = lispdecode;
  GET_M_GLOBAL(lispEncodeMsgGlobal) = lispencode;
  GET_M_GLOBAL(lispExitGlobal) = lispexit;
  GET_M_GLOBAL(lispReplyMsgGlobal) = lispreply;
#else
  GET_M_GLOBAL(lispBufferSizeGlobal) = NULL;
  GET_M_GLOBAL(lispDecodeMsgGlobal) = NULL;
  GET_M_GLOBAL(lispEncodeMsgGlobal) = NULL;
  GET_M_GLOBAL(lispExitGlobal) = NULL;
  GET_M_GLOBAL(lispReplyMsgGlobal) = NULL;
#endif
#endif
  GET_M_GLOBAL(DMFree) = 0;
  GET_M_GLOBAL(DMTotal) =0;
  GET_M_GLOBAL(DMmin) = 0;
  GET_M_GLOBAL(DMmax) = 0;;
  GET_M_GLOBAL(directFlagGlobal) = 0;
  GET_M_GLOBAL(expectedWaitGlobal) = FALSE;
  GET_M_GLOBAL(freeMemRetryAmount) = 0;
  
  /* not done - only used in behaviors.c does not change */
  GET_M_GLOBAL(inconsistentConstraintsGlobal)[0] = (PLAN_FIRST+DELAY_PLANNING);
  GET_M_GLOBAL(inconsistentConstraintsGlobal)[1] = 0;
  
  GET_M_GLOBAL(mallocMemRetryAmount) = 1;
  GET_C_GLOBAL(parentRefGlobal) = -1; 
  /* GET_M_GLOBAL(resendAfterCrashGlobal) = FALSE;*/
  /* 16-Jan-93: fedor: not a mod var */
  GET_C_GLOBAL(responseIssuedGlobal) = FALSE;
  GET_C_GLOBAL(sendMessageRefGlobal) = 1;
  GET_C_GLOBAL(listenPortNum) = 0;
  GET_C_GLOBAL(tcaListenPort) = NO_FD;
  GET_C_GLOBAL(tcaListenSocket) = NO_FD;
  GET_M_GLOBAL(totalMemRequest) = 0;
  
  GET_M_GLOBAL(indentGlobal) = 0;
  GET_M_GLOBAL(dPrintBYTE_FN) = NULL;
  GET_M_GLOBAL(dPrintUBYTE_FN) = NULL;
  GET_M_GLOBAL(dPrintCHAR_FN) = NULL;
  GET_M_GLOBAL(dPrintDOUBLE_FN) = NULL;
  GET_M_GLOBAL(dPrintFLOAT_FN) = NULL;
  GET_M_GLOBAL(dPrintFORMAT_FN) = NULL;
  GET_M_GLOBAL(dPrintINT_FN) = NULL;
  GET_M_GLOBAL(dPrintBOOLEAN_FN) = NULL;
  GET_M_GLOBAL(dPrintLONG_FN) = NULL;
#ifndef NMP_IPC
  GET_M_GLOBAL(dPrintMAP_FN) = NULL;
#endif
  GET_M_GLOBAL(dPrintSHORT_FN) = NULL;
  GET_M_GLOBAL(dPrintSTR_FN) = NULL;
  GET_M_GLOBAL(dPrintTCA_FN) = NULL;
  GET_M_GLOBAL(dPrintTWOBYTE_FN) = NULL;
  GET_M_GLOBAL(Message_Ignore_Set) = NULL;
  
  GET_M_GLOBAL(tcaExitHnd) = NULL;
  GET_M_GLOBAL(tcaFreeMemoryHnd) = NULL;
  
  GET_M_GLOBAL(logList)[0] = NULL;
  GET_M_GLOBAL(logList)[1] = NULL;
  GET_M_GLOBAL(logList)[2] = NULL;
  
  GET_M_GLOBAL(Found_Key) = NULL;/***/
  
  GET_C_GLOBAL(tappedMsgs) = NULL;
  GET_C_GLOBAL(broadcastMsgs) = NULL;
  GET_C_GLOBAL(tcaMaxConnection) = 0;

  GET_M_GLOBAL(requiredResources) = strListCreate();
  GET_M_GLOBAL(moduleList) = NULL;

#ifdef NMP_IPC
  /* Variables that are in GS_TYPE, but are now needed within a module
     (for parsing formats and printing data structures) */
  GET_M_GLOBAL(Location) = 0;
  GET_M_GLOBAL(TokenList) = NULL;
  GET_M_GLOBAL(TokenListHead) = NULL;
  GET_M_GLOBAL(ParseString) = NULL;
  GET_M_GLOBAL(lineNumGlobal) = 0;
  GET_M_GLOBAL(cursorPosGlobal) = 0;
  GET_M_GLOBAL(truncatedGlobal) = 0; 
#endif
}


/******************************************************************************
 *
 * FUNCTION: void freeContext(TCA_CONTEXT_PTR *context)
 *
 * DESCRIPTION: 
 * Free memory that tca allocates for a context.
 *
 *****************************************************************************/
static void freeContext(TCA_CONTEXT_PTR *context)
{
  if (!*context) return;

  tcaFree((char *)(*context)->servHostGlobal);
  
  listFreeAllItems((LIST_FREE_FN)tcaFree,
		   (*context)->queryNotificationList);
  listFree(&((*context)->queryNotificationList));
  (*context)->queryNotificationList = NULL;
  tcaRefFree(GET_M_GLOBAL(tcaRootNodeGlobal));
  GET_M_GLOBAL(tcaRootNodeGlobal) = NULL;
  listFreeAllItems((LIST_FREE_FN)tcaFree, 
		   (*context)->tcaRefFreeList);
  listFree(&((*context)->tcaRefFreeList));
  (*context)->tcaRefFreeList = NULL;
  
  hashTableFree(&((*context)->moduleConnectionTable),hashItemsFree, NULL);
  hashTableFree(&((*context)->handlerTable),(HASH_ITER_FN) hndFree,NULL);
  hashTableFree(&((*context)->messageTable),(HASH_ITER_FN) msgFree, NULL);
  hashTableFree(&((*context)->resourceTable),hashItemsFree, NULL);
  idTableFree(&(*context)->hndIdTable);
  idTableFree(&(*context)->msgIdTable);
  listFreeAllItems((LIST_FREE_FN)dataMsgFree, 
		   (*context)->tcaPendingRepliesGlobal);
  listFree(&((*context)->tcaPendingRepliesGlobal));
  (*context)->tcaPendingRepliesGlobal = NULL;
  strListFree(&((*context)->tappedMsgs),TRUE);
  strListFree(&((*context)->broadcastMsgs),TRUE);
  
  listFree(&((*context)->queryNotificationList));
  
  tcaFree((char *)*context);
  *context = NULL;
}

/******************************************************************************
 *
 * FUNCTION: void globalMFree(void)
 *
 * DESCRIPTION: 
 * Free memory that tca allocates in the module.
 *
 *****************************************************************************/
void globalMFree(void)
{
  if (mGlobalp()) {
    listFreeAllItems((LIST_FREE_FN)tcaFree, 
		     GET_M_GLOBAL(dataMsgBufferList));
    listFree(&(GET_M_GLOBAL(dataMsgBufferList)));
    GET_M_GLOBAL(dataMsgBufferList) = NULL;
    listFree(&(GET_M_GLOBAL(Message_Ignore_Set)));
    GET_M_GLOBAL(Message_Ignore_Set) = NULL;
    
    hashTableFree(&GET_M_GLOBAL(classFormatTable),
		  (HASH_ITER_FN)classEntryFree, NULL);
    hashTableFree(&GET_M_GLOBAL(formatNamesTable),
		  (HASH_ITER_FN)formatFreeEntry, NULL);
    hashTableFree(&GET_M_GLOBAL(externalFdTable),hashItemsFree, NULL);
    
    if (GET_M_GLOBAL(logList)[0]) {
      tcaFree((char *)(GET_M_GLOBAL(logList)[0])->theFile);
      tcaFree((char *)GET_M_GLOBAL(logList)[0]);
    }
    GET_M_GLOBAL(logList)[0] = NULL;
    if (GET_M_GLOBAL(logList)[1]) {
      tcaFree((char *)(GET_M_GLOBAL(logList)[1])->theFile);
      tcaFree((char *)GET_M_GLOBAL(logList)[1]);
    }
    GET_M_GLOBAL(logList)[1] = NULL;

    freeContext(&(gM->currentContext));

    listCleanup();
    
    strListFree(&GET_M_GLOBAL(requiredResources), TRUE);

    tcaFree((char *)GET_M_GLOBAL(modNameGlobal));
#if defined(VXWORKS)
    tcaFree((char *)gM);
    gM = NULL;
#else
    globalMInit();
    tcaFree((char *)GET_M_GLOBAL(currentContext));
    bzero(&gM,sizeof(gM));
    gM_ptr = NULL;
#endif
  }
}


/******************************************************************************
 *
 * FUNCTION: void globalMInvalidate(void)
 *
 * DESCRIPTION: 
 * Indicate that the module data structures are invalid and need to be 
 * reinitialized.  This is used when the server goes down.
 *
 *****************************************************************************/
void globalMInvalidate(void)
{
  if (mGlobalp()) {
    GET_C_GLOBAL(tcaServerReadGlobal) = NO_SERVER_GLOBAL;
    GET_C_GLOBAL(tcaServerWriteGlobal) = NO_SERVER_GLOBAL;
    GET_C_GLOBAL(valid) = FALSE;
  }
}

/******************************************************************************
 *
 * FUNCTION: BOOLEAN isValidServerConnection(void)
 *
 * DESCRIPTION: 
 * Returns TRUE if the connection to the server is valid.
 *
 *****************************************************************************/
BOOLEAN isValidServerConnection(void)
{
  return (mGlobalp() && 
	  GET_C_GLOBAL(tcaServerWriteGlobal) != NO_SERVER_GLOBAL);
}

/******************************************************************************
 *
 * FUNCTION: int32  tcaGetServer(void)
 *
 * DESCRIPTION: 
 * Returns the connection number for connection to central, or -1.
 *
 *****************************************************************************/
int  tcaGetServer(void)
{
  if (mGlobalp())
    return GET_C_GLOBAL(tcaServerReadGlobal);
  else
    return -1;
}


/******************************************************************************
 *
 * FUNCTION: int  tcaGetConnections(void)
 *
 * DESCRIPTION: 
 * Returns set of open file descriptors.
 *
 *****************************************************************************/
fd_set  *tcaGetConnections(void)
{
  return &GET_C_GLOBAL(tcaConnectionListGlobal);
}


/******************************************************************************
 *
 * FUNCTION: int  tcaGetConnections(void)
 *
 * DESCRIPTION: 
 * Returns set file descriptors open for accepting new connections.
 *
 *****************************************************************************/
fd_set  *tcaGetAcceptFds(void)
{
  return &GET_C_GLOBAL(tcaListenMaskGlobal);
}


/******************************************************************************
 *
 * FUNCTION: int  tcaGetMaxConnection(void)
 *
 * DESCRIPTION: 
 * Returns the largest connection number ever used.
 *
 *****************************************************************************/
int tcaGetMaxConnection(void)
{
  return GET_C_GLOBAL(tcaMaxConnection);
}

/******************************************************************************
 *
 * FUNCTION: TCA_REF_PTR tcaRootNode(void)
 *
 * DESCRIPTION: Return a reference to the root node of the task tree
 *
 *****************************************************************************/
TCA_REF_PTR tcaRootNode(void)
{
  if (mGlobalp())
    return GET_M_GLOBAL(tcaRootNodeGlobal);
  else
    return NULL;
}

/******************************************************************************
 *
 * FUNCTION: TCA_TIME_POINT_TYPE tcaDefaultTime(void)
 *
 * DESCRIPTION: Default time used for specifying interval monitors
 *
 *****************************************************************************/
TCA_TIME_POINT_TYPE tcaDefaultTime(void)
{
  return GET_M_GLOBAL(tcaDefaultTimeGlobal);
}
