/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * MODULE: burying globals under a rock!
 *
 * FILE: global.h
 *
 * ABSTRACT: externs
 *
 * REVISION HISTORY
 *
 * $Log: globalM.h,v $
 * Revision 1.46  1996/08/05  16:06:54  rich
 * Added comments to endifs.
 *
 * Revision 1.45  1996/07/25  22:24:22  rich
 * Fixed some memory leaks with handlers and removed some problems where a
 * disconnection caused a cleanup, but a variable would be assumed to still
 * be valid.
 *
 * Revision 1.44  1996/07/03  21:43:33  reids
 * Have "tcaWaitUntilReady" print out any required resources it is waiting for
 *
 * Revision 1.43  1996/05/14  22:40:11  rich
 * Need the check for valid context before dereferencing.
 *
 * Revision 1.42  1996/05/09  18:30:56  reids
 * Changes to keep TCA consistent with the NASA IPC package.
 * Some bug fixes (mainly to do with freeing formatters).
 *
 * Revision 1.41  1996/03/05  05:04:29  reids
 * Changes (mainly delineated by NMP_IPC conditionals) to support the
 *   New Millennium IPC.
 *
 * Revision 1.40  1996/02/21  18:30:21  rich
 * Created single event loop.
 *
 * Revision 1.39  1996/02/06  19:04:43  rich
 * Changes for VXWORKS pipes.  Note: the read and write sockets descriptors
 * can be different.
 *
 * Revision 1.38  1996/01/05  16:31:20  rich
 * Added windows NT port.
 *
 * Revision 1.37  1995/10/29  18:26:48  rich
 * Initial creation of 8.3. Added changes made after 8.2 branch was
 * created. These mostly have to do with context switching.
 *
 * Revision 1.36  1995/10/25  22:48:22  rich
 * Fixed problems with context switching.  Now the context is a separate
 * data structure accessed from the module data structure, using the
 * currentContext field.  GET_C_GLOBAL is used instead of GET_M_GLOBAL for
 * the context dependent fields.
 *
 * Revision 1.35  1995/10/07  19:07:18  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Added tcaWillListen.
 * Only transmit broadcast messages when there is a handler to receive them.
 * All system messages now start with "tca_".  Old messages are also supported.
 *
 * Revision 1.34  1995/07/10  16:17:26  rich
 * Interm save.
 *
 * Revision 1.33  1995/07/06  21:16:25  rich
 * Solaris and Linux changes.
 *
 * Revision 1.32  1995/06/14  03:21:36  rich
 * Added DBMALLOC_DIR.
 * More support for DOS.  Fixed some problems with direct connections.
 *
 * Revision 1.31  1995/05/31  19:35:37  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.30  1995/04/21  03:53:23  rich
 * Added central commands to kill the task tree and close a module.
 * Added tcaGetContext and tcaSetContext to support connections to multiple
 * central servers.  tcaConnectModules can be called multiple times.
 * Fixed a bug in the resource limit pending.
 * Created seperate routines to print help and option messages.
 *
 * Revision 1.29  1995/04/19  14:28:15  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.28  1995/04/07  05:03:08  rich
 * Fixed GNUmakefiles to find the release directory.
 * Cleaned up libc.h file for sgi and vxworks.  Moved all system includes
 * into libc.h
 * Got direct queries to work.
 * Fixed problem in allocating/initializing generic mats.
 * The direct flag (-c) now mostly works.  Connect message has been extended to
 * indicate when direct connections are the default.
 * Problem with failures on sunOS machines.
 * Fixed problem where tcaError would not print out its message if logging had
 * not been initialized.
 * Fixed another memory problem in modVar.c.
 * Fixed problems found in by sgi cc compiler.  Many type problems.
 *
 * Revision 1.27  1995/04/05  19:10:49  rich
 * Adding Reid's Changes.
 * Consolidating the matrix code.
 *
 * Revision 1.26  1995/04/04  19:42:13  rich
 * Added sgi support.
 * Split low level com routines out to be used in devUtils.
 * Improved some error messages.
 * Added central switch to default to direct connections.  Does not work yet.
 * Fixed the vectorization code.
 *
 * Revision 1.25  1995/03/30  15:43:02  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added simple list of strings data structure that can be passed via tca
 * messages.
 * Use the string list to maintain a global variable of messages with taps.
 * Tapped messages are not sent via direct connections.
 * Implemented code to vectorize data to be sent so that it does not have
 * to be copied.  Currently, only flat, packed data structures are
 * vectored.  This can now be easily extended.
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 * Fixed bug were central would try and free the "***New Module***" and
 * "*** Unkown Host***" strings when a module crashed on startup.
 * Fixed a bug reported by Jay Gowdy where the code to find the size of a
 * variable lenght array would access already freed data when called from
 * tcaFreeData.
 *
 * Revision 1.24  1995/03/28  01:14:32  rich
 * - Added ability to log data with direct connections.  Also fixed some
 * problems with global variables. It now uses broadcasts for watching variables.
 * - Added preliminary memory recovery routines to handle out of memory
 * conditions.  It currently purges items from resource queues.  Needs to
 * be tested.
 * - If the CENTRALHOST environment variable is not set, try the current
 * host.
 * - Fixed a problem with central registered messages that caused the parsed
 * formatters to be lost.
 * - Added const declarations where needed to the prototypes in tca.h.
 * - tcaGetConnections: Get the fd_set.  Needed for direct connections.
 * - Added tcaExecute and tcaExecuteWithConstraints.  Can "execute" a goal
 *   or command.
 * - tcaPreloadMessage: Preload the definition of a message from the
 *   central server.
 *
 * Revision 1.23  1995/03/19  19:39:30  rich
 * Implemented direct connections using tcaDirectResouce call.
 * Also made the basics.h file a module include.
 * Changed class in the interval structure to be interval_class to avoid a
 * conflict with C++.
 *
 * Revision 1.22  1995/01/30  16:18:01  rich
 * Added indications of message byte order and alignment to the message
 * header in the upper two bytes of the classID.
 * Now the receiver translates the byte order but must receive data in
 * "PACKED" alignment.
 * Made -gstabs come after -g for i386_mach machines so the debugger will work.
 *
 * Revision 1.21  1995/01/18  22:40:34  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.20  1994/11/02  21:34:13  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile.
 * Made libc.h and tcaMatrix.h module includes.
 * Reduced the size of libc.h by using more system includes.
 *
 * Revision 1.19  1994/05/31  03:24:01  rich
 * Removed CFLAGS_sun4.
 * Removed cfree and bzero from mem routines.
 * Set zero wait on both sides of the pipe.  Can connect to host using inet
 * number.
 *
 * Revision 1.18  1994/05/25  04:57:22  rich
 * Defined macros for registering simple messages and handlers at once.
 * Added function to ignore logging for all messages associated with a
 * global variable.
 * Moved module global variable routines to a new file so they are not
 * included in the .sa library file.  Gets better code sharing and lets you
 * debug these routines.
 * Added code to force the module variables to be re-initialized after the
 * server goes down.
 * tcaClose now will not crash if the server is down and frees some module
 * memory.
 * The command line flag "-u" turns off the simple user interface.
 * Added routines to free hash tables and id tables.
 *
 * Revision 1.17  1994/05/17  23:15:53  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.16  1994/05/05  00:49:35  rich
 * Removed duplicate includes.
 *
 * Revision 1.15  1994/05/05  00:46:17  rich
 * Added a gmake makefile GNUmakefile so that the system can be easily
 * compiled on different machines.
 * Can now create the targets: tarfile and ftp for creating versions for
 * export.
 *
 * Fixed a number of places were tcaExitHnd was not expected to return.
 * Set the tcaSeverGlobal to 0 when the socket is closed.
 *
 * Revision 1.14  1994/04/28  16:16:09  reids
 * Changes in TCA Version 7.6:
 *  1) New functions: tcaIgnoreLogging and tcaResumeLogging
 *  2) Code for MacIntosh (MPW) version of TCA
 *
 * Revision 1.13  1994/04/26  16:23:30  rich
 * Now you can register an exit handler before anything else and it will
 * get called if connecting to central fails.
 * Also added code to handle pipe breaks during writes.
 *
 * Revision 1.12  1994/04/16  19:42:17  rich
 * First release of TCA for the DEC alpha.
 * Changes were needed because longs are 64 bits.
 * Fixed alignment assumption in the data message format.
 * Fixed the way offsets are calculated for variable length arrays.  This
 * was a problem even without 64 bit longs and pointers.
 *
 * Added the commit date to the version information printed out with the -v
 * option.
 *
 * Now uses standard defines for byte order
 * (BYTE_ORDER = BIG_ENDIAN, LITTLE_ENDIAN or PDP_ENDIAN)
 *
 * Defined alignment types: ALIGN_INT ALINE_LONGEST and ALIGN_WORD.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.11  1993/12/14  17:33:44  rich
 * Changed getMGlobal to GET_M_GLOBAL and changed getSGlobal to
 * GET_S_GLOBAL to conform to Chris' software standards.
 *
 * Patched problem with connecting between machines with different byte
 * orders.  The real fix requires changing the way formats are stored.
 * Searching for structural similar formats does not guarantee that you
 * find the right format.
 *
 * Revision 1.10  1993/11/21  20:17:56  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.9  1993/10/21  16:13:53  rich
 * Fixed compiler warnings.
 *
 * Revision 1.8  1993/10/20  19:00:35  rich
 * Fixed bug with self registed messages in the lisp version.
 * Added new routine : tcaGetServerGlobal to get the server socket.
 * Fixed some bad global references for the lisp version.
 * Updated some prototypes.
 *
 * Revision 1.7  1993/08/30  23:14:00  fedor
 * Added SUN4 as well as sun4 compile flag.
 * Corrected Top level failure message name display with a define in dispatch.c
 *
 * Revision 1.6  1993/08/30  21:53:32  fedor
 * V7+V6+VXWORKS Everything compiles but there are initialization problems.
 *
 * Revision 1.5  1993/08/27  08:38:39  fedor
 * Pass 2 aat a V7+V6+VxWorks merge. Many many problems with pointless casting.
 *
 * Revision 1.4  1993/08/27  07:14:59  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.3  1993/08/23  16:01:28  rich
 * Changed the global include files so that they don't double include
 * system files.  This was causing problems on the mach machines.
 *
 * Revision 1.2  1993/08/20  00:26:06  fedor
 * commiting others changes
 *
 * Revision 1.1.1.1  1993/05/20  05:45:43  rich
 * Importing tca version 8
 *
 * Revision 8.1  1993/05/20  00:29:59  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:23:55  fedor
 * Added Logging.
 *
 * $Revision: 1.46 $
 * $Date: 1996/08/05 16:06:54 $
 * $Author: rich $
 *
 *****************************************************************************/

#ifndef INCglobalM
#define INCglobalM

#include "libc.h"

#include "tca.h"
#include "basics.h"
#include "tcerror.h"
#include "strList.h"
#ifdef DOS_FILE_NAMES
#include "tcaInter.h"
#ifndef NMP_IPC
#include "tcaMatri.h"
#endif
#include "formatte.h"
#else
#include "tcaInternal.h"
#ifndef NMP_IPC
#include "tcaMatrix.h"
#endif
#include "formatters.h"
#endif /* DOS_FILE_NAMES */

#include "datamsg.h"
#include "idtable.h"
#include "hash.h"
#include "list.h"

#include "key.h"

#ifdef DOS_FILE_NAMES
#include "behavior.h"
#else
#include "behaviors.h"
#endif

#include "resMod.h"
#include "monMod.h"

#include "tcaMem.h"

#include "dispatch.h"
#include "com.h"
#ifdef DOS_FILE_NAMES
#include "comModul.h"
#else
#include "comModule.h"
#endif /* DOS_FILE_NAMES */
#include "tcaRef.h"
#include "recvMsg.h"
#include "sendMsg.h"
#include "reg.h"
#ifdef DOS_FILE_NAMES
#include "centralM.h"
#else
#include "centralMsg.h"
#endif /* DOS_FILE_NAMES */
#include "logging.h"
#ifdef DOS_FILE_NAMES
#include "modLoggi.h"
#else
#include "modLogging.h"
#endif /* DOS_FILE_NAMES */
#include "modVar.h"

#ifdef NMP_IPC
#include "lex.h"
#endif

/***************************************/

typedef struct _TCA_CONTEXT {
  fd_set tcaConnectionListGlobal;
  fd_set tcaListenMaskGlobal;
  const char *servHostGlobal;

  HASH_TABLE_PTR moduleConnectionTable;
  HASH_TABLE_PTR handlerTable;
  HASH_TABLE_PTR messageTable;
  HASH_TABLE_PTR resourceTable;
  ID_TABLE_PTR hndIdTable;
  ID_TABLE_PTR msgIdTable;
  LIST_PTR tcaPendingRepliesGlobal;
  LIST_PTR tcaRefFreeList;
  int tcaMaxConnection;
  int32 parentRefGlobal; 
  int32 responseIssuedGlobal;
  int32 sendMessageRefGlobal;
  int32 listenPortNum;
  int tcaListenPort;
  int tcaListenSocket;
  int tcaServerReadGlobal;
  int tcaServerWriteGlobal;
  int32 willListen;
  STR_LIST_PTR tappedMsgs;
  STR_LIST_PTR broadcastMsgs;
  BOOLEAN directDefault;
  BOOLEAN valid;
  LIST_PTR queryNotificationList;
} TCA_CONTEXT_TYPE;

typedef struct _GM {
  DATA_MSG_BUF_PTR bufferToAlloc;
  CONST_FORMAT_PTR byteFormat;
  CONST_FORMAT_PTR charFormat;
  CONST_FORMAT_PTR doubleFormat;
  CONST_FORMAT_PTR floatFormat;
  CONST_FORMAT_PTR intFormat;
  CONST_FORMAT_PTR longFormat;
  CONST_FORMAT_PTR shortFormat;
  HASH_TABLE_PTR classFormatTable;
  HASH_TABLE_PTR formatNamesTable;
  LIST_ELEM_PTR listCellFreeListGlobal;
  LIST_PTR dataMsgBufferList;
  LIST_PTR listFreeListGlobal;
  TCA_TIME_POINT_TYPE tcaDefaultTimeGlobal;
  TCA_VERSION_TYPE versionGlobal;
#if defined(DBMALLOC)
  void *(*tcaMallocMemHnd)(const char*, int, SIZETYPE);
#elif defined(applec) || defined(THINK_C) || defined(VXWORKS)
  void *(*tcaMallocMemHnd)(size_t size);
#elif defined(__sgi)
  void *(*tcaMallocMemHnd)(unsigned int);
#else
  void *(*tcaMallocMemHnd)(unsigned long);
#endif
  const char *modNameGlobal, *servHostGlobal;
#if defined(LISP)
  char lispFlagGlobal;
#endif
  TRANSLATE_TYPE TransTable[MAXFORMATTERS+1];
#if defined(LISP)
  int32 (*lispBufferSizeGlobal)(int32 *, CONST_FORMAT_PTR, int32);
  long (*lispDecodeMsgGlobal)(CONST_FORMAT_PTR, BUFFER_PTR);
  long (*lispEncodeMsgGlobal)(CONST_FORMAT_PTR, int, BUFFER_PTR);
  int32 (*lispExitGlobal)(void);
  int32 (*lispReplyMsgGlobal)(char *);
#endif
  int32 DMFree, DMTotal, DMmin, DMmax;
  int32 directFlagGlobal;
  int32 expectedWaitGlobal;
  int32 freeMemRetryAmount;
  int32 inconsistentConstraintsGlobal[2];
  int32 mallocMemRetryAmount;
  BOOLEAN pipeBroken;
  unsigned long totalMemRequest;
  int32 indentGlobal;
  void (*dPrintBYTE_FN)(FILE *, const char *, int32);
  void (*dPrintUBYTE_FN)(FILE *, const char *, int32);
  void (*dPrintCHAR_FN)(FILE *, const char *, int32);
  void (*dPrintDOUBLE_FN)(FILE *, const double *, int32);
  void (*dPrintFLOAT_FN)(FILE *, const float *, int32);
  void (*dPrintFORMAT_FN)(FILE *, CONST_FORMAT_PTR, int32);
  void (*dPrintINT_FN)(FILE *, const int32 *, int32);
  void (*dPrintBOOLEAN_FN)(FILE *, const int32 *, int32);
  void (*dPrintLONG_FN)(FILE *, const long *, int32);
#ifndef NMP_IPC
  void (*dPrintMAP_FN)(FILE *, const genericMatrix *, CONST_FORMAT_PTR,
		       int, const void *);
#endif
  void (*dPrintSHORT_FN)(FILE *, const int16 *, int32);
  void (*dPrintSTR_FN)(FILE *, const char *, int32);
  void (*dPrintTCA_FN)(FILE *, const TCA_REF_TYPE *, int32);
  void (*dPrintTWOBYTE_FN)(FILE *, const char *, int32);
  void (*tcaExitHnd)(void);
  void (*tcaFreeMemoryHnd)(u_int32);
  int32 enableDistributedResponses;
  int32 willListen;
#if defined(LISP)
  TCA_REF_PTR lispRefSaveGlobal;
  int32 byteOrder;
  ALIGNMENT_TYPE alignment;
#endif
  TCA_REF_PTR tcaRootNodeGlobal;
  
  int32 sizeDM;
  int32 numAllocatedDM;

  LOG_PTR logList[3];
  LIST_PTR Message_Ignore_Set;

  char *Found_Key;

  fd_set externalMask;
  HASH_TABLE_PTR externalFdTable;
  
  TCA_CONTEXT_PTR currentContext;

  STR_LIST_PTR requiredResources;

  LIST_PTR moduleList;

#ifdef NMP_IPC
  /* Variables that are in GS_TYPE, but are now needed within a module
     (for parsing formats and printing data structures) */
  int32       Location;
  TokenPtr    TokenList;
  TokenPtr    TokenListHead;
  const char *ParseString;
  int32       lineNumGlobal;
  int32       cursorPosGlobal;
  int32       truncatedGlobal;
  /* main scratch buffer for printing */
  char        buffer[400];
#endif /* NMP_IPC */
} GM_TYPE, *GM_PTR;

#if defined(VXWORKS)
/* VX works needs to access the globals through a pointer. */

#define GET_M_GLOBAL(var) (gM->var)
#define mGlobalp() ((gM != NULL) && (gM->currentContext != NULL))

extern GM_PTR gM;

#else
/* In general, the globals can just be statically allocated. */

#define GET_M_GLOBAL(var) (gM.var)
#define mGlobalp() ((gM_ptr != NULL) && (gM.currentContext != NULL))

extern GM_TYPE gM;
extern GM_PTR  gM_ptr;
#endif

#define GET_C_GLOBAL(var) (GET_M_GLOBAL(currentContext->var))

void globalMInit(void);
void globalMFree(void);
void globalMInvalidate(void);
BOOLEAN isValidServerConnection(void);

#endif /* INCglobalM */
