/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: exception handling
 *
 * FILE: exception.h
 *
 * ABSTRACT:
 * 
 * exception code include.
 *
 * REVISION HISTORY
 *
 * $Log: exception.h,v $
 * Revision 1.8  1994/05/17  23:15:45  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.7  1993/12/01  18:03:26  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.6  1993/11/21  20:17:47  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.5  1993/08/30  21:53:24  fedor
 * V7+V6+VXWORKS Everything compiles but there are initialization problems.
 *
 * Revision 1.4  1993/08/27  08:38:33  fedor
 * Pass 2 aat a V7+V6+VxWorks merge. Many many problems with pointless casting.
 *
 * Revision 1.3  1993/08/27  07:14:45  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:17:26  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:42  rich
 * Importing tca version 8
 *
 * Revision 7.1  1993/05/20  00:29:44  rich
 * RTG - initial checkin of Chris Fedor's version 8 of tca
 *
 * Revision 1.2  1993/05/19  17:23:42  fedor
 * Added Logging.
 *
 * 31-Dec-91 Reid Simmons, School of Computer Science, CMU
 * Added facility to add exception handlers to class of messages, 
 *  rather than just a single task tree node.
 *
 * 21-May-91 Christopher Fedor, School of Computer Science, CMU
 * Revised to verion tca 5.x
 *
 * 25-Nov-89 Long-Ji Lin, School of Computer Science, CMU
 * created.
 *
 * $Revision: 1.8 $
 * $Date: 1994/05/17 23:15:45 $
 * $Author: rich $
 *
 *****************************************************************************/

#ifndef INCexception
#define INCexception

typedef struct {
  TCA_REF_PTR ref;
  const char *hndName;
} ADD_EXC_TYPE, *ADD_EXC_PTR;

typedef struct {
  const char *msgName, *hndName;
} ADD_EXC_MSG_TYPE, *ADD_EXC_MSG_PTR;

DISPATCH_HND_PTR chooseExceptionHandler(DISPATCH_PTR dispatch);
void reExecMsg(DISPATCH_PTR dispatch, DISPATCH_HND_PTR hnd);
void addMsgExceptions(MSG_PTR msg, TASK_TREE_NODE_PTR taskTreeNode);
void exceptionIntialize(void);

#endif /* INCexception */
