/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: communications
 *
 * FILE: comModule.c
 *
 * ABSTRACT:
 * 
 * Module Communications
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/com.h,v $ 
 * $Revision: 1.10 $
 * $Date: 1996/07/23 19:32:23 $
 * $Author: reids $
 *
 * REVISION HISTORY:
 *
 * $Log: com.h,v $
 * Revision 1.10  1996/07/23  19:32:23  reids
 * Changes to support Windows 95.
 *
 * Revision 1.9  1996/06/30  20:17:30  reids
 * Handling of polling monitors was severely broken.
 *
 * Revision 1.8  1996/05/09  18:30:28  reids
 * Changes to keep TCA consistent with the NASA IPC package.
 * Some bug fixes (mainly to do with freeing formatters).
 *
 * Revision 1.7  1996/02/21  18:30:05  rich
 * Created single event loop.
 *
 * Revision 1.6  1996/02/06  19:04:15  rich
 * Changes for VXWORKS pipes.  Note: the read and write sockets descriptors
 * can be different.
 *
 * Revision 1.5  1995/06/05  23:58:40  rich
 * Improve support of detecting broken pipes.  Add support for OSF 2.
 * Add return types to the global variable routines.
 *
 * Revision 1.4  1995/05/31  19:35:07  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.3  1995/04/09  20:30:05  rich
 * Added /usr/local/include and /usr/local/lib to the paths for compiling
 * for sunOS machines. (Support for new vendor OS).
 * Create a tca directory in /tmp and put the socket in there so others can
 * delete dead sockets.  The /tmp directory has the sticky bit set so you
 * can't delete files even if you have write permission on the directory.
 * Fixes to libc.h to use the new declarations in the gcc header files and
 * avoid problems with dbmalloc.
 *
 * Revision 1.2  1995/04/07  05:02:53  rich
 * Fixed GNUmakefiles to find the release directory.
 * Cleaned up libc.h file for sgi and vxworks.  Moved all system includes
 * into libc.h
 * Got direct queries to work.
 * Fixed problem in allocating/initializing generic mats.
 * The direct flag (-c) now mostly works.  Connect message has been extended to
 * indicate when direct connections are the default.
 * Problem with failures on sunOS machines.
 * Fixed problem where tcaError would not print out its message if logging had
 * not been initialized.
 * Fixed another memory problem in modVar.c.
 * Fixed problems found in by sgi cc compiler.  Many type problems.
 *
 * Revision 1.1  1995/04/04  19:53:06  rich
 * Forgot com.h and com.c.
 *
 *
 ****************************************************************/

#ifndef INCcom
#define INCcom

/* #define TCP 6 is really IPPROTO_TCP*/
#ifdef applec
#define IPPROTO_TCP 0
#endif /* applec */

#define BACKLOG 5
#define PROTOCOL_NAME "tcp"
#define HOST_NAME_SIZE   32

#define TCP_SOCKET_BUFFER (16*1024)
#define UNIX_SOCKET_BUFFER (32*1024)

/* The full name must be less than 14 characters. */
#define UNIX_DIR_NAME "/tmp/tca"
#define UNIX_SOCKET_NAME "/tmp/tca/%d"
#define VX_PIPE_NAME "/pipe/tca/%s_%s"
#define VX_PIPE_BUFFER (32*1024)
/*#define VX_PIPE_BUFFER (1024*1024)*/
#define VX_PIPE_NUM_BUF 6

#define MAX_SOCKET_PACKET UNIX_SOCKET_BUFFER

BOOLEAN connectAtPort(const char *machine, int32 port,
		      int *readSd, int *writeSd);
BOOLEAN connectAtSocket(const char *machine, int32 port,
			int *readSd, int *writeSd);
BOOLEAN connectAt(const char *machine, int32 port,
		  int *readSd, int *writeSd);
BOOLEAN connectSocket(const char *servHost, int *readSd, int *writeSd);
BOOLEAN listenAtPort(int32 *port, int *sd);
BOOLEAN listenAtSocket(int32 port, int *sd);
#if defined(_WINSOCK_) & defined(WIN95)
void closeSocket(int port);
#else
void closeSocket(int32 port);
#endif

#if defined(applec) | defined(VXWORKS) | defined(_WINSOCK_)
/* Not defined in many environments */ 
extern struct timeval *gettimeofday(struct timeval *, void *);
#endif
extern unsigned long timeInMsecs (void);

#endif /* INCcom */
