/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 * 
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 * 
 * MODULE: communications
 *
 * FILE: centralMsg.h
 *
 * ABSTRACT:
 * 
 * Central message definitions.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/centralMsg.h,v $ 
 * $Revision: 1.10 $
 * $Date: 1996/02/06 19:04:11 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: centralMsg.h,v $
 * Revision 1.10  1996/02/06  19:04:11  rich
 * Changes for VXWORKS pipes.  Note: the read and write sockets descriptors
 * can be different.
 *
 * Revision 1.9  1996/01/27  21:52:56  rich
 * Pre-release of 8.4.
 * Added recursive named formatters and "BAD" formats.  Also incorporated
 * Iain's windows changes.
 *
 * Revision 1.8  1995/10/29  18:26:26  rich
 * Initial creation of 8.3. Added changes made after 8.2 branch was
 * created. These mostly have to do with context switching.
 *
 * Revision 1.7  1995/10/25  22:47:56  rich
 * Fixed problems with context switching.  Now the context is a separate
 * data structure accessed from the module data structure, using the
 * currentContext field.  GET_C_GLOBAL is used instead of GET_M_GLOBAL for
 * the context dependent fields.
 *
 * Revision 1.6  1995/10/07  19:06:58  rich
 * Pre-alpha release of tca-8.2.
 * Added PROJECT_DIR. Added tcaWillListen.
 * Only transmit broadcast messages when there is a handler to receive them.
 * All system messages now start with "tca_".  Old messages are also supported.
 *
 * Revision 1.5  1995/07/12  04:54:20  rich
 * Release of 8.0.
 * Fixed problems with sending between machines of different endien.
 *
 * Revision 1.4  1995/04/07  05:02:48  rich
 * Fixed GNUmakefiles to find the release directory.
 * Cleaned up libc.h file for sgi and vxworks.  Moved all system includes
 * into libc.h
 * Got direct queries to work.
 * Fixed problem in allocating/initializing generic mats.
 * The direct flag (-c) now mostly works.  Connect message has been extended to
 * indicate when direct connections are the default.
 * Problem with failures on sunOS machines.
 * Fixed problem where tcaError would not print out its message if logging had
 * not been initialized.
 * Fixed another memory problem in modVar.c.
 * Fixed problems found in by sgi cc compiler.  Many type problems.
 *
 * Revision 1.3  1995/03/28  01:14:20  rich
 * - Added ability to log data with direct connections.  Also fixed some
 * problems with global variables. It now uses broadcasts for watching variables.
 * - Added preliminary memory recovery routines to handle out of memory
 * conditions.  It currently purges items from resource queues.  Needs to
 * be tested.
 * - If the CENTRALHOST environment variable is not set, try the current
 * host.
 * - Fixed a problem with central registered messages that caused the parsed
 * formatters to be lost.
 * - Added const declarations where needed to the prototypes in tca.h.
 * - tcaGetConnections: Get the fd_set.  Needed for direct connections.
 * - Added tcaExecute and tcaExecuteWithConstraints.  Can "execute" a goal
 *   or command.
 * - tcaPreloadMessage: Preload the definition of a message from the
 *   central server.
 *
 * Revision 1.2  1994/05/25  17:32:29  reids
 * Added utilities to limit the number of pending messages
 *
 * Revision 1.1  1994/05/17  23:15:17  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 *
 ****************************************************************/

#ifndef INCcentralMsg
#define INCcentralMsg

#define TCA_MSG_INFO_QUERY        "tca_msgInfoMsg"
#define TCA_MSG_INFO_QUERY_OLD     "msgInfoMsg"
#define TCA_MSG_INFO_QUERY_FORMAT "{string, string}"
#define TCA_MSG_INFO_QUERY_REPLY  "*{int, string, int, format, format}"

#define TCA_MESSAGES_QUERY        "tca_getMessages"
#define TCA_MESSAGES_QUERY_FORMAT NULL
#define TCA_MESSAGES_QUERY_REPLY  TCA_STR_LIST_FORMAT

#define TCA_MESSAGE_INFO_QUERY        "tca_getMessageInfo"
#define TCA_MESSAGE_INFO_QUERY_FORMAT "{string}"
#define TCA_MESSAGE_INFO_QUERY_REPLY  "{string,string,string,int,string,int}"

#define TCA_HND_INFO_QUERY        "tca_hndInfoMsg"
#define TCA_HND_INFO_QUERY_OLD    "hndInfoMsg"
#define TCA_HND_INFO_QUERY_FORMAT TCA_MSG_INFO_QUERY_FORMAT
#define TCA_HND_INFO_QUERY_REPLY  TCA_MSG_INFO_QUERY_FORMAT

#define TCA_CLASS_INFO_QUERY        "tca_classInfoMsg"
#define TCA_CLASS_INFO_QUERY_OLD    "classInfoMsg"
#define TCA_CLASS_INFO_QUERY_FORMAT "int"
#define TCA_CLASS_INFO_QUERY_REPLY  "*{int, format}"

#define TCA_PROVIDES_INFORM        "tca_moduleProvides"
#define TCA_PROVIDES_INFORM_FORMAT TCA_STR_LIST_FORMAT

#define TCA_REQUIRES_INFORM        "tca_moduleRequires"
#define TCA_REQUIRES_INFORM_FORMAT TCA_STR_LIST_FORMAT

#define TCA_AVAILABLE_QUERY        "tca_available"
#define TCA_AVAILABLE_QUERY_FORMAT NULL
#define TCA_AVAILABLE_QUERY_REPLY  TCA_STR_LIST_FORMAT

#define TCA_CONNECT_QUERY        "tca_newModuleConnectMsg"
#define TCA_CONNECT_QUERY_OLD    "newModuleConnectMsg"
#define TCA_CONNECT_QUERY_FORMAT "{string, string}"
#define TCA_CONNECT_QUERY_REPLY  "{{int, int},boolean}"

#define TCA_REGISTER_MSG_INFORM        "tca_registerMessageMsg"
#define TCA_REGISTER_MSG_INFORM_OLD    "registerMessageMsg"
#define TCA_REGISTER_MSG_INFORM_FORMAT "{string, int, string, string}"

#define TCA_REGISTER_HND_INFORM        "tca_registerHandlerMsg"
#define TCA_REGISTER_HND_INFORM_OLD    "registerHandlerMsg"
#define TCA_REGISTER_HND_INFORM_FORMAT "{int, string, string}"

#define TCA_DEREGISTER_HND_INFORM        "tca_deregisterHandlerMsg"
#define TCA_DEREGISTER_HND_INFORM_OLD    "deregisterHandlerMsg"
#define TCA_DEREGISTER_HND_INFORM_FORMAT "{int, string, string}"

#define TCA_NAMED_FORM_INFORM        "tca_registerNamedFormMsg"
#define TCA_NAMED_FORM_INFORM_OLD    "registerNamedFormMsg"
#define TCA_NAMED_FORM_INFORM_FORMAT "{string, string}"

#define TCA_NAMED_FORM_QUERY        "tca_getNamedFormMsg"
#define TCA_NAMED_FORM_QUERY_FORMAT "string"
#define TCA_NAMED_FORM_QUERY_REPLY  "format"

#define TCA_WAIT_QUERY        "tca_waitMsg"
#define TCA_WAIT_QUERY_OLD    "waitMsg"
#define TCA_WAIT_QUERY_FORMAT NULL
#define TCA_WAIT_QUERY_REPLY  "int"

#define TCA_IGNORE_LOGGING_INFORM        "tca_ignoreLogging"
#define TCA_IGNORE_LOGGING_INFORM_OLD    "ignoreLogging"
#define TCA_IGNORE_LOGGING_INFORM_FORMAT "string"

#define TCA_RESUME_LOGGING_INFORM        "tca_resumeLogging"
#define TCA_RESUME_LOGGING_INFORM_OLD    "resumeLogging"
#define TCA_RESUME_LOGGING_INFORM_FORMAT "string"

#define TCA_CLOSE_INFORM        "tca_CloseMsg"
#define TCA_CLOSE_INFORM_OLD    "tcaCloseMsg"
#define TCA_CLOSE_INFORM_FORMAT NULL

#define TCA_DIRECT_RES_INFORM        "tca_directResMsg"
#define TCA_DIRECT_RES_INFORM_OLD    "directResMsg"
#define TCA_DIRECT_RES_INFORM_FORMAT "{int, string}"

#define TCA_DIRECT_INFO_QUERY        "tca_directInfoMsg"
#define TCA_DIRECT_INFO_QUERY_OLD    "directInfoMsg"
#define TCA_DIRECT_INFO_QUERY_FORMAT "string"
#define TCA_DIRECT_INFO_QUERY_REPLY  DIRECT_INFO_FORMAT

#define TCA_MAP_NAMED         "map"
#define TCA_MAP_NAMED_FORMAT  "fmat"

#define TCA_REGISTER_RESOURCE_INFORM        "tca_registerResourceMsg"
#define TCA_REGISTER_RESOURCE_INFORM_OLD    "registerResourceMsg"
#define TCA_REGISTER_RESOURCE_INFORM_FORMAT "{int, string}"

#define TCA_HANDLER_TO_RESOURCE_INFORM        "tca_addHndToResourceMsg"
#define TCA_HANDLER_TO_RESOURCE_INFORM_OLD    "addHndToResourceMsg"
#define TCA_HANDLER_TO_RESOURCE_INFORM_FORMAT "{string, string}"

#define TCA_LIMIT_PENDING_INFORM        "tca_limitPendingMsg"
#define TCA_LIMIT_PENDING_INFORM_OLD    "limitPendingMsg"
#define TCA_LIMIT_PENDING_INFORM_FORMAT "{string, string, int}"

#define TCA_RESERVE_RESOURCE_QUERY        "tca_reserveResourceMsg"
#define TCA_RESERVE_RESOURCE_QUERY_OLD    "reserveResourceMsg"
#define TCA_RESERVE_RESOURCE_QUERY_FORMAT "string"
#define TCA_RESERVE_RESOURCE_QUERY_REPLY  "int"

#define TCA_RESERVE_MOD_RESOURCE_QUERY        "tca_reserveModResourceMsg"
#define TCA_RESERVE_MOD_RESOURCE_QUERY_OLD    "reserveModResourceMsg"
#define TCA_RESERVE_MOD_RESOURCE_QUERY_FORMAT "{string,string}"
#define TCA_RESERVE_MOD_RESOURCE_QUERY_REPLY  "int"

#define TCA_CANCEL_RESOURCE_INFORM        "tca_cancelReservationMsg"
#define TCA_CANCEL_RESOURCE_INFORM_OLD    "cancelReservationMsg"
#define TCA_CANCEL_RESOURCE_INFORM_FORMAT "int"

#define TCA_LOCK_RESOURCE_QUERY        "tca_lockResourceMsg"
#define TCA_LOCK_RESOURCE_QUERY_OLD    "lockResourceMsg"
#define TCA_LOCK_RESOURCE_QUERY_FORMAT "string"
#define TCA_LOCK_RESOURCE_QUERY_REPLY  "int"

#define TCA_LOCK_MOD_RESOURCE_QUERY        "tca_lockModResourceMsg"
#define TCA_LOCK_MOD_RESOURCE_QUERY_OLD    "lockModResourceMsg"
#define TCA_LOCK_MOD_RESOURCE_QUERY_FORMAT "{string, string}"
#define TCA_LOCK_MOD_RESOURCE_QUERY_REPLY  "int"

#define TCA_UNLOCK_RESOURCE_INFORM        "tca_unlockResourceMsg"
#define TCA_UNLOCK_RESOURCE_INFORM_OLD    "unlockResourceMsg"
#define TCA_UNLOCK_RESOURCE_INFORM_FORMAT "int"

#define TCA_REG_MONITOR_INFORM        "tca_regMonitorMsg"
#define TCA_REG_MONITOR_INFORM_OLD        "regMonitorMsg"
#define TCA_REG_MONITOR_INFORM_FORMAT "{int, string, string, string, string}"

#define TCA_DELAY_CMD        "tca_DelayCommand"
#define TCA_DELAY_CMD_OLD    "tcaDelayCommand"
#define TCA_DELAY_CMD_FORMAT "int"

#define TCA_TAP_REF_INFORM     "tca_tapReference"
#define TCA_TAP_REF_INFORM_OLD "tapReference"
#define TCA_TAP_REF_INFORM_FORM "{int, TCA_REF_PTR, string}"

#define TCA_TAP_MSG_INFORM      "tca_tapMessage"
#define TCA_TAP_MSG_INFORM_OLD  "tapMessage"
#define TCA_TAP_MSG_INFORM_FORM "{int, string, string}"

#define TCA_REMOVE_TAP_INFORM     "tca_removeTap"
#define TCA_REMOVE_TAP_INFORM_OLD "removeTap"
#define TCA_REMOVE_TAP_INFORM_FORM TCA_TAP_MSG_INFORM_FORM

#define TCA_FIND_TAP_INFORM      "tca_findTappedReference"
#define TCA_FIND_TAP_INFORM_OLD  "findTappedReference"
#define TCA_FIND_TAP_INFORM_FORM "int"

#define TCA_CONTRAINT_INFORM        "tca_tplConstrain"
#define TCA_CONTRAINT_INFORM_OLD    "tplConstrain"
#define TCA_CONTRAINT_INFORM_FORMAT "{TimePoint, string, TimePoint}"

#define TCA_REGISTER_VAR_INFORM        "tca_registerGlobalVar"
#define TCA_REGISTER_VAR_INFORM_OLD    "registerGlobalVar"
#define TCA_REGISTER_VAR_INFORM_FORMAT "{string,string}"

/* Task Tree Messages */

#define TCA_CREATE_REF_QUERY        "tca_createRefMsg"
#define TCA_CREATE_REF_QUERY_OLD    "createRefMsg"
#define TCA_CREATE_REF_QUERY_FORMAT "int"
#define TCA_CREATE_REF_QUERY_REPLY  "int"

#define TCA_ADD_CHILD_QUERY        "tca_addChildRef"
#define TCA_ADD_CHILD_QUERY_OLD    "addChildRef"
#define TCA_ADD_CHILD_QUERY_FORMAT "{int, int}"
#define TCA_ADD_CHILD_QUERY_REPLY  "int"

#define TCA_FIND_PARENT_QUERY        "tca_findParentRef"
#define TCA_FIND_PARENT_QUERY_OLD    "findParentRef"
#define TCA_FIND_PARENT_QUERY_FORMAT "int"
#define TCA_FIND_PARENT_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_FIRST_CHILD_QUERY        "tca_findFirstChild"
#define TCA_FIRST_CHILD_QUERY_OLD    "findFirstChild"
#define TCA_FIRST_CHILD_QUERY_FORMAT "int"
#define TCA_FIRST_CHILD_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_LAST_CHILD_QUERY        "tca_findLastChild"
#define TCA_LAST_CHILD_QUERY_OLD    "findLastChild"
#define TCA_LAST_CHILD_QUERY_FORMAT "int"
#define TCA_LAST_CHILD_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_NEXT_CHILD_QUERY        "tca_findNextChild"
#define TCA_NEXT_CHILD_QUERY_OLD    "findNextChild"
#define TCA_NEXT_CHILD_QUERY_FORMAT "int"
#define TCA_NEXT_CHILD_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_PREV_CHILD_QUERY        "tca_findPrevChild"
#define TCA_PREV_CHILD_QUERY_OLD    "findPrevChild"
#define TCA_PREV_CHILD_QUERY_FORMAT "int"
#define TCA_PREV_CHILD_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_FAILED_CHILD_QUERY        "tca_findFailedRef"
#define TCA_FAILED_CHILD_QUERY_OLD    "findFailedRef"
#define TCA_FAILED_CHILD_QUERY_FORMAT "int"
#define TCA_FAILED_CHILD_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_FIND_TOPLEVEL_QUERY        "tca_findTopLevelRef"
#define TCA_FIND_TOPLEVEL_QUERY_OLD    "findTopLevelRef"
#define TCA_FIND_TOPLEVEL_QUERY_FORMAT "int"
#define TCA_FIND_TOPLEVEL_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_ANTE_BY_NAME_QUERY        "tca_findAnteRefByName"
#define TCA_ANTE_BY_NAME_QUERY_OLD    "findAnteRefByName"
#define TCA_ANTE_BY_NAME_QUERY_FORMAT "{int, string}"
#define TCA_ANTE_BY_NAME_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_CHILD_BY_NAME_QUERY        "tca_findChildByName"
#define TCA_CHILD_BY_NAME_QUERY_OLD    "findChildByName"
#define TCA_CHILD_BY_NAME_QUERY_FORMAT "{int, string}"
#define TCA_CHILD_BY_NAME_QUERY_REPLY  "TCA_REF_PTR"

#define TCA_KILL_TREE_INFORM        "tca_killTaskTree"
#define TCA_KILL_TREE_INFORM_OLD    "killTaskTree"
#define TCA_KILL_TREE_INFORM_FORMAT "int"

#define TCA_KILL_SUBTREE_INFORM        "tca_killSubTaskTree"
#define TCA_KILL_SUBTREE_INFORM_OLD    "killSubTaskTree"
#define TCA_KILL_SUBTREE_INFORM_FORMAT "int"

#define TCA_DISPLAY_TREE_INFORM        "tca_displayTaskTree"
#define TCA_DISPLAY_TREE_INFORM_OLD    "displayTaskTree"
#define TCA_DISPLAY_TREE_INFORM_FORMAT "int"

#define TCA_REF_DATA_QUERY        "tca_referenceData"
#define TCA_REF_DATA_QUERY_OLD    "referenceData"
#define TCA_REF_DATA_QUERY_FORMAT "int"
#define TCA_REF_DATA_QUERY_REPLY  NULL

#define TCA_REF_RELEASE_INFORM        "tca_referenceRelease"
#define TCA_REF_RELEASE_INFORM_OLD    "referenceRelease"
#define TCA_REF_RELEASE_INFORM_FORMAT "int"

#define TCA_REF_STATUS_QUERY        "tca_referenceStatusMsg"
#define TCA_REF_STATUS_QUERY_OLD    "referenceStatusMsg"
#define TCA_REF_STATUS_QUERY_FORMAT "int"
#define TCA_REF_STATUS_QUERY_REPLY  "int"

/* Define constants for central varibles. */

#define TCA_TERMINAL_LOG_VAR  "CENTRAL_TERMINAL_LOG_VAR"
#define TCA_FILE_LOG_VAR  "CENTRAL_FILE_LOG_VAR"
/*#define TCA_LOG_VAR_FORMAT "{FILE,int,int,int,int,int,int,int,int,int,int,int}"*/
#define TCA_LOG_VAR_FORMAT "{*int,int,int,int,int,int,int,int,int,int,int,int}"

#define TCA_CENTRAL_MODULE_DATA_VAR "CENTRAL_MOD_VAR"

#define TCA_MOD_DATA_NAME "TCA_MOD_DATA"
#define TCA_MOD_DATA_FORMAT "{string,string}"

#define TCA_LIST_NAME "TCA_LIST"
#define TCA_LIST_FORMAT "*int"

#define TCA_RESOURCE_STATUS_NAME "TCA_RESOURCE_STATUS"
#define TCA_RESOURCE_STATUS_FORMAT "int"
#define TCA_RESOURCE_FORMAT "int,string,int,*int,RESOURCE_STATUS,TCA_LIST,TCA_LIST,int,LIST_PTR"
#define TCA_MODULE_DATA_VAR_FORMAT "int,int,int,int,*MOD_DATA_TYPE,*_RESOURCE,*_LIST,*_LIST"

#define TCA_ADD_EXCEP_INFORM        "tca_addExcepMsg"
#define TCA_ADD_EXCEP_INFORM_OLD    "addExcepMsg"
#define TCA_ADD_EXCEP_INFORM_FORMAT "{TCA_REF_PTR, string}"

#define TCA_ADD_EXCEPTIONS_INFORM     "tca_addExceptions"
#define TCA_ADD_EXCEPTIONS_INFORM_OLD "addExceptions"
#define TCA_ADD_EXCEPTIONS_INFORM_FORMAT "{string, string}"

#define TCA_RETRY_EXCEP_INFORM     "tca_retryExcepMsg"
#define TCA_RETRY_EXCEP_INFORM_OLD "retryExcepMsg"
#define TCA_RETRY_EXCEP_INFORM_FORMAT "TCA_REF_PTR"

#define TCA_BYPASS_EXCEP_INFORM     "tca_byPassExcepMsg"
#define TCA_BYPASS_EXCEP_INFORM_OLD "byPassExcepMsg"
#define TCA_BYPASS_EXCEP_INFORM_FORMAT "TCA_REF_PTR"

#define TCA_GET_INFO_EXCEP_QUERY      "tca_getInfoExcepMsg"
#define TCA_GET_INFO_EXCEP_QUERY_OLD  "getInfoExcepMsg"
#define TCA_GET_INFO_EXCEP_QUERY_FORMAT "{TCA_REF_PTR, TCA_REF_PTR, int}"

#define TCA_KILL_TASK_TREE_EXCEP     "tca_killTaskTreeException"
#define TCA_KILL_TASK_TREE_EXCEP_OLD "killTaskTreeException"
#define TCA_KILL_TASK_TREE_EXCEP_FORMAT (char *)NULL

#define TCA_CLEANUP_AFTER_ACHIEVED_INFORM     "tca_cleanUpAfterAchieved"
#define TCA_CLEANUP_AFTER_ACHIEVED_INFORM_OLD "cleanUpAfterAchieved"
#define TCA_CLEANUP_AFTER_ACHIEVED_INFORM_FORMAT (char *)NULL

#endif /* INCcentralMsg */
