/******************************************************************************
 *
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture 
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: behaviors
 *
 * FILE: behaviors.c
 *
 * ABSTRACT:
 * 
 * tca behavior level.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/behaviors.h,v $ 
 * $Revision: 1.18 $
 * $Date: 1996/08/05 16:06:42 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: behaviors.h,v $
 * Revision 1.18  1996/08/05  16:06:42  rich
 * Added comments to endifs.
 *
 * Revision 1.17  1996/05/09  18:30:20  reids
 * Changes to keep TCA consistent with the NASA IPC package.
 * Some bug fixes (mainly to do with freeing formatters).
 *
 * Revision 1.16  1996/05/07  16:49:16  rich
 * Changes for clisp.
 *
 * Revision 1.15  1996/03/15  21:13:19  reids
 * Added tcaQueryNotify and plugged a memory leak -- ref was not being
 *   freed when inform/broadcast handler completed.
 *
 * Revision 1.14  1996/03/05  05:04:14  reids
 * Changes (mainly delineated by NMP_IPC conditionals) to support the
 *   New Millennium IPC.
 *
 * Revision 1.13  1996/02/10  16:49:28  rich
 * Fixed header problems and a crash related to direct connections.
 *
 * Revision 1.12  1996/01/27  21:52:53  rich
 * Pre-release of 8.4.
 * Added recursive named formatters and "BAD" formats.  Also incorporated
 * Iain's windows changes.
 *
 * Revision 1.11  1995/07/12  04:54:12  rich
 * Release of 8.0.
 * Fixed problems with sending between machines of different endien.
 *
 * Revision 1.10  1995/05/31  19:35:00  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.9  1995/04/08  02:06:16  rich
 * Added waitForReplyFrom to be able to block on replies from only one
 * source.  Useful when querying for the msg info information.  Added a
 * tcaQueryCentral that only accepts input from the central server.  Fixed
 * timing problems with direct connections.
 *
 * Revision 1.8  1995/01/18  22:39:38  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.7  1994/05/17  23:15:09  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.6  1994/04/16  19:41:36  rich
 * First release of TCA for the DEC alpha.
 * Changes were needed because longs are 64 bits.
 * Fixed alignment assumption in the data message format.
 * Fixed the way offsets are calculated for variable length arrays.  This
 * was a problem even without 64 bit longs and pointers.
 *
 * Added the commit date to the version information printed out with the -v
 * option.
 *
 * Now uses standard defines for byte order
 * (BYTE_ORDER = BIG_ENDIAN, LITTLE_ENDIAN or PDP_ENDIAN)
 *
 * Defined alignment types: ALIGN_INT ALINE_LONGEST and ALIGN_WORD.
 *
 * *** WARNING ***
 * sending longs between alphas and non-alpha machines will probably not work.
 * *** WARNING ***
 *
 * Revision 1.5  1993/12/01  18:02:37  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.4  1993/11/21  20:17:09  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.3  1993/08/30  21:53:02  fedor
 * V7+V6+VXWORKS Everything compiles but there are initialization problems.
 *
 * Revision 1.2  1993/08/27  08:38:20  fedor
 * Pass 2 aat a V7+V6+VxWorks merge. Many many problems with pointless casting.
 *
 * Revision 1.1  1993/08/27  07:14:07  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.4  1993/08/23  17:37:31  rich
 * Fixed the type definitions for function pointers. Added const
 * declarations.  Removed definitions VOID_FN and INT_FN.
 *
 * Revision 1.3  1993/07/08  05:38:08  rich
 * Added function prototypes
 *
 * Revision 1.2  1993/05/27  22:16:08  rich
 * Added automatic logging.
 *
 *
 ****************************************************************/

#ifndef INCbehaviors
#define INCbehaviors

const char *messageClassName(TCA_MSG_CLASS_TYPE msg_class);
void checkMessageClass(MSG_PTR msg, TCA_MSG_CLASS_TYPE msg_class);
void execHnd(DIRECT_INFO_PTR directInfo, DATA_MSG_PTR dataMsg);
BOOLEAN execFdHnd(int fd);
MSG_PTR msgFind(const char *name);
CONST_FORMAT_PTR fmtFind(const char *name);
int32 testInconsistent(int32 tplConstraints);

TCA_RETURN_VALUE_TYPE tcaQueryFd(const char *name,
				 void *queryData,
				 void *replyData,
				 int fd);

TCA_RETURN_VALUE_TYPE tcaQueryCentral(const char *name,
				      void *queryData,
				      void *replyData);

MSG_PTR msgFind2(const char *name, const char *hndName);

TCA_RETURN_VALUE_TYPE _tcaQueryNotify(const char *name, void *query, 
				      REPLY_HANDLER_FN replyHandler, 
				      HND_LANGUAGE_ENUM language,
				      void *clientData);

#if defined(LISP)
void tcaSetSizeEncodeDecode(int (* bufferSize)(int32 *, CONST_FORMAT_PTR, int),
			    long (* encode)(CONST_FORMAT_PTR, int, BUFFER_PTR),
			    long (* decode)(CONST_FORMAT_PTR, BUFFER_PTR), 
			    int (* lispReply)(char *), 
			    int (* lispExit)(void));
TCA_REF_PTR tcaQuerySendRefLISPC (void);
#endif /* LISP */

#ifdef NMP_IPC
/* Three-argument handler type, for NMP IPC */
typedef void (*IPC_HANDLER_TYPE)(TCA_REF_PTR ref, void *callData,
				 void *clientData);

typedef struct { int length;
		 void *content;
	       } *IPC_VAR_DATA_PTR;

FORMAT_CLASS_TYPE ipcFormatClassType (CONST_FORMAT_PTR format);

/* Pick out the byte array in the data -- eventually replace */
char *ipcData (CONST_FORMAT_PTR formatter, char *data);
#endif /* NMP_IPC */

TCA_RETURN_VALUE_TYPE queryNotifySend (MSG_PTR msg, const char *name,
				       void *query,
				       REPLY_HANDLER_FN replyHandler, 
				       HND_LANGUAGE_ENUM language,
				       void *clientData);

#endif /* INCbehaviors */
