/**************************************************************************
 * 
 * PROJECT: Task Control Architecture.
 *
 * MODULE: list
 *
 * FILE: list.h
 *
 * ABSTRACT: The list module provides basic list creation and manipulation
 * routines and serves as the base abstract data type for the tca.
 * The include file list.h provides the top level routines for other modules.
 *
 * EXPORTS:
 *
 * REVISION HISTORY:
 *
 * $Log: list.h,v $
 * Revision 1.14  1995/12/17  20:21:37  rich
 * Have free routines set pointers to NULL.
 * Removed old makefiles.
 *
 * Revision 1.13  1995/12/15  01:23:19  rich
 * Moved Makefile to Makefile.generic to encourage people to use
 * GNUmakefile.
 * Fixed a memory leak when a module is closed and some other small fixes.
 *
 * Revision 1.12  1995/10/25  22:48:33  rich
 * Fixed problems with context switching.  Now the context is a separate
 * data structure accessed from the module data structure, using the
 * currentContext field.  GET_C_GLOBAL is used instead of GET_M_GLOBAL for
 * the context dependent fields.
 *
 * Revision 1.11  1995/07/06  21:16:53  rich
 * Solaris and Linux changes.
 *
 * Revision 1.10  1995/05/31  19:35:52  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.9  1995/03/30  15:43:15  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added simple list of strings data structure that can be passed via tca
 * messages.
 * Use the string list to maintain a global variable of messages with taps.
 * Tapped messages are not sent via direct connections.
 * Implemented code to vectorize data to be sent so that it does not have
 * to be copied.  Currently, only flat, packed data structures are
 * vectored.  This can now be easily extended.
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 * Fixed bug were central would try and free the "***New Module***" and
 * "*** Unkown Host***" strings when a module crashed on startup.
 * Fixed a bug reported by Jay Gowdy where the code to find the size of a
 * variable lenght array would access already freed data when called from
 * tcaFreeData.
 *
 * Revision 1.8  1995/01/18  22:41:06  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.7  1994/05/17  23:16:18  rich
 * Added global variables and associated routines.
 * Added some error checking.  The central connection is now set to -1
 * rather than zero to prevent tca messages from being send to stdout.
 * Now compiles on the sgi machines.  Still need to have the endian and
 * alignment figured out automatically.
 *
 * Revision 1.6  1993/12/01  18:03:49  rich
 * Fixed a problem with the port number being double converted to network
 * byte order.
 * Some general cleanup.
 *
 * Revision 1.5  1993/11/21  20:18:14  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.4  1993/08/27  08:38:46  fedor
 * Pass 2 aat a V7+V6+VxWorks merge. Many many problems with pointless casting.
 *
 * Revision 1.3  1993/08/27  07:15:26  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.2  1993/05/26  23:18:01  rich
 * Fixed up the comments at the top of the file.
 *
 * Revision 1.1.1.1  1993/05/20  05:45:45  rich
 * Importing tca version 8
 *
 * Revision 1.2  1993/05/19  17:24:26  fedor
 * Added Logging.
 *
 * See list.c for history.
 *
 * $Revision: 1.14 $
 * $Date: 1995/12/17 20:21:37 $
 * $Author: rich $
 *
 **************************************************************************/

#ifndef INClist
#define INClist

typedef struct _LIST_ELEM {
  const char *item;
  struct _LIST_ELEM *next, *previous;
} LIST_ELEM_TYPE, *LIST_ELEM_PTR;

typedef struct _LIST {
  int32 length;
  LIST_ELEM_PTR first, last, next;
  struct _LIST *freeList;
} LIST_TYPE, *LIST_PTR;

#define LIST_INC_AMOUNT      10
#define LIST_CELL_INC_AMOUNT 10

typedef BOOLEAN 
(* LIST_ITER_FN)(const void *, const char *);

typedef void 
(* LIST_FREE_FN)(void *);

void listFree(LIST_PTR *list);

#if defined(DBMALLOC)
LIST_PTR listDBCreate(const char* file, int line);
#define listCreate() listDBCreate(__FILE__,__LINE__)
#else
LIST_PTR listCreate(void);
#endif

void listInsertItemFirst(const void *item, LIST_PTR list);
void listInsertItemLast(const void *item, LIST_PTR list);
void listInsertItemAfter(const void *item, void *after, LIST_PTR list);

const void *listPopItem(LIST_PTR list);
#define listPushItem(item,list) listInsertItemFirst(item,list)
void listTestDeleteItem(LIST_ITER_FN func, const void *param,
			LIST_PTR list);
void listTestDeleteItemAll(LIST_ITER_FN func,
			   const void *param,
			   LIST_PTR list);
void listFreeAllItems(LIST_FREE_FN func, LIST_PTR list);
int32 listItemEq(void *a, void *b);
void listDeleteItem(const void *item, LIST_PTR list);
void listDeleteItemAll(const void *item, LIST_PTR list);

int32 listMemberItem(const void *item, LIST_PTR list);
const void *listMemReturnItem(LIST_ITER_FN func,
			      const void *param,
			      LIST_PTR list);

int32 listIterateFromFirst(LIST_ITER_FN func, const void *param,
			   LIST_PTR list);
int32 listIterateFromLast(LIST_ITER_FN func, const void *param,
			  LIST_PTR list);

LIST_PTR listCopy(LIST_PTR list);
void listInsertItem(const void *item, LIST_PTR list);

int32 listIterate(LIST_ITER_FN func, const void *param, LIST_PTR list);
int32 listLength(LIST_PTR list);
int32 listEqual(LIST_PTR list1, LIST_PTR list2);

LIST_PTR listMake1(const void *item);
LIST_PTR listMake2(const void *item1, const void *item2);

const void *listFirst(LIST_PTR list);
const void *listLast(LIST_PTR list);
const void *listNext(LIST_PTR list);

void listCleanup(void);

#endif /* INClist */
